/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports;

import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.reports.json.CpatJsonIgnore;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledMap;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import java.util.Comparator;
import java.util.Map;

public final class PDBAnalysisSummary {
    @TextProperty(labelKey="PDB_0_NAME_LABEL", section=TextReportSectionName.PDB_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The name of the PDB")
    private final String pdbName;
    @TextProperty(labelKey="PDB_1_REPORT_RESULT_LABEL", section=TextReportSectionName.PDB_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="Overall result of running the Cloud Premigration Advisor tool against this PDB.")
    private final CheckResult analysisResult;
    @CpatJsonPropertyDescription(value="Display text for the overall result of running the Cloud Premigration Advisor tool against this PDB.")
    private final String analysisResultDisplayText;
    @TextProperty(labelKey="PDB_2_ANALYSIS_DURATION_LABEL", section=TextReportSectionName.PDB_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.DURATION_SECONDS)
    @CpatJsonPropertyDescription(value="The elapsed time to run CPAT on this PDB in seconds")
    private final Long analysisDurationSeconds;
    @TextProperty(labelKey="PDB_3_OUTPUT_BASE_PATH_LABEL", section=TextReportSectionName.PDB_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The base path where the analysis output was written")
    private final String analysisOutputBasePath;
    @TextProperty(labelKey="PDB_4_OUTPUT_LOG_FILE_LABEL", section=TextReportSectionName.PDB_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The relative path to the CPAT analysis log file for this PDB")
    private final String analysisLogFile;
    @TextProperty(labelKey="PDB_5_OUTPUT_REPORT_FILE_LABEL", section=TextReportSectionName.PDB_SUMMARY, serializationClass=TextReportLabeledMap.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The relative path to the CPAT report(s) for this PDB")
    private final Map<ReportFormat, String> reportFiles;

    @CpatJsonIgnore
    public static Comparator<PDBAnalysisSummary> getComparator() {
        return new Comparator<PDBAnalysisSummary>(){

            @Override
            public int compare(PDBAnalysisSummary o1, PDBAnalysisSummary o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                int analysisResultComparison = o1.analysisResult.compareSeverityTo(o2.analysisResult);
                if (analysisResultComparison == 0) {
                    return o1.pdbName.compareTo(o2.pdbName);
                }
                return analysisResultComparison;
            }
        };
    }

    PDBAnalysisSummary(String pdbName, CheckResult analysisResult, String analysisResultDisplayText, Long analysisDurationSeconds, String analysisOutputBasePath, String analysisLogFile, Map<ReportFormat, String> reportFiles) {
        this.pdbName = pdbName;
        this.analysisResult = analysisResult;
        this.analysisResultDisplayText = analysisResultDisplayText;
        this.analysisDurationSeconds = analysisDurationSeconds;
        this.analysisOutputBasePath = analysisOutputBasePath;
        this.analysisLogFile = analysisLogFile;
        this.reportFiles = reportFiles;
    }

    public static PDBAnalysisSummaryBuilder builder() {
        return new PDBAnalysisSummaryBuilder();
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public CheckResult getAnalysisResult() {
        return this.analysisResult;
    }

    public String getAnalysisResultDisplayText() {
        return this.analysisResultDisplayText;
    }

    public Long getAnalysisDurationSeconds() {
        return this.analysisDurationSeconds;
    }

    public String getAnalysisOutputBasePath() {
        return this.analysisOutputBasePath;
    }

    public String getAnalysisLogFile() {
        return this.analysisLogFile;
    }

    public Map<ReportFormat, String> getReportFiles() {
        return this.reportFiles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PDBAnalysisSummary)) {
            return false;
        }
        PDBAnalysisSummary other = (PDBAnalysisSummary)o;
        Long this$analysisDurationSeconds = this.getAnalysisDurationSeconds();
        Long other$analysisDurationSeconds = other.getAnalysisDurationSeconds();
        if (this$analysisDurationSeconds == null ? other$analysisDurationSeconds != null : !((Object)this$analysisDurationSeconds).equals(other$analysisDurationSeconds)) {
            return false;
        }
        String this$pdbName = this.getPdbName();
        String other$pdbName = other.getPdbName();
        if (this$pdbName == null ? other$pdbName != null : !this$pdbName.equals(other$pdbName)) {
            return false;
        }
        CheckResult this$analysisResult = this.getAnalysisResult();
        CheckResult other$analysisResult = other.getAnalysisResult();
        if (this$analysisResult == null ? other$analysisResult != null : !((Object)((Object)this$analysisResult)).equals((Object)other$analysisResult)) {
            return false;
        }
        String this$analysisResultDisplayText = this.getAnalysisResultDisplayText();
        String other$analysisResultDisplayText = other.getAnalysisResultDisplayText();
        if (this$analysisResultDisplayText == null ? other$analysisResultDisplayText != null : !this$analysisResultDisplayText.equals(other$analysisResultDisplayText)) {
            return false;
        }
        String this$analysisOutputBasePath = this.getAnalysisOutputBasePath();
        String other$analysisOutputBasePath = other.getAnalysisOutputBasePath();
        if (this$analysisOutputBasePath == null ? other$analysisOutputBasePath != null : !this$analysisOutputBasePath.equals(other$analysisOutputBasePath)) {
            return false;
        }
        String this$analysisLogFile = this.getAnalysisLogFile();
        String other$analysisLogFile = other.getAnalysisLogFile();
        if (this$analysisLogFile == null ? other$analysisLogFile != null : !this$analysisLogFile.equals(other$analysisLogFile)) {
            return false;
        }
        Map<ReportFormat, String> this$reportFiles = this.getReportFiles();
        Map<ReportFormat, String> other$reportFiles = other.getReportFiles();
        return !(this$reportFiles == null ? other$reportFiles != null : !((Object)this$reportFiles).equals(other$reportFiles));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $analysisDurationSeconds = this.getAnalysisDurationSeconds();
        result = result * 59 + ($analysisDurationSeconds == null ? 43 : ((Object)$analysisDurationSeconds).hashCode());
        String $pdbName = this.getPdbName();
        result = result * 59 + ($pdbName == null ? 43 : $pdbName.hashCode());
        CheckResult $analysisResult = this.getAnalysisResult();
        result = result * 59 + ($analysisResult == null ? 43 : ((Object)((Object)$analysisResult)).hashCode());
        String $analysisResultDisplayText = this.getAnalysisResultDisplayText();
        result = result * 59 + ($analysisResultDisplayText == null ? 43 : $analysisResultDisplayText.hashCode());
        String $analysisOutputBasePath = this.getAnalysisOutputBasePath();
        result = result * 59 + ($analysisOutputBasePath == null ? 43 : $analysisOutputBasePath.hashCode());
        String $analysisLogFile = this.getAnalysisLogFile();
        result = result * 59 + ($analysisLogFile == null ? 43 : $analysisLogFile.hashCode());
        Map<ReportFormat, String> $reportFiles = this.getReportFiles();
        result = result * 59 + ($reportFiles == null ? 43 : ((Object)$reportFiles).hashCode());
        return result;
    }

    public String toString() {
        return "PDBAnalysisSummary(pdbName=" + this.getPdbName() + ", analysisResult=" + (Object)((Object)this.getAnalysisResult()) + ", analysisResultDisplayText=" + this.getAnalysisResultDisplayText() + ", analysisDurationSeconds=" + this.getAnalysisDurationSeconds() + ", analysisOutputBasePath=" + this.getAnalysisOutputBasePath() + ", analysisLogFile=" + this.getAnalysisLogFile() + ", reportFiles=" + this.getReportFiles() + ")";
    }

    public static class PDBAnalysisSummaryBuilder {
        private String pdbName;
        private CheckResult analysisResult;
        private String analysisResultDisplayText;
        private Long analysisDurationSeconds;
        private String analysisOutputBasePath;
        private String analysisLogFile;
        private Map<ReportFormat, String> reportFiles;

        PDBAnalysisSummaryBuilder() {
        }

        public PDBAnalysisSummaryBuilder pdbName(String pdbName) {
            this.pdbName = pdbName;
            return this;
        }

        public PDBAnalysisSummaryBuilder analysisResult(CheckResult analysisResult) {
            this.analysisResult = analysisResult;
            return this;
        }

        public PDBAnalysisSummaryBuilder analysisResultDisplayText(String analysisResultDisplayText) {
            this.analysisResultDisplayText = analysisResultDisplayText;
            return this;
        }

        public PDBAnalysisSummaryBuilder analysisDurationSeconds(Long analysisDurationSeconds) {
            this.analysisDurationSeconds = analysisDurationSeconds;
            return this;
        }

        public PDBAnalysisSummaryBuilder analysisOutputBasePath(String analysisOutputBasePath) {
            this.analysisOutputBasePath = analysisOutputBasePath;
            return this;
        }

        public PDBAnalysisSummaryBuilder analysisLogFile(String analysisLogFile) {
            this.analysisLogFile = analysisLogFile;
            return this;
        }

        public PDBAnalysisSummaryBuilder reportFiles(Map<ReportFormat, String> reportFiles) {
            this.reportFiles = reportFiles;
            return this;
        }

        public PDBAnalysisSummary build() {
            return new PDBAnalysisSummary(this.pdbName, this.analysisResult, this.analysisResultDisplayText, this.analysisDurationSeconds, this.analysisOutputBasePath, this.analysisLogFile, this.reportFiles);
        }

        public String toString() {
            return "PDBAnalysisSummary.PDBAnalysisSummaryBuilder(pdbName=" + this.pdbName + ", analysisResult=" + (Object)((Object)this.analysisResult) + ", analysisResultDisplayText=" + this.analysisResultDisplayText + ", analysisDurationSeconds=" + this.analysisDurationSeconds + ", analysisOutputBasePath=" + this.analysisOutputBasePath + ", analysisLogFile=" + this.analysisLogFile + ", reportFiles=" + this.reportFiles + ")";
        }
    }
}

