/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.enums;

import com.oracle.premigration.commons.enums.TargetCloud;

public enum LockdownProfile {
    PAAS_ATPD(TargetCloud.ATPD),
    ADW_ADWD(TargetCloud.ADWD),
    OLTP_ATPS(TargetCloud.ATPS),
    DWCS_ADWS(TargetCloud.ADWS),
    ADB_UNSUPPORTED(null),
    NOT_AUTONOMOUS(null),
    NONE(TargetCloud.DEFAULT);

    TargetCloud targetCloud;

    private LockdownProfile(TargetCloud targetCloud) {
        this.targetCloud = targetCloud;
    }

    public boolean isAutonomous() {
        return this != NOT_AUTONOMOUS && this != NONE;
    }

    public boolean isSupportedLockdownProfile() {
        return this == PAAS_ATPD || this == ADW_ADWD || this == OLTP_ATPS || this == DWCS_ADWS;
    }

    public static LockdownProfile fromLockdownProfileAndCloudService(String lockDownStr, String cloudService) {
        if ((lockDownStr == null || lockDownStr.isEmpty()) && (cloudService == null || cloudService.isEmpty())) {
            return NONE;
        }
        if (lockDownStr != null && (cloudService == null || cloudService.isEmpty())) {
            return NOT_AUTONOMOUS;
        }
        if ("PAAS".equalsIgnoreCase(lockDownStr) && "PAAS".equalsIgnoreCase(cloudService)) {
            return PAAS_ATPD;
        }
        if ("OLTP".equalsIgnoreCase(lockDownStr) && "OLTP".equalsIgnoreCase(cloudService)) {
            return OLTP_ATPS;
        }
        if ("ADW".equalsIgnoreCase(lockDownStr) && "PAAS".equalsIgnoreCase(cloudService)) {
            return ADW_ADWD;
        }
        if ("DWCS".equalsIgnoreCase(lockDownStr) && "DWCS".equalsIgnoreCase(cloudService)) {
            return DWCS_ADWS;
        }
        return ADB_UNSUPPORTED;
    }

    public TargetCloud toTargetCloud() {
        return this.targetCloud;
    }

    public static LockdownProfile fromTargetCloud(TargetCloud targetCloud) {
        LockdownProfile targetLockdownProfile;
        switch (targetCloud) {
            case ATPD: {
                targetLockdownProfile = PAAS_ATPD;
                break;
            }
            case ADWD: {
                targetLockdownProfile = ADW_ADWD;
                break;
            }
            case ATPS: {
                targetLockdownProfile = OLTP_ATPS;
                break;
            }
            case ADWS: {
                targetLockdownProfile = DWCS_ADWS;
                break;
            }
            default: {
                targetLockdownProfile = NONE;
            }
        }
        return targetLockdownProfile;
    }
}

