/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.patch;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.ideimpl.patch.AbstractPatchCommand;
import oracle.ideimpl.patch.CreatePatchDialogVetoer;
import oracle.ideimpl.patch.PatchComponents;
import oracle.ideimpl.patch.PatchFilePanel;
import oracle.ideimpl.patch.PatchOperationException;
import oracle.ideimpl.patch.res.Bundle;
import oracle.ideimpl.vcscore.VersioningCoreUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.patch.PatchContributor;
import oracle.javatools.patch.PatchCreateOptions;
import oracle.javatools.patch.PatchEngine;
import oracle.javatools.patch.PatchFormat;
import oracle.javatools.patch.PatchIndexFile;
import oracle.javatools.patch.PatchModel;
import oracle.jdeveloper.compare.CompareConstants;
import oracle.jdeveloper.compare.PatchCompareContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.patch.PatchUtil;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.history.HistoryViewer;

public class CreatePatchCommand
extends AbstractPatchCommand {
    public static final String CREATE_PATCH_CMD = CreatePatchCommand.class.getName();
    public static final int CREATE_PATCH_CMD_ID = CompareConstants.CREATE_PATCH_CMD_ID;
    private static final URLFilter _urlFilter = new URLFilter(){

        public final boolean accept(URL url) {
            return "file".equals(url.getProtocol()) || "ide.compare".equals(url.getProtocol());
        }
    };
    private static final URLFilter _compareFilter = new URLFilter(){

        public final boolean accept(URL url) {
            return "ide.compare".equals(url.getProtocol());
        }
    };

    public CreatePatchCommand() {
        super(CREATE_PATCH_CMD_ID);
    }

    public static final String createDialogTitle(String postfix) {
        if (postfix == null) {
            return Bundle.get("GENERATE_PATCH_TITLE");
        }
        return Bundle.format("GENERATE_PATCH_TITLE_POSTFIXED", postfix);
    }

    @Override
    protected URLFilter getURLFilter() {
        return _urlFilter;
    }

    @Override
    protected boolean isAvailableImpl() throws Exception {
        Node node = this.getContext().getNode();
        if (node == null || node.getURL() == null || !this.getURLFilter().accept(node.getURL())) {
            return false;
        }
        CompareModel compareModel = this.getContextCompareModel();
        if (compareModel == null || compareModel.getContributor(ContributorKind.ANCESTOR) != null) {
            return false;
        }
        String sourceFilePath = this.getContributorFilePath(this.getContextSourceCompareContributor());
        String targetFilePath = this.getContributorFilePath(this.getContextTargetCompareContributor());
        if (sourceFilePath == null || targetFilePath == null) {
            return false;
        }
        if (_compareFilter.accept(node.getURL())) {
            return true;
        }
        return super.isAvailableImpl();
    }

    @Override
    protected int doitImpl() throws Exception {
        Node node = this.getContext().getNode();
        if (node == null) {
            return -1;
        }
        if (!VersioningCoreUtil.saveDirtyNodes((Locatable[])new Node[]{node})) {
            return 1;
        }
        URL operationWorkingDirectoryUrl = PatchUtil.getOperationWorkingDirectoryURL(new URL[]{node.getURL()});
        if (operationWorkingDirectoryUrl == null) {
            return 9;
        }
        PatchCompareContributor sourceCompareContributor = (PatchCompareContributor)this.getContextSourceCompareContributor();
        PatchCompareContributor targetCompareContributor = (PatchCompareContributor)this.getContextTargetCompareContributor();
        PatchCompareDescriptor sourcePatchDescriptor = sourceCompareContributor.getPatchDescriptor();
        PatchCompareDescriptor targetPatchDescriptor = targetCompareContributor.getPatchDescriptor();
        final CreatePatchUI ui = this.createUI(new URL[]{URLFactory.newURL((URL)sourcePatchDescriptor.getPatchParentURL(), (String)sourcePatchDescriptor.getFileName())});
        View view = this.getContext().getView();
        String postfix = view != null && view instanceof CompareEditor ? null : Bundle.get("GENERATE_PATCH_TITLE_POSTFIX");
        JEWTDialog dialog = VersioningCoreUtil.createOperationDialog((Component)VersioningCoreUtil.getCurrentWindow(), (String)CreatePatchCommand.createDialogTitle(postfix), null, (Component)new JScrollPane(PatchComponents.createFileListerComponent(Collections.singleton(node))), (Component)ui, (String)"f1_cvsgeneratepatch_html", (Component)ui.getClipboardRadioButton());
        dialog.addVetoableChangeListener((VetoableChangeListener)new CreatePatchDialogVetoer(ui){

            @Override
            protected boolean isFileTargetSelected() {
                return ui.getFileRadioButton().isSelected();
            }

            @Override
            protected URL getFileTargetURL() {
                return ui.getFileChooserPanel().getURL();
            }
        });
        if (!VersioningCoreUtil.runDialog((JDialog)dialog)) {
            return 1;
        }
        PatchCreateOptions createOptions = new PatchCreateOptions();
        createOptions.setRecursive(false);
        createOptions.setIncludeNewFiles(false);
        createOptions.setIgnoreWhitespace(sourceCompareContributor.getIgnoreWhitespace() && targetCompareContributor.getIgnoreWhitespace());
        PatchContributorImpl fromFileContributor = new PatchContributorImpl(sourceCompareContributor.getTextBuffer(), sourcePatchDescriptor);
        PatchContributorImpl toFileContributor = new PatchContributorImpl(targetCompareContributor.getTextBuffer(), targetPatchDescriptor);
        PatchEngine patchEngine = new PatchEngine((PatchContributor)toFileContributor);
        PatchModel patchModel = patchEngine.createModel((PatchContributor)fromFileContributor, createOptions);
        if (patchModel.getEntries().length <= 0) {
            throw new PatchOperationException(Bundle.get("ERROR_CREATE_PATCH_NO_DIFFERENCES_TITLE"), Bundle.get("ERROR_CREATE_PATCH_NO_DIFFERENCES"));
        }
        PatchFormat patchFormat = new PatchFormat();
        patchFormat.setEncoding(StreamDecoder.getDefaultEncoding((URL)node.getURL()));
        String patchSource = patchFormat.format(patchModel);
        if (ui.getClipboardRadioButton().isSelected()) {
            this.savePatchToClipboard(patchSource);
        } else {
            this.savePatchToURL(patchSource, patchFormat.getEncoding(), ui.getFileChooserPanel().getURL(), ui.getOpenInEditorCheckBox().isSelected());
        }
        return 0;
    }

    private CreatePatchUI createUI(URL[] urls) {
        final CreatePatchUI createPatchUI = new CreatePatchUI();
        this.initializeFileChooserPanel(createPatchUI.getFileChooserPanel(), urls);
        createPatchUI.getClipboardRadioButton().setSelected(true);
        createPatchUI.getOpenInEditorCheckBox().setSelected(true);
        createPatchUI.getFileRadioButton().addChangeListener(new ChangeListener(){

            @Override
            public final void stateChanged(ChangeEvent e) {
                CreatePatchCommand.this.updateFileOptionsEnabledState(createPatchUI);
            }
        });
        this.updateFileOptionsEnabledState(createPatchUI);
        this.initializePreferredSizeOfUI(createPatchUI);
        return createPatchUI;
    }

    private void updateFileOptionsEnabledState(CreatePatchUI ui) {
        boolean fileOptionsEnabled = ui.getFileRadioButton().isSelected();
        ui.getFileChooserPanel().setEnabled(fileOptionsEnabled);
        ui.getOpenInEditorCheckBox().setEnabled(fileOptionsEnabled);
    }

    private CompareModel getContextCompareModel() {
        View view = this.getContext().getView();
        if (view != null && view instanceof HistoryViewer) {
            if (((HistoryViewer)view).isBusy()) {
                return null;
            }
            CompareView compareView = ((HistoryViewer)view).getCompareView();
            return compareView != null ? compareView.getModel() : null;
        }
        if (view != null && view instanceof CompareEditor) {
            return ((CompareEditor)view).getCompareView().getModel();
        }
        return null;
    }

    private String getContributorFilePath(CompareContributor compareContributor) {
        if (compareContributor instanceof PatchCompareContributor) {
            PatchCompareDescriptor patchDescriptor = ((PatchCompareContributor)compareContributor).getPatchDescriptor();
            return patchDescriptor != null ? patchDescriptor.getFileName() : null;
        }
        return null;
    }

    private CompareContributor getContextSourceCompareContributor() throws Exception {
        View view = this.getContext().getView();
        if (view != null && view instanceof HistoryViewer) {
            return this.getHistoryComponentCompareContributor(((HistoryViewer)view).getLeftHistoryComponent());
        }
        if (view != null && view instanceof CompareEditor) {
            return ((CompareNode)view.getContext().getNode()).getSource();
        }
        return null;
    }

    private CompareContributor getContextTargetCompareContributor() throws Exception {
        View view = this.getContext().getView();
        if (view != null && view instanceof HistoryViewer) {
            return this.getHistoryComponentCompareContributor(((HistoryViewer)view).getRightHistoryComponent());
        }
        if (view != null && view instanceof CompareEditor) {
            return ((CompareNode)view.getContext().getNode()).getTarget();
        }
        return null;
    }

    private CompareContributor getHistoryComponentCompareContributor(HistoryComponent historyComponent) throws Exception {
        HistoryEntry historyEntry = historyComponent != null ? historyComponent.getSingleSelection() : null;
        return historyEntry != null ? historyEntry.getCompareContributor() : null;
    }

    public class CreatePatchUI
    extends JPanel {
        private JLabel _patchTargetLabel;
        private JRadioButton _clipboardRadioButton;
        private JRadioButton _fileRadioButton;
        private PatchFilePanel _fileChooserPanel;
        private JCheckBox _openInEditorCheckBox;

        public CreatePatchUI() {
            this.setName("CreatePatchUI");
            this.createComponents();
            this.layoutComponents();
            this.localizeComponentsMethod();
            ButtonGroup bg = new ButtonGroup();
            bg.add(this._clipboardRadioButton);
            bg.add(this._fileRadioButton);
        }

        private void createComponents() {
            this._patchTargetLabel = new JLabel();
            this._patchTargetLabel.setName("PatchTargetLabel");
            this._clipboardRadioButton = new JRadioButton();
            this._clipboardRadioButton.setName("ClipboardRadioButton");
            this._fileRadioButton = new JRadioButton();
            this._fileRadioButton.setName("FileRadioButton");
            this._fileChooserPanel = new PatchFilePanel();
            this._fileChooserPanel.setName("FileChooserPanel");
            this._openInEditorCheckBox = new JCheckBox();
            this._openInEditorCheckBox.setName("OpenInEditorCheckBox");
        }

        private void layoutComponents() {
            int insetSize = 2;
            Insets i = new Insets(insetSize, insetSize, insetSize, insetSize);
            LayoutBuilder builder = new LayoutBuilder();
            JComponent c = this._patchTargetLabel;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 2, false, true);
            builder.nl();
            builder.addHGap();
            c = this._clipboardRadioButton;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addHGap();
            c = this._fileRadioButton;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addHGap();
            c = this._fileChooserPanel;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addHGap();
            c = this._openInEditorCheckBox;
            builder.setDefaultAnchor(18);
            builder.add((Component)c, i, 1, false, true);
            builder.nl();
            builder.addToPanel((Container)this);
        }

        private void localizeComponentsMethod() {
            ResourceUtils.resLabel((JLabel)this._patchTargetLabel, (Component)this._patchTargetLabel, (String)Bundle.get("CREATE_PATCH_PATCH_TARGET_LABEL"));
            ResourceUtils.resButton((AbstractButton)this._clipboardRadioButton, (String)Bundle.get("CREATE_PATCH_CLIPBOARD_RADIOBUTTON"));
            ResourceUtils.resButton((AbstractButton)this._fileRadioButton, (String)Bundle.get("CREATE_PATCH_FILE_RADIOBUTTON"));
            ResourceUtils.resButton((AbstractButton)this._openInEditorCheckBox, (String)Bundle.get("CREATE_PATCH_OPEN_IN_EDITOR_CHECKBOX"));
        }

        public JLabel getPatchTargetLabel() {
            return this._patchTargetLabel;
        }

        public JRadioButton getClipboardRadioButton() {
            return this._clipboardRadioButton;
        }

        public JRadioButton getFileRadioButton() {
            return this._fileRadioButton;
        }

        public PatchFilePanel getFileChooserPanel() {
            return this._fileChooserPanel;
        }

        public JCheckBox getOpenInEditorCheckBox() {
            return this._openInEditorCheckBox;
        }
    }

    private class PatchContributorImpl
    extends PatchContributor {
        private final TextBuffer _textBuffer;
        private final PatchCompareDescriptor _patchDescriptor;

        PatchContributorImpl(TextBuffer textBuffer, PatchCompareDescriptor patchDescriptor) {
            super(null, patchDescriptor.getFileName());
            this._textBuffer = textBuffer;
            this._patchDescriptor = patchDescriptor;
        }

        protected boolean isArgumentFileExists() {
            return true;
        }

        protected boolean isArgumentDirectory() {
            return false;
        }

        protected PatchIndexFile constructIndexFileImpl(File directoryFile, String path) {
            PatchIndexFileImpl patchIndexFile = new PatchIndexFileImpl(directoryFile, path, this._patchDescriptor);
            patchIndexFile.setTextBuffer(this._textBuffer);
            return patchIndexFile;
        }
    }

    private class PatchIndexFileImpl
    extends PatchIndexFile {
        private final PatchCompareDescriptor _patchDescriptor;

        public PatchIndexFileImpl(File directoryFile, String path, PatchCompareDescriptor patchDescriptor) {
            super(directoryFile, path);
            this._patchDescriptor = patchDescriptor;
        }

        protected long lastModified() {
            return this._patchDescriptor.getLastModified();
        }

        protected String getRevision() {
            return this._patchDescriptor.getRevision();
        }
    }
}

