/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.pgql.utils;

import java.awt.Component;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.pgql.PgqlResources;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSetMetaData;

public final class PgqlResultSetUtils {
    public static int getRowCount(PgqlResultSet pgqlResultSet) {
        if (pgqlResultSet == null) {
            return 0;
        }
        int n = 0;
        try {
            pgqlResultSet.beforeFirst();
            while (pgqlResultSet.next()) {
                ++n;
            }
        }
        catch (PgqlException pgqlException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)pgqlException.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
        }
        return n;
    }

    public static int getColumnCount(PgqlResultSet pgqlResultSet) {
        if (pgqlResultSet == null) {
            return 0;
        }
        Vector vector = new Vector();
        ResultSetMetaData resultSetMetaData = null;
        try {
            pgqlResultSet.first();
            resultSetMetaData = pgqlResultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
        }
        catch (PgqlException pgqlException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)pgqlException.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
        }
        return resultSetMetaData == null ? 0 : resultSetMetaData.getColumnCount();
    }

    public static Vector<String> getResultSetColumnNames(PgqlResultSet pgqlResultSet) {
        if (pgqlResultSet == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        try {
            pgqlResultSet.first();
            ResultSetMetaData resultSetMetaData = pgqlResultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 0; i <= n; ++i) {
                vector.add(i != 0 ? resultSetMetaData.getColumnName(i) : "");
            }
        }
        catch (PgqlException pgqlException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)pgqlException.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
        }
        return vector;
    }

    public static DefaultTableModel resultSetToTableModel(PgqlResultSet pgqlResultSet) {
        if (pgqlResultSet == null) {
            return null;
        }
        Vector vector = new Vector();
        Vector<String> vector2 = PgqlResultSetUtils.getResultSetColumnNames(pgqlResultSet);
        int n = 1;
        try {
            pgqlResultSet.beforeFirst();
            while (pgqlResultSet.next()) {
                Vector<Object> vector3 = new Vector<Object>();
                for (String string : vector2) {
                    vector3.add(string.isEmpty() ? Integer.valueOf(n) : pgqlResultSet.getObject(string));
                }
                vector.add(vector3);
                ++n;
            }
        }
        catch (PgqlException pgqlException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)pgqlException.toString(), (String)PgqlResources.getString("EXECUTION_ERROR"), null);
        }
        return new DefaultTableModel(vector, (Vector)vector2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
    }
}

