/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ByDay;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Day;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Frequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.PreDefinedFrequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.SortedClauseModel;

public class ByDayClause
extends AbstractRepeatIntervalClause<ByDay, SortedClauseModel<ByDay>> {
    protected int minValue = -53;
    protected int maxValue = 53;

    public ByDayClause(RepeatIntervalModel repeatIntervalModel) {
        this(ByDay.class, repeatIntervalModel);
    }

    protected ByDayClause(SortedClauseModel<ByDay> sortedClauseModel) {
        super(sortedClauseModel);
        ((SortedClauseModel)this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
    }

    protected ByDayClause(Class<ByDay> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new SortedClauseModel<ByDay>(clazz, ClauseType.BYDAY, repeatIntervalModel));
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return new Panel(properties);
    }

    public JPanel getCheckBoxPanel() {
        return this.getCheckBoxPanel(null);
    }

    public JPanel getCheckBoxPanel(Properties properties) {
        return new CheckBoxPanel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class RepeatIntervalChangeListener
    implements RepeatIntervalModelListener {
        protected RepeatIntervalChangeListener() {
        }

        @Override
        public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
            block0 : switch (repeatIntervalModelEvent.getClauseType()) {
                case FREQ: {
                    if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                    Frequency frequency = (Frequency)repeatIntervalModelEvent.getNewValue();
                    if (frequency instanceof PreDefinedFrequency) {
                        switch ((PreDefinedFrequency)frequency) {
                            case MONTHLY: {
                                ByDayClause.this.minValue = -5;
                                ByDayClause.this.maxValue = 5;
                                break block0;
                            }
                            case YEARLY: {
                                ByDayClause.this.minValue = -53;
                                ByDayClause.this.maxValue = 53;
                                break block0;
                            }
                        }
                        ByDayClause.this.maxValue = 0;
                        ByDayClause.this.minValue = 0;
                        break;
                    }
                    ByDayClause.this.maxValue = 53;
                    ByDayClause.this.minValue = -53;
                }
            }
        }
    }

    protected class Panel
    extends PropertyBasedPanel {
        protected Set<String> byDayItems;
        protected GridBagLayout gridBagLayout1;
        protected ButtonGroup dayButtons;
        protected JSpinner numberSpinner;
        protected SpinnerNumberModel numberSpinnerModel;
        protected JButton addButton;
        protected JButton removeButton;
        protected JButton clearButton;
        protected Calendar calender;
        protected Locale locale;
        protected Map<String, Integer> dayNames;
        protected JRadioButton[] dayRadioButtons;

        public Panel(Properties properties) {
            super(properties);
            this.byDayItems = new TreeSet<String>();
            this.gridBagLayout1 = new GridBagLayout();
            this.dayButtons = new ButtonGroup();
            this.numberSpinner = new JSpinner();
            this.numberSpinnerModel = new SpinnerNumberModel();
            this.addButton = new JButton();
            this.removeButton = new JButton();
            this.clearButton = new JButton();
            this.calender = Calendar.getInstance();
            this.locale = null;
            this.dayNames = null;
            this.dayRadioButtons = new JRadioButton[7];
            for (int i = 0; i < this.dayRadioButtons.length; ++i) {
                this.dayRadioButtons[i] = new JRadioButton();
            }
            this.applyLocale(Locale.getDefault());
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((SortedClauseModel)ByDayClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        protected ByDay getSelectedByDayItem() {
            return new ByDay(this.getSelectedDay(), this.getSelectedWeekDayNo());
        }

        protected Integer getSelectedWeekDayNo() {
            Integer n;
            Integer n2 = null;
            Frequency frequency = ByDayClause.this.getRepeatIntervalModel().getFreq();
            boolean bl = false;
            if (frequency instanceof PreDefinedFrequency) {
                switch ((PreDefinedFrequency)frequency) {
                    case YEARLY: 
                    case MONTHLY: {
                        bl = true;
                        break;
                    }
                }
            } else {
                bl = true;
            }
            if (bl && (n = Integer.valueOf(this.numberSpinnerModel.getNumber().intValue())) != 0) {
                n2 = n;
            }
            return n2;
        }

        protected Day getSelectedDay() {
            for (int i = 0; i < this.dayRadioButtons.length; ++i) {
                JRadioButton jRadioButton = this.dayRadioButtons[i];
                if (!jRadioButton.isSelected()) continue;
                return Day.values()[i];
            }
            return null;
        }

        protected void jbReset() {
            this.numberSpinnerModel.setValue(0);
            this.dayRadioButtons[0].setSelected(true);
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            this.numberSpinner.setMinimumSize(new Dimension(64, 19));
            this.numberSpinner.setPreferredSize(new Dimension(64, 19));
            this.numberSpinner.setModel(this.numberSpinnerModel);
            this.numberSpinnerModel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = Panel.this.numberSpinnerModel.getNumber().intValue();
                    if (n > ByDayClause.this.maxValue) {
                        Panel.this.numberSpinnerModel.setValue(ByDayClause.this.maxValue);
                    } else if (n < ByDayClause.this.minValue) {
                        Panel.this.numberSpinnerModel.setValue(ByDayClause.this.minValue);
                    }
                }
            });
            this.dayButtons = new ButtonGroup();
            for (JRadioButton jRadioButton : this.dayRadioButtons) {
                this.dayButtons.add(jRadioButton);
            }
            this.addButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD"));
            this.addButton.setActionCommand("Add");
            this.addButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_ADD_TOOLTIP"));
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.addButton_actionPerformed(actionEvent);
                }
            });
            this.addButton.setMargin(new Insets(0, 0, 0, 0));
            this.removeButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE"));
            this.removeButton.setActionCommand("Del");
            this.removeButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_REMOVE_TOOLTIP"));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.removeButton_actionPerformed(actionEvent);
                }
            });
            this.removeButton.setMargin(new Insets(0, 0, 0, 0));
            this.clearButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL"));
            this.clearButton.setActionCommand("Clear");
            this.clearButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL_TOOLTIP"));
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Panel.this.clearButton_actionPerformed(actionEvent);
                }
            });
            this.clearButton.setMargin(new Insets(0, 0, 0, 0));
            this.add((Component)new JLabel(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_BYDAY_PANEL_WEEKDAYNO")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)this.numberSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            int n = 0;
            int n2 = 2;
            for (JRadioButton jRadioButton : this.dayRadioButtons) {
                this.add((Component)jRadioButton, new GridBagConstraints(n, n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                if (n2 % 5 == 0) {
                    ++n;
                    n2 = 2;
                    continue;
                }
                ++n2;
            }
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this.addButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            jPanel.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            jPanel.add((Component)this.clearButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.add((Component)jPanel, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.jbReset();
        }

        protected void addButton_actionPerformed(ActionEvent actionEvent) {
            ((SortedClauseModel)ByDayClause.this.clauseModel).add(this.getSelectedByDayItem());
        }

        protected void removeButton_actionPerformed(ActionEvent actionEvent) {
            ((SortedClauseModel)ByDayClause.this.clauseModel).remove(this.getSelectedByDayItem());
        }

        protected void clearButton_actionPerformed(ActionEvent actionEvent) {
            ((SortedClauseModel)ByDayClause.this.clauseModel).clear();
        }

        protected int reMapDayOrdinal(int n) {
            if ((n -= 2) < 0) {
                n += 7;
            }
            return n;
        }

        protected void applyLocale(Locale locale) {
            this.locale = locale;
            this.dayNames = this.calender.getDisplayNames(7, 2, locale);
            for (Map.Entry<String, Integer> entry : this.dayNames.entrySet()) {
                String string = entry.getKey();
                int n = this.reMapDayOrdinal(entry.getValue());
                JRadioButton jRadioButton = this.dayRadioButtons[n];
                jRadioButton.setText(string);
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case FREQ: {
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Panel.this.jbReset();
                    }
                }
            }
        }
    }

    protected class CheckBoxPanel
    extends PropertyBasedPanel {
        protected GridBagLayout gridBagLayout2;
        protected Calendar calender;
        protected Locale locale;
        protected Map<String, Integer> dayNames;
        protected JCheckBox[] dayCheckBoxes;
        protected JButton clearButton;

        public CheckBoxPanel(Properties properties) {
            super(properties);
            this.gridBagLayout2 = new GridBagLayout();
            this.calender = Calendar.getInstance();
            this.locale = null;
            this.dayNames = null;
            this.dayCheckBoxes = new JCheckBox[7];
            this.clearButton = new JButton();
            for (int i = 0; i < this.dayCheckBoxes.length; ++i) {
                this.dayCheckBoxes[i] = new JCheckBox();
            }
            this.applyLocale(Locale.getDefault());
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ((SortedClauseModel)ByDayClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout2);
            for (Map.Entry<String, Integer> entry : this.dayNames.entrySet()) {
                JCheckBox[] jCheckBoxArray = entry.getKey();
                JCheckBox jCheckBox = this.dayCheckBoxes[this.reMapDayOrdinal(entry.getValue())];
                jCheckBox.setText((String)jCheckBoxArray);
                jCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CheckBoxPanel.this.dayCheckBox_actionPerformed(actionEvent);
                    }
                });
            }
            this.clearButton.setText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL"));
            this.clearButton.setActionCommand("Clear");
            this.clearButton.setToolTipText(SchedulerArb.get("REPEAT_INTERVAL_CLAUSE_CLEAR_ALL_TOOLTIP"));
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CheckBoxPanel.this.clearButton_actionPerformed(actionEvent);
                }
            });
            this.clearButton.setMargin(new Insets(0, 0, 0, 0));
            int n = 0;
            int n2 = 1;
            for (JCheckBox jCheckBox : this.dayCheckBoxes) {
                this.add((Component)jCheckBox, new GridBagConstraints(n, n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
                if (n2 % 5 == 0) {
                    ++n;
                    n2 = 1;
                    continue;
                }
                ++n2;
            }
            this.add((Component)this.clearButton, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        }

        protected void clearButton_actionPerformed(ActionEvent actionEvent) {
            ((SortedClauseModel)ByDayClause.this.clauseModel).clear();
        }

        protected int reMapDayOrdinal(int n) {
            if ((n -= 2) < 0) {
                n += 7;
            }
            return n;
        }

        protected void applyLocale(Locale locale) {
            this.locale = locale;
            this.dayNames = this.calender.getDisplayNames(7, 2, locale);
            for (Map.Entry<String, Integer> entry : this.dayNames.entrySet()) {
                String string = entry.getKey();
                int n = this.reMapDayOrdinal(entry.getValue());
                JCheckBox jCheckBox = this.dayCheckBoxes[n];
                jCheckBox.setText(string);
            }
        }

        protected void setDayCheckBox(int n, boolean bl) {
            JCheckBox jCheckBox = this.dayCheckBoxes[n];
            ButtonModel buttonModel = jCheckBox.getModel();
            buttonModel.setSelected(bl);
        }

        protected void setDayCheckBox(ByDay byDay, boolean bl) {
            this.setDayCheckBox(byDay.getDay(), bl);
        }

        protected void setDayCheckBox(Day day, boolean bl) {
            this.setDayCheckBox(day.ordinal(), bl);
        }

        protected void resetDayCheckBoxes(ByDay[] byDayArray) {
            Day[] dayArray = Day.values();
            int n = 0;
            for (int i = 0; i < this.dayCheckBoxes.length; ++i) {
                Day day = dayArray[i];
                boolean bl = false;
                if (byDayArray != null && n < byDayArray.length && byDayArray[n].getWeekDayNo() == null && day == byDayArray[n].getDay()) {
                    bl = true;
                    ++n;
                }
                this.setDayCheckBox(day, bl);
            }
        }

        protected void resetDayCheckBoxes() {
            this.resetDayCheckBoxes(null);
        }

        protected void dayCheckBox_actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            String string = jCheckBox.getText();
            Integer n = this.reMapDayOrdinal(this.dayNames.get(string));
            Day day = Day.values()[n];
            if (jCheckBox.isSelected()) {
                ((SortedClauseModel)ByDayClause.this.clauseModel).add(new ByDay(day));
            } else {
                ((SortedClauseModel)ByDayClause.this.clauseModel).remove(new ByDay(day));
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case BYDAY: {
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object = repeatIntervalModelEvent.getNewValue();
                        Object object2 = repeatIntervalModelEvent.getOldValue();
                        if (object2 != null && !object2.getClass().isArray()) {
                            CheckBoxPanel.this.setDayCheckBox((ByDay)object2, false);
                        }
                        if (object == null) break;
                        if (object.getClass().isArray()) {
                            CheckBoxPanel.this.resetDayCheckBoxes((ByDay[])object);
                            break;
                        }
                        CheckBoxPanel.this.setDayCheckBox((ByDay)object, true);
                    }
                }
            }
        }
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    string2 = string2.trim();
                    try {
                        Day day = Day.valueOf(string2.substring(string2.length() - 3).toUpperCase());
                        Integer n = string2.length() > 3 ? Integer.valueOf(string2.substring(0, string2.length() - 3).trim()) : null;
                        ((SortedClauseModel)ByDayClause.this.clauseModel).add(new ByDay(day, n));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

