/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.chain;

import java.sql.Connection;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;

public class ChainRunAction
extends ActionDialog {
    private static final String CHAIN_NAME = "name";
    private static final String RUN_MSG = "msg";
    private String chainName;

    public ChainRunAction() {
        this.setScriptEditingEnabled(false);
    }

    protected List<ActionControl> createControls(Connection connection) {
        try {
            String string = this.getObjectName();
            this.chainName = "\"" + string + "\"";
        }
        catch (Exception exception) {
            return null;
        }
        try {
            String string = this.getDBObjectSchemaName();
            if (string == null) {
                string = this.getDBObject().getSchemaName();
            }
            if (ChainRunAction.checkNull(string) != null) {
                this.chainName = "\"" + string + "\"." + this.chainName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(CHAIN_NAME, SchedulerArb.getString("CHAIN_RUN_NAME_LABEL"), this.chainName);
        LabelActionControl labelActionControl = new LabelActionControl(RUN_MSG, SchedulerArb.getString("CHAIN_RUN_LABEL"));
        Vector<ActionControl> vector = new Vector<ActionControl>();
        textBoxActionControl.setEditable(false);
        vector.add((ActionControl)textBoxActionControl);
        vector.add((ActionControl)labelActionControl);
        return vector;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getDBObject().getDBVersion();
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(CHAIN_NAME, this.chainName);
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", treeMap);
        String string2 = null;
        string2 = dBMSSchedulerCodeGenerator.generate(string, "CHAIN_RUN", treeMap2);
        return string2;
    }

    protected String getTitle() {
        return SchedulerArb.getString("CHAIN_RUN_ACTION_TITLE");
    }

    public static String checkNull(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static String checkQuotes(String string) {
        if ((string = ChainRunAction.checkNull(string)) != null && string.length() > 0) {
            string = string.replace("'", "''");
        }
        return string;
    }
}

