/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.view.ColumnNode;
import oracle.hcs.tree.view.JTree2;
import oracle.hcs.util.DatabaseObjectRenderer;
import oracle.hcs.util.TableDisplay;

public class SourceObjectTree
extends JTree2 {
    protected List<TableDisplay> tableDisplay = new ArrayList<TableDisplay>();

    public SourceObjectTree() {
        this.tableDisplay.add(TableDisplay.COLUMNS);
        this.initUI();
    }

    public SourceObjectTree(TreeNode treeNode) {
        super(treeNode);
        this.tableDisplay.add(TableDisplay.COLUMNS);
        this.initUI();
    }

    public void remove(TableDisplay tableDisplay) {
        this.tableDisplay.remove((Object)tableDisplay);
    }

    public void addNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        defaultMutableTreeNode.setAllowsChildren(true);
        if (!this.isNodeChild(defaultMutableTreeNode)) {
            Object object;
            DatabaseSource databaseSource = (DatabaseSource)defaultMutableTreeNode.getUserObject();
            if (this.tableDisplay.contains((Object)TableDisplay.COLUMNS) && (object = databaseSource.getColumns()) != null && defaultMutableTreeNode.getChildCount() < 1) {
                for (Object object2 : object) {
                    ColumnNode columnNode = new ColumnNode((Column)object2);
                    defaultMutableTreeNode.add(columnNode);
                }
            }
            if ((object = this.getModel()) instanceof DefaultTreeModel) {
                Object object3 = object;
                DefaultMutableTreeNode defaultMutableTreeNode2 = ((DefaultTreeModel)object3).getRoot() == null ? new DefaultMutableTreeNode("root") : (DefaultMutableTreeNode)((DefaultTreeModel)object3).getRoot();
                defaultMutableTreeNode2.add(defaultMutableTreeNode);
                ((DefaultTreeModel)object3).setRoot(defaultMutableTreeNode2);
            }
        }
    }

    protected boolean isNodeChild(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.treeModel instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.treeModel;
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
            if (defaultMutableTreeNode2 != null) {
                for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
                    if (!defaultMutableTreeNode2.getChildAt(i).equals(defaultMutableTreeNode)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public List<DatabaseSource> getList() {
        ArrayList<DatabaseSource> arrayList = new ArrayList<DatabaseSource>();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object = defaultMutableTreeNode2.getUserObject();
            if (object == null) continue;
            DatabaseSource databaseSource = (DatabaseSource)object;
            arrayList.add(databaseSource);
        }
        return arrayList;
    }

    protected void initUI() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new DatabaseObjectRenderer());
    }
}

