/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.RowExpression;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public abstract class CaseExpression
extends RowExpression {
    static final int[] CATEGORY_LIST = new int[]{24, 4, 65, 32, 2};
    private TypedExpression m_ElseExpression = null;

    CaseExpression(TypedExpression typedExpression) {
        this.m_ElseExpression = typedExpression;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        if (null != this.m_ElseExpression) {
            validationContext.push(this);
            this.m_ElseExpression = validationContext.validateExp(this.m_ElseExpression);
            validationContext.pop();
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null == this.getElseExpression()) {
            return true;
        }
        return this.getElseExpression().isDefinitionComplete();
    }

    int validateExpression(TypedExpression typedExpression, int n) {
        if (null == typedExpression) {
            return n;
        }
        DataType dataType = typedExpression.getDataType();
        if (dataType == this.getDataType()) {
            return n;
        }
        if (dataType == DataType.NULL_TYPE) {
            return n;
        }
        if (-1 == n) {
            this.setDataType(dataType);
            return dataType.getCategory(CATEGORY_LIST, -1);
        }
        dataType.validateType(n);
        this.setDataType(dataType.getLosslessType(this.getDataType()));
        return n;
    }

    public TypedExpression getElseExpression() {
        return this.m_ElseExpression;
    }
}

