/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.quickav.QuickAVDataTableHelper;
import oracle.hcs.quickav.QuickAVDimensionGenerator;
import oracle.hcs.quickav.QuickAVEditableCellRenderer;
import oracle.hcs.quickav.QuickAVMetadataObjectEditorPanel;
import oracle.hcs.quickav.QuickAVTableCellEditor;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;

public class QuickAVDimensionEditor
extends QuickAVMetadataObjectEditorPanel {
    private DimensionsTableModel model;
    private static final int DIMENSION_TYPE_COL = 4;
    private static final int DIMENSION_LEVEL_TYPE_COL = 3;
    private static final String DIMENSION_TYPE_STD = "STANDARD";
    private static final String DIMENSION_TYPE_TIME = "TIME";
    private HCSSchema schema;
    private GenericTable dimLevelsTable;
    private DimLevelTableModel levelsModel;
    private List<String> existingObjects;

    public QuickAVDimensionEditor(List<AttributeDimension> list, QuickAVDataTableHelper quickAVDataTableHelper, DBObjectProvider dBObjectProvider, HCSSchema hCSSchema, List<String> list2) {
        super(list, quickAVDataTableHelper, dBObjectProvider);
        this.schema = hCSSchema;
        this.existingObjects = list2;
        final GenericTable genericTable = this.getMetadataObjectsTable();
        genericTable.getColumnModel().getColumn(4).setCellEditor(new DimTypeCellEditor(quickAVDataTableHelper));
        genericTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)true);
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getFirstRow();
                List list = (List)QuickAVDimensionEditor.this.getMetadataObjectList();
                if (list != null) {
                    AttributeDimension attributeDimension = (AttributeDimension)list.get(n);
                    QuickAVDimensionEditor.this.dimLevelsTable.setModel((TableModel)new DimLevelTableModel(attributeDimension));
                    QuickAVDimensionEditor.this.setLevelsTableEditorAndRenderer();
                }
            }
        });
        genericTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = genericTable.getSelectedRowInModel();
                List list = (List)QuickAVDimensionEditor.this.getMetadataObjectList();
                if (list != null) {
                    AttributeDimension attributeDimension = (AttributeDimension)list.get(n);
                    QuickAVDimensionEditor.this.dimLevelsTable.setModel((TableModel)new DimLevelTableModel(attributeDimension));
                    QuickAVDimensionEditor.this.setLevelsTableEditorAndRenderer();
                }
            }
        });
    }

    @Override
    public boolean commitCellEdit() {
        boolean bl = super.commitCellEdit();
        if (this.dimLevelsTable.isEditing()) {
            return this.dimLevelsTable.getCellEditor().stopCellEditing();
        }
        return bl;
    }

    @Override
    protected void layoutComponents() {
        super.layoutComponents();
        this.levelsModel = new DimLevelTableModel(null);
        this.dimLevelsTable = new GenericTable((TableModel)this.levelsModel);
        this.setLevelsTableEditorAndRenderer();
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setComponent((JComponent)new JScrollPane((Component)this.dimLevelsTable));
        componentWithTitlebar.setLabel(new JLabel(HCSArb.getString("QUICK_AV_LEVELS")));
        this.add((Component)new JScrollPane((Component)componentWithTitlebar), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setLevelsTableEditorAndRenderer() {
        this.dimLevelsTable.getColumnModel().getColumn(3).setCellEditor(new DimLevelTypeCellEditor(this.getQuickAVTableDataHelper()));
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(3);
        QuickAVEditableCellRenderer quickAVEditableCellRenderer = new QuickAVEditableCellRenderer(hashSet);
        this.dimLevelsTable.getColumnModel().getColumn(3).setCellRenderer(quickAVEditableCellRenderer);
    }

    @Override
    protected void refreshTableModel(Object object) {
        List list = (List)this.getMetadataObjectList();
        this.model.setDimensions(list);
    }

    @Override
    protected TableModel initTableModel() {
        List list = (List)this.getMetadataObjectList();
        this.model = new DimensionsTableModel(list);
        return this.model;
    }

    @Override
    protected int getComboBoxIndexColumn() {
        return 4;
    }

    @Override
    protected String getMetadataObjectType() {
        return "ATTRIBUTE DIMENSION";
    }

    @Override
    protected List<QuickAVMetadataObjectEditorPanel.ComboTranslationPairs> getTranslationsList() {
        ArrayList<QuickAVMetadataObjectEditorPanel.ComboTranslationPairs> arrayList = new ArrayList<QuickAVMetadataObjectEditorPanel.ComboTranslationPairs>();
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("DIMENSION_TYPE_STANDARD"), DIMENSION_TYPE_STD));
        arrayList.add(new QuickAVMetadataObjectEditorPanel.ComboTranslationPairs(this, HCSArb.getString("DIMENSION_TYPE_TIME"), DIMENSION_TYPE_TIME));
        return arrayList;
    }

    @Override
    protected String getDuplicateNameErrorMessage(String string) {
        return HCSArb.format("ATTRIBUTE_DIMENSION_ERROR_DUPLICATE_DIMENSION_NAME", string);
    }

    @Override
    protected boolean isDuplicatedName(String string, int n) {
        return this.schema.findDimension(string) != null;
    }

    @Override
    protected boolean nameExists(String string) {
        return this.existingObjects.contains(this.prov.getInternalName(string));
    }

    private class DimTypeCellEditor
    extends QuickAVTableCellEditor {
        public DimTypeCellEditor(QuickAVDataTableHelper quickAVDataTableHelper) {
            super(quickAVDataTableHelper);
        }

        @Override
        protected void populateComboBoxModel(DefaultComboBoxModel defaultComboBoxModel) {
            defaultComboBoxModel.addElement(HCSArb.getString("DIMENSION_TYPE_STANDARD"));
            defaultComboBoxModel.addElement(HCSArb.getString("DIMENSION_TYPE_TIME"));
        }
    }

    private class DimensionsTableModel
    extends AbstractTableModel {
        private final int SOURCE_COLUMN_COL = 0;
        private final int DATA_TYPE_COL = 1;
        private final int NAME_COLUMN = 2;
        private final int DIMENSION_ALIAS_COL = 3;
        private final int DIMENSION_TYPE_COL = 4;
        private final String[] columns = new String[]{HCSArb.getString("QUICK_AV_DIALOG_TABLE_SOURCE_COLUMN"), HCSArb.getString("QUICK_AV_DIALOG_TABLE_DATA_TYPE_COLUMN"), HCSArb.getString("QUICK_AV_MEASURE_EDITOR_NAME_COL"), HCSArb.getString("QUICK_AV_DIMENSION_EDITOR_DIM_ALIAS_COL"), HCSArb.getString("QUICK_AV_DIMENSION_EDITOR_DIM_TYPE_COL")};
        private List<AttributeDimension> dimensions;

        public DimensionsTableModel(List<AttributeDimension> list) {
            this.dimensions = list;
        }

        public void setDimensions(List<AttributeDimension> list) {
            this.dimensions = list;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (this.dimensions != null) {
                return this.dimensions.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 3) {
                return true;
            }
            if (n2 == 0 || n2 == 1) {
                return false;
            }
            AttributeDimension attributeDimension = this.dimensions.get(n);
            return QuickAVDimensionEditor.this.schema.findDimension(attributeDimension.getName()) == null;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AttributeDimension attributeDimension = this.dimensions.get(n);
            if (attributeDimension != null) {
                Object object = null;
                switch (n2) {
                    case 0: {
                        String string = QuickAVDimensionEditor.this.prov.getExternalName((String)attributeDimension.getProperty("VIEW_NAME"));
                        object = string;
                        break;
                    }
                    case 1: {
                        object = attributeDimension.getProperty("DATA_TYPE_KEY");
                        break;
                    }
                    case 2: {
                        String string = QuickAVDimensionEditor.this.prov.getExternalName(attributeDimension.getName());
                        object = string;
                        break;
                    }
                    case 3: {
                        String string = QuickAVDimensionEditor.this.prov.getExternalName(attributeDimension.getName());
                        String string2 = QuickAVDimensionEditor.this.prov.getExternalName((String)attributeDimension.getProperty("dimensionAlias"));
                        object = string2;
                        if (object != null) break;
                        object = string;
                        break;
                    }
                    case 4: {
                        object = QuickAVDimensionEditor.this.getTranslationKey(attributeDimension.getDimensionType());
                    }
                }
                if (object != null) {
                    QuickAVDimensionEditor.this.getQuickAVTableDataHelper().quickAVMetadataChanged();
                    return object;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            AttributeDimension attributeDimension = this.dimensions.get(n);
            if (attributeDimension != null) {
                switch (n2) {
                    case 2: {
                        String string = QuickAVDimensionEditor.this.prov.getInternalName((String)object);
                        Hierarchy hierarchy = this.findHierarchyForDimension(attributeDimension);
                        if (hierarchy != null) {
                            hierarchy.setName(QuickAVDimensionGenerator.generateNameForHierarchy(string, QuickAVDimensionEditor.this.schema));
                            hierarchy.setDimensionName(string);
                        }
                        attributeDimension.setName(string);
                        break;
                    }
                    case 3: {
                        String string = QuickAVDimensionEditor.this.prov.getInternalName((String)object);
                        attributeDimension.setProperty("dimensionAlias", string);
                        break;
                    }
                    case 4: {
                        String string = (String)object;
                        attributeDimension.setDimensionType(QuickAVDimensionEditor.this.getTranslationValue(string));
                        if (!string.equalsIgnoreCase(QuickAVDimensionEditor.DIMENSION_TYPE_TIME)) break;
                        for (DimensionLevel dimensionLevel : attributeDimension.getLevels()) {
                            dimensionLevel.setLevelType(null);
                        }
                        break;
                    }
                }
                this.fireTableChanged(new TableModelEvent(this, n, n2));
            }
        }

        private Hierarchy findHierarchyForDimension(AttributeDimension attributeDimension) {
            Collection<Hierarchy> collection = QuickAVDimensionEditor.this.getAllModelHierarchies();
            if (collection != null) {
                for (Hierarchy hierarchy : collection) {
                    if (!hierarchy.getDimensionName().equalsIgnoreCase(attributeDimension.getName())) continue;
                    return hierarchy;
                }
            }
            return null;
        }
    }

    private class DimLevelTableModel
    extends AbstractTableModel {
        private final int LEVEL_NAME = 0;
        private final int LEVEL_CAPTION = 1;
        private final int LEVEL_DESCRIPTION = 2;
        private final int LEVEL_TYPE = 3;
        private final String[] columns = new String[]{HCSArb.getString("QUICK_AV_LEVEL_NAME"), HCSArb.getString("QUICK_AV_LEVEL_CAPTION"), HCSArb.getString("QUICK_AV_LEVEL_DESCRIPTION"), HCSArb.getString("QUICK_AV_LEVEL_TYPE")};
        private AttributeDimension dimension;

        public DimLevelTableModel(AttributeDimension attributeDimension) {
            this.dimension = attributeDimension;
        }

        @Override
        public int getRowCount() {
            if (this.dimension != null) {
                return this.dimension.getLevels().length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (this.dimension != null) {
                return n2 == 3 && QuickAVDimensionEditor.this.schema.findDimension(this.dimension.getName()) == null && this.dimension.isTime();
            }
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.dimension == null || this.dimension.getLevels().length == 0) {
                return null;
            }
            DimensionLevel dimensionLevel = this.dimension.getLevels()[n];
            switch (n2) {
                case 0: {
                    String string = QuickAVDimensionEditor.this.prov.getExternalName(dimensionLevel.getName());
                    return string;
                }
                case 1: {
                    return dimensionLevel.getCaption();
                }
                case 2: {
                    return dimensionLevel.getDescription();
                }
                case 3: {
                    if (dimensionLevel.getLevelType() == null || dimensionLevel.getLevelType().isEmpty()) {
                        return QuickAVDimensionEditor.DIMENSION_TYPE_STD;
                    }
                    return dimensionLevel.getLevelType();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this.dimension != null && n2 == 3) {
                String string = (String)this.getValueAt(n, 0);
                DimensionLevel dimensionLevel = this.dimension.findLevel(string = QuickAVDimensionEditor.this.prov.getInternalName(string));
                if (dimensionLevel != null) {
                    dimensionLevel.setLevelType((String)object);
                }
            }
        }
    }

    private class DimLevelTypeCellEditor
    extends QuickAVTableCellEditor {
        public DimLevelTypeCellEditor(QuickAVDataTableHelper quickAVDataTableHelper) {
            super(quickAVDataTableHelper);
        }

        @Override
        protected void populateComboBoxModel(DefaultComboBoxModel defaultComboBoxModel) {
            String[] stringArray;
            for (String string : stringArray = new String[]{"SECONDS", "MINUTES", "HOURS", "DAYS", "WEEKS", "MONTHS", "QUARTERS", "HALF_YEARS", "YEARS"}) {
                defaultComboBoxModel.addElement(string);
            }
        }
    }
}

