/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.model;

import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.References;

public abstract class DimensionedObject
extends AbstractChildObjectWithDesc {
    public DimensionedObject() {
    }

    public DimensionedObject(String string) {
        super(string);
    }

    @Internal
    public AttributeDimension getDimension() {
        return (AttributeDimension)this.getParent();
    }

    @References(value=DimensionAttribute.class, internal=true)
    public DBObjectID[] getAttributeIDs() {
        return (DBObjectID[])this.getChildSupport("visibleAttributes").getChildArray(DBObjectID.class);
    }

    public void setAttributeIDs(DBObjectID[] dBObjectIDArray) {
        this.getChildSupport("visibleAttributes").setChildArray((Object[])dBObjectIDArray);
    }

    public void addLevel(DimensionAttribute dimensionAttribute) {
        if (dimensionAttribute != null) {
            this.addAttributeImpl(dimensionAttribute, (AttributeDimension)this.getParent());
        }
    }

    private void addAttributeImpl(DimensionAttribute dimensionAttribute, AttributeDimension attributeDimension) {
        DBObjectID dBObjectID = (dimensionAttribute = this.checkAttribute(dimensionAttribute, attributeDimension)).getID();
        if (dBObjectID == null) {
            dBObjectID = TemporaryObjectID.createID((DBObject)dimensionAttribute);
            dimensionAttribute.setID(dBObjectID);
        }
        this.getChildSupport("visibleAttributes").addChild((Object)dBObjectID);
    }

    private DimensionAttribute checkAttribute(DimensionAttribute dimensionAttribute, AttributeDimension attributeDimension) {
        String string;
        if (attributeDimension == null) {
            throw new IllegalArgumentException("need a dimension set to add attributes to  " + this.getName());
        }
        if (dimensionAttribute.getDimension() != attributeDimension && (dimensionAttribute = attributeDimension.findAttribute(string = dimensionAttribute.getName())) == null) {
            throw new IllegalArgumentException("cannot add attribute " + string + " to hierarchy " + this.getName() + " - attribute doesn't exist on this attribute dimension");
        }
        return dimensionAttribute;
    }
}

