/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.awt.Component;
import java.awt.Window;
import java.sql.SQLException;
import oracle.hcs.HCSArb;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class HCSExceptionHandler {
    public static final String HCS_ERROR = "ORA-37162";

    private HCSExceptionHandler() {
    }

    public static String getErrorMessage(Exception exception) {
        String string = exception.getMessage();
        Throwable throwable = exception.getCause();
        if (throwable.getCause() instanceof SQLException && string.indexOf(HCS_ERROR) > 0) {
            return HCSExceptionHandler.extractErrorMsg(string);
        }
        return exception.getMessage();
    }

    public static void handleException(Window window, Exception exception) {
        String string = exception.getMessage();
        Throwable throwable = exception.getCause();
        if (throwable.getCause() instanceof SQLException && string.indexOf(HCS_ERROR) >= 0) {
            string = HCSExceptionHandler.extractErrorMsg(string);
        }
        HCSExceptionHandler.showError(window, HCSArb.getString("GENERIC_ERROR_TITLE"), string);
    }

    public static void showError(Window window, String string, String string2) {
        Window window2 = window != null ? window : Ide.getMainWindow();
        MessageDialog.error((Component)window2, (Object)string2, (String)string, null);
    }

    public static void handleException(Window window, String string) {
        if (string.indexOf(HCS_ERROR) >= 0) {
            string = HCSExceptionHandler.extractErrorMsg(string);
        }
        HCSExceptionHandler.showError(window, HCSArb.getString("GENERIC_ERROR_TITLE"), string);
    }

    public static void handleException(Window window, String string, String string2) {
        if (string2.indexOf(HCS_ERROR) >= 0) {
            string2 = HCSExceptionHandler.extractErrorMsg(string2);
        }
        HCSExceptionHandler.showError(window, string, string2);
    }

    private static String extractErrorMsg(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("\n", string.indexOf(HCS_ERROR));
        String string2 = string.substring(string.indexOf(HCS_ERROR), n);
        stringBuffer.append(string2 + "\n");
        int n2 = n + 1;
        n = string.indexOf("\n", n2);
        string2 = string.substring(n2, n);
        stringBuffer.append(string2 + "\n");
        n2 = n + 1;
        n = string.indexOf("\n", n2);
        string2 = string.substring(n2, n);
        stringBuffer.append(string2 + "\n");
        return stringBuffer.toString();
    }
}

