/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.avviewer;

import java.awt.Component;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.util.Logger;
import oracle.hcs.avviewer.AVViewerEditor;
import oracle.hcs.avviewer.AVViewerNode;
import oracle.hcs.avviewer.AbstractAVViewerEditorController;
import oracle.hcs.db.HCSMetadataCache;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class AVViewerEditorToolbarActions {
    static final int PIN_VIEWER_CMD_ID = Ide.findOrCreateCmdID((String)"Pin_Viewer");
    static final int REFRESH_VIEWER_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_Viewer");
    private AVViewerEditor editor;

    public AVViewerEditorToolbarActions(AVViewerEditor aVViewerEditor) {
        this.editor = aVViewerEditor;
    }

    public void initToolbarActions() {
        IdeAction ideAction = IdeAction.findOrCreate((int)PIN_VIEWER_CMD_ID, null, (String)IdeArb.getString((int)28), null, null, (Icon)OracleIcons.getIcon((String)"pin.png"), null, (boolean)true).newLocalAction((View)this.editor);
        ideAction.addController((Controller)new PinActionController(ideAction));
        IdeAction ideAction2 = IdeAction.findOrCreate((int)REFRESH_VIEWER_CMD_ID, null, (String)IdeArb.getString((int)325), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true).newLocalAction((View)this.editor);
        ideAction2.addController((Controller)new RefreshActionController(ideAction2));
    }

    private class PinActionController
    extends AbstractAVViewerEditorController {
        private ToggleToolButton pinToggle;

        public PinActionController(IdeAction ideAction) {
            this.pinToggle = new ToggleToolButton((ToggleAction)ideAction);
            ViewerNode viewerNode = (ViewerNode)AVViewerEditorToolbarActions.this.editor.getContext().getNode();
            boolean bl = viewerNode.getPinned();
            ideAction.setState(bl);
            if (!bl) {
                this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
            } else {
                this.pinToggle.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
            }
            Toolbar toolbar = AVViewerEditorToolbarActions.this.editor.getFixedTopMargin();
            toolbar.add((Component)this.pinToggle);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            ViewerNode viewerNode = (ViewerNode)AVViewerEditorToolbarActions.this.editor.getContext().getNode();
            boolean bl = !viewerNode.getPinned();
            viewerNode.setPinned(bl);
            ideAction.setState(bl);
            if (!bl) {
                this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
            } else {
                this.pinToggle.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
            }
            return true;
        }
    }

    private class RefreshActionController
    extends AbstractAVViewerEditorController {
        public RefreshActionController(IdeAction ideAction) {
            Toolbar toolbar = AVViewerEditorToolbarActions.this.editor.getFixedTopMargin();
            toolbar.add((ToggleAction)ideAction);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            AVViewerNode aVViewerNode = (AVViewerNode)context.getNode();
            try {
                HCSMetadataCache.getUpdatedSchema(aVViewerNode.getConnectionName(), aVViewerNode.getSchemaName());
            }
            catch (Exception exception) {
                Logger.severe(AVViewerEditorToolbarActions.class, (Throwable)exception);
            }
            return true;
        }
    }
}

