/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.plsql;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import oracle.dbtools.raptor.editors.AbstractDBEditor;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.dbtools.raptor.timesten.editors.TimesTenViewerContextMenu;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.icons.OracleIcons;

public abstract class BasicPlSqlTab
extends AbstractDBEditor {
    protected AbstractTableModel theModel;
    protected JTable theTable;
    protected DBObject theDbObject;
    protected static Logger theLogger = Logger.getLogger(BasicPlSqlTab.class.getPackage().getName());
    private IdeAction theRefreshAction;
    static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_Tbl_Editor");

    public void open() {
        Context context = this.getContext();
        PlSqlNode plSqlNode = (PlSqlNode)context.getNode();
        plSqlNode.addListener((Observer)this);
        this.theRefreshAction = IdeAction.get((int)REFRESH_EDITOR_CMD_ID, null, (String)Messages.getString((String)"TableBasedViewer.1"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        this.theRefreshAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                try {
                    BasicPlSqlTab.this.refreshData();
                    BasicPlSqlTab.this.theModel.fireTableDataChanged();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                return true;
            }

            public boolean update(IdeAction ideAction, Context context) {
                return false;
            }
        });
    }

    public Component getGUI() {
        if (this.theTable != null) {
            return this.theTable;
        }
        this.createTable();
        this.loadDBData();
        this.theDbObject = this.getDbObject();
        try {
            this.theModel = this.initializeModel();
            this.theTable.setModel(this.theModel);
            Toolbar toolbar = this.getFixedTopMargin();
            toolbar.add((ToggleAction)this.theRefreshAction);
            return this.theTable;
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, "PL/SQL Dependencies setModel failed " + exception.toString());
            return null;
        }
    }

    protected void createTable() {
        this.theTable = new JTable();
        this.theTable.setAutoResizeMode(0);
        this.theTable.setRowSelectionAllowed(false);
        this.theTable.setColumnSelectionAllowed(false);
        this.postCreateHook();
    }

    protected void postCreateHook() {
        this.theTable.setAutoResizeMode(0);
        TimesTenViewerContextMenu.attachMenu(this.theTable);
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (updateMessage == null) {
            this.theTable = null;
        }
    }

    public Component getScrollableTopMargin() {
        JTableHeader jTableHeader = this.theTable.getTableHeader();
        return jTableHeader;
    }

    protected abstract AbstractTableModel initializeModel() throws Exception;

    protected abstract void refreshData() throws Exception;
}

