/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.shell;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import oracle.dbtools.raptor.timesten.grid.object.MySSHException;

public class SSHShellChannel {
    private InputStream inputStream;
    private OutputStream outputStream;
    private BufferedReader bufferedReader;
    private PrintStream printStream;
    private Session session;
    private ChannelShell channel;
    public static final String CONTROL_C = "SIGINT";
    public static final String CONTROL_Z = "TSTP";
    private ReceiveSSHResponse responseObj;
    public static byte[] ENTER = new byte[]{13};
    public static byte[] UP = new byte[]{27, 79, 65};
    public static byte[] DOWN = new byte[]{27, 79, 66};
    public static byte[] RIGHT = new byte[]{27, 79, 67};
    public static byte[] LEFT = new byte[]{27, 79, 68};
    public static byte[] F1 = new byte[]{27, 79, 80};
    public static byte[] F2 = new byte[]{27, 79, 81};
    public static byte[] F3 = new byte[]{27, 79, 82};
    public static byte[] F4 = new byte[]{27, 79, 83};
    public static byte[] F5 = new byte[]{27, 79, 116};
    public static byte[] F6 = new byte[]{27, 79, 117};
    public static byte[] F7 = new byte[]{27, 79, 118};
    public static byte[] F8 = new byte[]{27, 79, 73};
    public static byte[] F9 = new byte[]{27, 79, 119};
    public static byte[] F10 = new byte[]{27, 79, 120};
    public static byte[] tab = new byte[]{9};

    public SSHShellChannel(String string, String string2, char[] cArray, String string3) throws MySSHException {
        try {
            JSch jSch = new JSch();
            if (string3 != null) {
                jSch.addIdentity(string3);
            }
            this.session = jSch.getSession(string2, string, 22);
            Properties properties = new Properties();
            properties.put("StrictHostKeyChecking", "no");
            this.session.setConfig(properties);
            if (cArray != null) {
                this.session.setPassword(new String(cArray));
            }
            this.session.connect();
            this.channel = (ChannelShell)this.session.openChannel("shell");
            this.channel.setPtyType("vt100");
            try {
                this.inputStream = this.channel.getInputStream();
                this.outputStream = this.channel.getOutputStream();
                this.bufferedReader = new BufferedReader(new InputStreamReader(this.inputStream));
                this.printStream = new PrintStream(this.outputStream);
            }
            catch (IOException iOException) {
                throw new MySSHException(iOException.getMessage(), iOException.getCause());
            }
        }
        catch (JSchException jSchException) {
            throw new MySSHException(jSchException.getMessage(), jSchException.getCause());
        }
    }

    public void connectToChannel() {
        try {
            if (this.channel != null) {
                this.channel.connect();
            }
        }
        catch (JSchException jSchException) {
            jSchException.printStackTrace();
        }
    }

    public void sendControlC() {
        this.printStream.write(3);
        this.printStream.flush();
    }

    public void sendControlD() {
        this.printStream.write(4);
        this.printStream.flush();
    }

    public void sendControlZ() {
        this.printStream.write(5);
        this.printStream.flush();
    }

    public void sendCommand(final String string) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                SSHShellChannel.this.printStream.println(string);
                SSHShellChannel.this.printStream.flush();
            }
        };
        thread.start();
    }

    public void changeTerminalSize(int n, int n2, int n3, int n4) {
        this.channel.setPtySize(n, n2, n3, n4);
    }

    public void sendSignal(String string) {
        try {
            this.channel.sendSignal(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void closeAll() {
        try {
            this.outputStream.close();
            this.inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.channel.disconnect();
        this.session.disconnect();
    }

    public static interface ReceiveSSHResponse {
        public void setSSHText(String var1);

        public void setSSHChar(char var1);

        public void backspace();
    }
}

