/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.object;

import java.text.MessageFormat;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.BasicDeletable;
import oracle.dbtools.raptor.timesten.grid.GridCommand;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.TTGridObject;

public class RepositoryObject
extends TTGridObject {
    private String location;
    private Method method;
    private String address;
    private Backup[] recentBackups;
    private Backup[] recentExports;

    public RepositoryObject(String string) {
        this.name = string;
    }

    public RepositoryObject(JsonObject jsonObject) {
        this.name = jsonObject.getString("name");
        this.location = jsonObject.getString("location");
        String string = jsonObject.getString("method");
        for (Method method : Method.values()) {
            if (!method.getValue().equals(string)) continue;
            this.method = method;
            break;
        }
        if (jsonObject.containsKey((Object)"address")) {
            this.address = jsonObject.getString("address");
        }
        JsonArray jsonArray = jsonObject.getJsonArray("recentBackups");
        JsonArray jsonArray2 = jsonObject.getJsonArray("recentExports");
        this.recentBackups = this.backupArrayFromJSON(jsonArray, Backup.Type.BACKUP);
        this.recentExports = this.backupArrayFromJSON(jsonArray2, Backup.Type.EXPORT);
    }

    private Backup[] backupArrayFromJSON(JsonArray jsonArray, Backup.Type type) {
        Backup[] backupArray = new Backup[jsonArray.size()];
        int n = 0;
        for (JsonValue jsonValue : jsonArray) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            Backup backup = new Backup(jsonObject, type);
            backupArray[n++] = backup;
        }
        return backupArray;
    }

    @Override
    public String getObjectType() {
        return Messages.getString("TimesTenGrid.RepositoryObjectName");
    }

    public Backup getBackup(String string) {
        return this.getBackupObject(string, Backup.Type.BACKUP);
    }

    public Backup getExport(String string) {
        return this.getBackupObject(string, Backup.Type.EXPORT);
    }

    private Backup getBackupObject(String string, Backup.Type type) {
        Backup[] backupArray = null;
        switch (type) {
            case BACKUP: {
                backupArray = this.recentBackups;
                break;
            }
            case EXPORT: {
                backupArray = this.recentExports;
            }
        }
        for (Backup backup : backupArray) {
            if (!backup.getName().equalsIgnoreCase(string)) continue;
            return backup;
        }
        return null;
    }

    public String getLocation() {
        return this.location;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getAddress() {
        return this.address;
    }

    public Backup[] getRecentBackups() {
        return this.recentBackups;
    }

    public Backup[] getRecentExports() {
        return this.recentExports;
    }

    public void detach(Runnable runnable) {
        BasicDeletable basicDeletable = new BasicDeletable();
        basicDeletable.setCmd(GridCommand.REPOSITORY_DETACH);
        basicDeletable.setCmdArgs(this.name);
        basicDeletable.setDeleteMsg(Messages.getString("TimesTenGrid.RepositoryDetach"));
        basicDeletable.setDeletingObjMsg(MessageFormat.format(Messages.getString("TimesTenGrid.RepositoryDetaching"), this.name));
        basicDeletable.setDeletingFromModelMsg(MessageFormat.format(Messages.getString("TimesTenGrid.RepositoryDetaching"), this.name));
        basicDeletable.setDeleteCancelMsg(Messages.getString("TimesTenGrid.RepositoryDetachCancel"));
        basicDeletable.deleteObject(runnable);
    }

    public static List<String> getPathSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("repositoryPath");
    }

    public static List<String> getAddressSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("repositoryAddress");
    }

    public static List<String> getRepoNameSuggestions() {
        return TTGridRootNode.getStorage().getSuggestion("repositoryName");
    }

    public void updateSuggestions() {
        TTGridRootNode.getStorage().saveSuggestion("repositoryPath", this.getLocation());
        TTGridRootNode.getStorage().saveSuggestion("repositoryName", this.getName());
        if (this.getMethod() == Method.SCP) {
            TTGridRootNode.getStorage().saveSuggestion("repositoryAddress", this.getAddress());
        }
    }

    public static enum Method {
        MOUNT("mount", Messages.getString("TimesTenGrid.RepositoryMethodMount")),
        SCP("scp", Messages.getString("TimesTenGrid.RepositoryMethodSCP"));

        private String value;
        private String label;

        private Method(String string2, String string3) {
            this.value = string2;
            this.label = string3;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class Backup
    extends TTGridObject {
        private String dbName;
        private String repository;
        private String state;
        private String whenStarted;
        private InstanceInfo[] instances;
        private Type type;

        public Backup(JsonObject jsonObject, Type type) {
            this.type = type;
            this.dbName = jsonObject.getString("dbName");
            this.name = jsonObject.getString("name");
            this.repository = jsonObject.getString("repository");
            this.state = jsonObject.getString("state");
            this.whenStarted = jsonObject.getString("whenStarted");
            JsonArray jsonArray = jsonObject.getJsonArray("instances");
            this.instances = new InstanceInfo[jsonArray.size()];
            int n = 0;
            for (JsonValue jsonValue : jsonArray) {
                JsonObject jsonObject2 = (JsonObject)jsonValue;
                InstanceInfo instanceInfo = new InstanceInfo(jsonObject2);
                this.instances[n++] = instanceInfo;
            }
        }

        public String getDbName() {
            return this.dbName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getState() {
            return this.state;
        }

        public String getWhenStarted() {
            return this.whenStarted;
        }

        public InstanceInfo[] getInstances() {
            return this.instances;
        }

        public Type getType() {
            return this.type;
        }

        @Override
        public String getObjectType() {
            switch (this.getType()) {
                case BACKUP: {
                    return Messages.getString("TimesTenGrid.RepositoryBackup");
                }
                case EXPORT: {
                    return Messages.getString("TimesTenGrid.RepositoryExport");
                }
            }
            return null;
        }

        public static enum Type {
            BACKUP,
            EXPORT;

        }
    }

    public static class InstanceInfo
    implements Comparable<InstanceInfo> {
        private int elementNo;
        private String hostName;
        private String instanceName;
        private String state;

        public InstanceInfo(JsonObject jsonObject) {
            this.elementNo = jsonObject.getInt("elementNo");
            this.hostName = jsonObject.getString("hostName");
            this.instanceName = jsonObject.getString("instanceName");
            this.state = jsonObject.getString("state");
        }

        public int getElementNo() {
            return this.elementNo;
        }

        public String getHostName() {
            return this.hostName;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public String getState() {
            return this.state;
        }

        @Override
        public int compareTo(InstanceInfo instanceInfo) {
            return new Integer(this.elementNo).compareTo(instanceInfo.getElementNo());
        }
    }
}

