/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.navigator;

import java.awt.event.MouseListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.navigator.GridMouseListener;
import oracle.dbtools.raptor.timesten.grid.navigator.GridNavigatorContextMenu;
import oracle.dbtools.raptor.timesten.grid.navigator.TTGridRootNode;
import oracle.dbtools.raptor.timesten.grid.object.GridObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.javatools.icons.OracleIcons;

public class GridNavigatorWindow
extends NavigatorWindow {
    private static final int REFRESH_NAV_ID = Ide.findOrCreateCmdID((String)"Grid_Nav.Refresh");
    private static final int COLLAPSE_ALL_NAV_ID = Ide.findOrCreateCmdID((String)"Grid_Nav_CollapseAll");
    private ToggleToolButton _refreshToggle;
    private ToggleToolButton _collapseAllToggle;
    private MenuToolButton _gridMenuToolButton;
    private ToolbarController _tbController;

    protected GridNavigatorWindow(ViewId viewId) {
        super(viewId);
    }

    protected void initCustomItems() {
        GridMouseListener gridMouseListener = new GridMouseListener();
        this.getTree().getTree().addMouseListener((MouseListener)gridMouseListener);
        this.getTree().getTree().addTreeWillExpandListener((TreeWillExpandListener)gridMouseListener);
        this.getTree().getTree().addTreeSelectionListener((TreeSelectionListener)gridMouseListener);
        this.setToolbarVisible(true);
    }

    protected void initCustomToolbarItems(Toolbar toolbar) {
        IdeAction ideAction = IdeAction.get((int)REFRESH_NAV_ID);
        IdeAction ideAction2 = IdeAction.get((int)COLLAPSE_ALL_NAV_ID);
        this._tbController = new ToolbarController();
        ideAction.addController((Controller)this._tbController);
        ideAction2.addController((Controller)this._tbController);
        this._gridMenuToolButton = toolbar.addMenuButton((ToggleAction[])new IdeAction[]{GridNavigatorContextMenu.ACTION_GRID_WIZARD, GridNavigatorContextMenu.ACTION_NEW_GRID});
        this._gridMenuToolButton.setToolTipText(Messages.getString("TimesTenGrid.timesTenGrid"));
        this._gridMenuToolButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this._refreshToggle = toolbar.addToggleButton((ToggleAction)ideAction);
        this._refreshToggle.setToolTipText(Messages.getString("CGWhere.Refresh"));
        this._refreshToggle.setIcon(OracleIcons.getIcon((String)"refresh.png"));
        this._collapseAllToggle = toolbar.addToggleButton((ToggleAction)ideAction2);
        this._collapseAllToggle.setToolTipText(Messages.getString("TimesTenGrid.collapseAll"));
        this._collapseAllToggle.setIcon(OracleIcons.getIcon((String)"collapseall.png"));
    }

    public String getTitleName() {
        return Messages.getString("TimesTenGrid.timesTenGrid");
    }

    protected Element getRootElement() {
        return TTGridRootNode.getInstance();
    }

    protected boolean isRootVisible() {
        return true;
    }

    protected Controller createController() {
        return new GridNavigatorContextMenu();
    }

    class ToolbarController
    implements Controller {
        ToolbarController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == REFRESH_NAV_ID) {
                GridObject gridObject = TTGridRootNode.getInstance().getGrid(TTGridRootNode.getInstance().getCurrentGrid());
                if (gridObject != null && gridObject.getGridNode() != null) {
                    GridMouseListener.updateGridInfo(gridObject.getGridNode().getCustomTree(), gridObject.getGridNode().getCustomTree().getSelectionPath(), gridObject, false, false, gridObject.getShowingVersion());
                }
                return true;
            }
            if (ideAction.getCommandId() == COLLAPSE_ALL_NAV_ID) {
                CustomTree customTree = GridNavigatorWindow.this.getTree().getTree();
                int n = customTree.getRowCount() - 1;
                while (n > 0) {
                    customTree.collapseRow(n--);
                }
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    }
}

