/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.editors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.editors.TTTableViewer;

public class ReplicationSubscriberDetails
extends TTTableViewer {
    private MyTableModel _model;
    private static final Logger _logger = Logger.getLogger(ReplicationSubscriberDetails.class.getPackage().getName());

    @Override
    protected final String GetPurposeTxt() {
        return "Replication subscriber";
    }

    @Override
    protected void createTableModel() throws Exception {
        if (this._model == null) {
            this._model = new MyTableModel();
            this._table.setModel(this._model);
        } else {
            this._model.init();
        }
        this._model.fireTableDataChanged();
    }

    @Override
    protected void postCreateHook() {
        this._table.setAutoResizeMode(3);
    }

    private class MyTableModel
    extends AbstractTableModel {
        static final int numCols = 2;
        private Vector<Object[]> theRows = new Vector(32);

        private MyTableModel() throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                _logger.log(Level.SEVERE, Messages.getString("TimesTen.common.cannotProcess") + ReplicationSubscriberDetails.this.GetPurposeTxt() + " " + sQLException.toString());
                throw sQLException;
            }
        }

        private void init() throws Exception {
            Statement statement = null;
            ResultSet resultSet = null;
            this.theRows.clear();
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                MasterDetails masterDetails;
                Iterator<Object> iterator;
                Set set;
                Connection connection = ReplicationSubscriberDetails.this._dbObject.getConnection();
                String string = ReplicationSubscriberDetails.this._dbObject.getSchemaName();
                String string2 = ReplicationSubscriberDetails.this._dbObject.getObjectName();
                if (string2.equalsIgnoreCase("_ACTIVESTANDBY")) {
                    string = TimesTenUtil.getActiveStandbyOwner(connection);
                }
                statement = connection.createStatement();
                HashMap hashMap = new HashMap(8);
                HashMap<Long, Object> hashMap2 = new HashMap<Long, Object>(32);
                resultSet = statement.executeQuery("select element_type, master_id, is_propagator, is_master_propagator from ttrep.repelements where owned_by_system = 0x00 and rtrim(replication_owner)='" + string + "' and rtrim(replication_name)='" + string2 + "'");
                boolean bl = false;
                while (resultSet.next()) {
                    bl = true;
                    set = new MasterDetails();
                    ((MasterDetails)((Object)set))._id = resultSet.getLong(2);
                    iterator = resultSet.getString(1).trim();
                    ((MasterDetails)((Object)set))._replicatedObjectType = ReplicatedObjectType.UNDEFINED;
                    if (((String)((Object)iterator)).equalsIgnoreCase("D")) {
                        ((MasterDetails)((Object)set))._replicatedObjectType = ReplicatedObjectType.DATASTORE;
                    } else if (((String)((Object)iterator)).equalsIgnoreCase("T")) {
                        ((MasterDetails)((Object)set))._replicatedObjectType = ReplicatedObjectType.TABLE;
                    } else if (((String)((Object)iterator)).equalsIgnoreCase("S")) {
                        ((MasterDetails)((Object)set))._replicatedObjectType = ReplicatedObjectType.SEQUENCE;
                    }
                    byte[] byArray = resultSet.getBytes(4);
                    byte[] byArray2 = resultSet.getBytes(3);
                    ((MasterDetails)((Object)set))._masterType = MasterType.UNDEFINED;
                    if (byArray[0] == 1) {
                        ((MasterDetails)((Object)set))._masterType = MasterType.MASTER_PROPAGATOR;
                    } else if (byArray2[0] == 0) {
                        ((MasterDetails)((Object)set))._masterType = MasterType.MASTER;
                    } else if (byArray2[0] == 1) {
                        ((MasterDetails)((Object)set))._masterType = MasterType.PROPAGATOR;
                    }
                    hashMap.put(((MasterDetails)((Object)set))._id, set);
                }
                resultSet.close();
                set = hashMap.keySet();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    resultSet = statement.executeQuery("select rtrim(host_name), rtrim(tt_store_name) from ttrep.ttstores where tt_store_id = " + l);
                    bl = resultSet.next();
                    if (!bl) {
                        statement.close();
                        return;
                    }
                    masterDetails = (MasterDetails)hashMap.get(l);
                    masterDetails._hostName = resultSet.getString(1);
                    masterDetails._dataStore = resultSet.getString(2);
                    resultSet.close();
                }
                set = hashMap.keySet();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    masterDetails = (MasterDetails)hashMap.get(l);
                    String string3 = masterDetails._replicatedObjectType == ReplicatedObjectType.DATASTORE ? "0x01" : "0x00";
                    resultSet = statement.executeQuery("select rtrim(ds_obj_owner), rtrim(ds_obj_name), durable_transmit, conflict_checks, rtrim(ts_column_name), ts_exception_action, ts_update_rule, report_format, ts_report_file from ttrep.repelements where rtrim(replication_owner)='" + string + "' and rtrim(replication_name)='" + string2 + "' and  owned_by_system = " + string3 + " and master_id = " + l);
                    object4 = null;
                    while (resultSet.next()) {
                        object4 = new ReplicationElement();
                        ((ReplicationElement)object4).objectOwner = resultSet.getString(1);
                        ((ReplicationElement)object4).objectName = resultSet.getString(2);
                        object3 = resultSet.getBytes(3);
                        ((ReplicationElement)object4).transmitDurable = object3[0] != false;
                        object2 = resultSet.getBytes(4);
                        ((ReplicationElement)object4).conflictCheckFlag = (object2[7] & 1) == 1;
                        ((ReplicationElement)object4).timestampColumn = resultSet.getString(5);
                        object = resultSet.getString(6);
                        ((ReplicationElement)object4).conflictExceptionAction = ConflictExceptionAction.UNDEFINED;
                        if (((String)object).equalsIgnoreCase("N")) {
                            ((ReplicationElement)object4).conflictExceptionAction = ConflictExceptionAction.NO_ACTION;
                        } else if (((String)object).equalsIgnoreCase("R")) {
                            ((ReplicationElement)object4).conflictExceptionAction = ConflictExceptionAction.ROLLBACK;
                        }
                        String string4 = resultSet.getString(7);
                        ((ReplicationElement)object4).tsUpdateOwner = TimestampUpdateRule.UNDEFINED;
                        if (string4.equalsIgnoreCase("U")) {
                            ((ReplicationElement)object4).tsUpdateOwner = TimestampUpdateRule.USER;
                        } else if (string4.equalsIgnoreCase("S")) {
                            ((ReplicationElement)object4).tsUpdateOwner = TimestampUpdateRule.SYSTEM;
                        }
                        String string5 = resultSet.getString(8);
                        ((ReplicationElement)object4).conflictReportFormat = ConflictReportFormat.UNDEFINED;
                        if (string5 == null) {
                            ((ReplicationElement)object4).conflictReportFormat = ConflictReportFormat.UNDEFINED;
                        } else if (string5.equalsIgnoreCase("S")) {
                            ((ReplicationElement)object4).conflictReportFormat = ConflictReportFormat.STANDARD;
                        } else if (string5.equalsIgnoreCase("X")) {
                            ((ReplicationElement)object4).conflictReportFormat = ConflictReportFormat.XML;
                        }
                        ((ReplicationElement)object4).conflictReportFile = resultSet.getString(9);
                        masterDetails._replicatedObjects.add((ReplicationElement)object4);
                    }
                    resultSet.close();
                }
                resultSet = statement.executeQuery("select host_name, tt_store_name, subscriber_id from ttrep.reppeers p, ttrep.ttstores s where rtrim(replication_owner)='" + string + "' and rtrim(replication_name)='" + string2 + "' and s.tt_store_id=p.subscriber_id");
                while (resultSet.next()) {
                    object4 = new SubscriberDetails();
                    ((SubscriberDetails)object4).subscriberId = resultSet.getLong(3);
                    hashMap2.put(((SubscriberDetails)object4).subscriberId, object4);
                    ((SubscriberDetails)object4).hostName = resultSet.getString(1);
                    ((SubscriberDetails)object4).dataStore = resultSet.getString(2);
                }
                resultSet.close();
                object4 = hashMap2.keySet();
                iterator = object4.iterator();
                object3 = null;
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    object3 = (SubscriberDetails)hashMap2.get(l);
                    resultSet = statement.executeQuery("select rtrim(e.element_name), return_service, return_by_request, master_id from ttrep.repsubscriptions b, ttrep.repelements e where b.subscriber_id=" + l + " and e.element_name=b.element_name and e.owned_by_system = 0x00");
                    bl = resultSet.next();
                    if (bl) {
                        ((SubscriberDetails)object3).elementName = resultSet.getString(1);
                        ((SubscriberDetails)object3).masterId = resultSet.getLong(4);
                        object2 = resultSet.getString(2);
                        ((SubscriberDetails)object3).returnServiceType = ReturnServiceType.UNDEFINED;
                        if (((String)object2).equalsIgnoreCase("C")) {
                            ((SubscriberDetails)object3).returnServiceType = ReturnServiceType.RETURN_COMMIT;
                        } else if (((String)object2).equalsIgnoreCase("R")) {
                            ((SubscriberDetails)object3).returnServiceType = ReturnServiceType.RETURN_RECEIPT;
                        } else if (((String)object2).equalsIgnoreCase("2")) {
                            ((SubscriberDetails)object3).returnServiceType = ReturnServiceType.RETURN_TWOSAFE;
                        }
                        object = resultSet.getBytes(3);
                        if (object[0] == 0) {
                            ((SubscriberDetails)object3).returnByRequestFlag = false;
                        } else if (object[0] == 1) {
                            ((SubscriberDetails)object3).returnByRequestFlag = true;
                        }
                    }
                    resultSet.close();
                    ((SubscriberDetails)object3).printDetails();
                    this.theRows.add(new Object[]{"", ""});
                    this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.masterDetails"), ""});
                    masterDetails = (MasterDetails)hashMap.get(((SubscriberDetails)object3).masterId);
                    masterDetails.printDetails();
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, Messages.getString("TimesTen.common.generating") + ReplicationSubscriberDetails.this.GetPurposeTxt() + Messages.getString("ReplicationSubscriberDetails.failed"), exception);
                throw exception;
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public final int getColumnCount() {
            return 2;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > 2) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("TimesTen.common.attribute");
            }
            if (n == 1) {
                return Messages.getString("TimesTen.common.value");
            }
            return null;
        }

        private class MasterDetails {
            private long _id;
            private ReplicatedObjectType _replicatedObjectType;
            private MasterType _masterType;
            private String _dataStore;
            private String _hostName;
            private List<ReplicationElement> _replicatedObjects = new ArrayList<ReplicationElement>(32);

            private MasterDetails() {
            }

            private void printDetails() {
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.masterDataStore"), this._dataStore});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("TimesTen.common.hostName"), this._hostName});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.masterPropagator"), this._masterType.getTag()});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.replicatedObjectType"), this._replicatedObjectType.getTag()});
                for (int i = 0; i < this._replicatedObjects.size(); ++i) {
                    this._replicatedObjects.get(i).printDetails();
                }
            }
        }

        private class ReplicationElement {
            private String objectOwner;
            private String objectName;
            private boolean transmitDurable;
            private boolean conflictCheckFlag;
            private String timestampColumn;
            private ConflictExceptionAction conflictExceptionAction;
            private TimestampUpdateRule tsUpdateOwner;
            private ConflictReportFormat conflictReportFormat;
            private String conflictReportFile;

            private ReplicationElement() {
            }

            private void printDetails() {
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.replicatedObject"), this.objectOwner + "." + this.objectName});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.transmitType"), this.transmitDurable ? Messages.getString("ReplicationSubscriberDetails.durable") : Messages.getString("ReplicationSubscriberDetails.nonDurable")});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.confilctCheckEnabled"), this.conflictCheckFlag ? Messages.getString("TimesTen.common.yes") : Messages.getString("TimesTen.common.no")});
                if (!this.conflictCheckFlag) {
                    return;
                }
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.timestampColumn"), this.timestampColumn});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.conflictExceptionAction"), this.conflictExceptionAction.getTag()});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.timestampUpdatedBy"), this.tsUpdateOwner.getTag()});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.confictReportFormat"), this.conflictReportFormat.getTag()});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.conflictReportfile"), this.conflictReportFile});
            }
        }

        private class SubscriberDetails {
            private long subscriberId;
            private long masterId;
            private String dataStore;
            private String hostName;
            private String elementName;
            private ReturnServiceType returnServiceType;
            private boolean returnByRequestFlag;

            private SubscriberDetails() {
            }

            private void printDetails() {
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.subscriberDatastore"), this.dataStore});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.subscriberHostname"), this.hostName});
                MyTableModel.this.theRows.add(new Object[]{Messages.getString("ReplicationSubscriberDetails.returnServiceType"), this.returnServiceType.getTag()});
                if (this.returnServiceType != ReturnServiceType.UNDEFINED) {
                    MyTableModel.this.theRows.add(new Object[]{Messages.getString("TimesTen.common.returnService"), this.returnByRequestFlag ? Messages.getString("ReplicationSubscriberDetails.byRequestOnly") : Messages.getString("ReplicationSubscriberDetails.returnServiceUnconditional")});
                }
            }
        }
    }

    static enum ReturnServiceType {
        UNDEFINED(Messages.getString("ReplicationSubscriberDetails.noReturnService")),
        RETURN_COMMIT("RETURN COMMIT"),
        RETURN_RECEIPT("RETURN RECEIPT"),
        RETURN_TWOSAFE("RETURN TWOSAFE");

        private String _tag;

        private ReturnServiceType(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    static enum ConflictReportFormat {
        UNDEFINED(Messages.getString("ReplicationSubscriberDetails.noReportFileSpecified")),
        STANDARD("Standard"),
        XML("XML");

        private String _tag;

        private ConflictReportFormat(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    static enum TimestampUpdateRule {
        UNDEFINED(Messages.getString("ReplicationSubscriberDetails.ruleNotDefined")),
        USER("User"),
        SYSTEM("System");

        private String _tag;

        private TimestampUpdateRule(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    static enum ConflictExceptionAction {
        UNDEFINED(Messages.getString("ReplicationSubscriberDetails.actionNotDefined")),
        NO_ACTION(Messages.getString("TimesTen.common.noAction")),
        ROLLBACK(Messages.getString("TimesTen.common.rollBack"));

        private String _tag;

        private ConflictExceptionAction(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    static enum MasterType {
        UNDEFINED("UNDEFINED"),
        MASTER("MASTER"),
        PROPAGATOR("PROPAGATOR"),
        MASTER_PROPAGATOR("MASTER_PROPAGATOR");

        private String _tag;

        private MasterType(String string2) {
            this._tag = string2;
        }

        private String getTag() {
            return this._tag;
        }
    }

    static enum ReplicatedObjectType {
        UNDEFINED("UNDEFINED"),
        DATASTORE("DATASTORE"),
        TABLE("TABLE"),
        SEQUENCE("SEQUENCE");

        private String _tag;

        protected String getTag() {
            return this._tag;
        }

        private ReplicatedObjectType(String string2) {
            this._tag = string2;
        }
    }
}

