/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.advisor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.utils.TableColumnSizer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class IndexAdvisorStatePanel
extends JPanel {
    private static Logger LOGGER = Logger.getLogger(IndexAdvisorStatePanel.class.getPackage().getName());
    private MyTableModel theAdvisorStateModel;
    private JTable theAdvisorState;
    private final String theAdvisorStateSql = "call ttIndexAdviceCaptureInfoGet()";
    private IndeterminateProgressMonitor _progressMonitor = null;
    private final Connection theConnection;
    private JTextPane _pane = new JTextPane();
    private JScrollPane _scrollPane = new JScrollPane(this._pane);
    private Boolean theCaptureStateKnown = Boolean.FALSE;
    private JButton theRefreshButton;
    private DBObject _dbObject;
    private JEWTDialog _dialog;
    private static final String PROGRESS = "progress";
    private static final String CONNECTION = Messages.getString("IndexAdvisor.connection");
    private static final String DATABASE = Messages.getString("IndexAdvisor.database");
    private static final String EXECUTE_SQL = Messages.getString("IndexAdvisor.executeSQL");
    private static final String PREPARE_SQL = Messages.getString("IndexAdvisor.prepareSQL");
    private static final String IN_PROGRESS = Messages.getString("IndexAdvisor.inProgress");
    private static final String COMPLETED = Messages.getString("IndexAdvisor.completed");
    private final String[] _columnNames = new String[]{Messages.getString("IndexAdvisor.connectionId"), Messages.getString("IndexAdvisor.captureLevel"), Messages.getString("IndexAdvisor.captureMode"), Messages.getString("IndexAdvisor.captureState"), Messages.getString("IndexAdvisor.preparedCount"), Messages.getString("IndexAdvisor.executeCount"), Messages.getString("IndexAdvisor.startTime"), Messages.getString("IndexAdvisor.endTime")};

    public synchronized boolean isTheCaptureStateKnown() {
        while (!this.getTheCaptureStateKnown()) {
            try {
                this.wait(5000L);
                if (!this.getTheCaptureStateKnown()) continue;
                return true;
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.SEVERE, "Interruption exception", interruptedException);
            }
        }
        return false;
    }

    private synchronized void setTheCaptureStateKnown(boolean bl) {
        this.theCaptureStateKnown = bl;
        this.notify();
    }

    public synchronized boolean getTheCaptureStateKnown() {
        return this.theCaptureStateKnown;
    }

    public IndexAdvisorStatePanel(DBObject dBObject, JEWTDialog jEWTDialog) {
        this._dbObject = dBObject;
        this._dialog = jEWTDialog;
        this.theConnection = dBObject.getConnection();
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.theAdvisorStateModel = new MyTableModel();
        this.theAdvisorState = new JTable();
        this.theAdvisorState.setModel(this.theAdvisorStateModel);
        this.theAdvisorState.setAutoResizeMode(4);
        this.theAdvisorState.setAutoCreateRowSorter(true);
        this.theAdvisorState.setFillsViewportHeight(true);
        this.theAdvisorState.setDefaultRenderer(Timestamp.class, new DateRenderer());
        this.theAdvisorState.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    TableColumnSizer.setColumnsWidthToFit(IndexAdvisorStatePanel.this.theAdvisorState, true, true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.theAdvisorState, 22, 32);
        jScrollPane.setPreferredSize(new Dimension(0, 90));
        this.add((Component)jScrollPane, "North");
        this.theRefreshButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("IndexAdvisor.refresh")));
        this.theRefreshButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("IndexAdvisor.refresh")));
        this.theRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndexAdvisorStatePanel.this.theRefreshButton.setEnabled(false);
                IndexAdvisorStatePanel.this.refresh();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.theRefreshButton);
        this.add((Component)jPanel, "South");
        this._progressMonitor = new IndeterminateProgressMonitor((Component)this, Messages.getString("IndexAdvisor.currentStatus"), (Object)Messages.getString("IndexAdvisor.currentStatus"), null);
        this._progressMonitor.setCancellable(true);
        this._progressMonitor.setMillisToPopup(0);
        this._progressMonitor.setModal(true);
        this._progressMonitor.setDetailContent((Component)this._scrollPane);
        this._progressMonitor.setBarVisible(true);
        this._progressMonitor.addCancellationListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                IndexAdvisorStatePanel.this._progressMonitor.close();
            }
        });
        this.generateState(this.theConnection);
    }

    private void refresh() {
        final ProgressMonitor progressMonitor = new ProgressMonitor(this, Messages.getString("IndexAdvisor.refreshingState"), Messages.getString("TimesTen.common.pleaseWait"), 0, 100);
        final SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                IndexAdvisorStatePanel.this.theAdvisorStateModel.initModel(IndexAdvisorStatePanel.this.theConnection);
                progressMonitor.setProgress(100);
                return null;
            }

            @Override
            protected void done() {
                super.done();
                progressMonitor.close();
                IndexAdvisorStatePanel.this.theRefreshButton.setEnabled(true);
            }
        };
        swingWorker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (IndexAdvisorStatePanel.PROGRESS.equals(propertyChangeEvent.getPropertyName())) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    if (n == 100) {
                        progressMonitor.close();
                        IndexAdvisorStatePanel.this.theRefreshButton.setEnabled(true);
                    }
                    if (progressMonitor.isCanceled() || swingWorker.isDone()) {
                        if (IndexAdvisorStatePanel.this._progressMonitor.isCanceled()) {
                            swingWorker.cancel(true);
                        } else {
                            progressMonitor.close();
                        }
                        IndexAdvisorStatePanel.this.theRefreshButton.setEnabled(true);
                    }
                }
            }
        });
        swingWorker.execute();
    }

    public void generateState(Connection connection) {
        final AdvisorStateTask advisorStateTask = new AdvisorStateTask();
        advisorStateTask.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                StyledDocument styledDocument = IndexAdvisorStatePanel.this._pane.getStyledDocument();
                if (IndexAdvisorStatePanel.PROGRESS.equals(propertyChangeEvent.getPropertyName())) {
                    int n = (Integer)propertyChangeEvent.getNewValue();
                    String string = String.format(Messages.getString("IndexAdvisor.pertentageComplete"), n);
                    try {
                        styledDocument.insertString(styledDocument.getLength(), string, null);
                    }
                    catch (BadLocationException badLocationException) {
                        LOGGER.log(Level.SEVERE, "Can't insert text", badLocationException);
                    }
                    if (IndexAdvisorStatePanel.this._progressMonitor.isCanceled() || advisorStateTask.isDone()) {
                        Toolkit.getDefaultToolkit().beep();
                        if (IndexAdvisorStatePanel.this._progressMonitor.isCanceled()) {
                            advisorStateTask.cancel(true);
                        } else {
                            IndexAdvisorStatePanel.this._progressMonitor.finish();
                        }
                    }
                }
            }
        });
        advisorStateTask.execute();
        this._progressMonitor.start();
    }

    public boolean isDataCaptureInProgress() {
        return this.theAdvisorStateModel.isDataCaptureInProgress();
    }

    private class MyTableModel
    extends AbstractTableModel {
        private final Class<?>[] _columnClasses = new Class[]{Integer.class, String.class, String.class, String.class, Integer.class, Integer.class, Timestamp.class, Timestamp.class};
        private List<CaptureInfo> _dataModel = new ArrayList<CaptureInfo>(32);
        private Connection theConnection;
        private boolean theDataCaptureInProgressFlag;

        private MyTableModel() {
        }

        private void populate(Connection connection) {
            this.initModel(connection);
            this.theConnection = connection;
            this.fireTableDataChanged();
        }

        public boolean isDataCaptureInProgress() {
            return this.theDataCaptureInProgressFlag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initModel(Connection connection) {
            Statement statement = null;
            try {
                this._dataModel.clear();
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("call ttIndexAdviceCaptureInfoGet()");
                Object var4_7 = null;
                CaptureInfo captureInfo = null;
                while (resultSet.next()) {
                    captureInfo = new CaptureInfo();
                    captureInfo.connectionId = resultSet.getObject("connId");
                    captureInfo.captureLevel = (Integer)resultSet.getObject("captureLevel");
                    captureInfo.captureState = (Integer)resultSet.getObject("captureState");
                    captureInfo.captureMode = (Integer)resultSet.getObject("captureMode");
                    captureInfo.numPrepared = (Integer)resultSet.getObject("numPrepared");
                    captureInfo.numExecuted = (Integer)resultSet.getObject("numExecuted");
                    captureInfo.captureStartTime = resultSet.getTimestamp("captureStartTime");
                    captureInfo.captureEndTime = resultSet.getTimestamp("captureEndTime");
                    this._dataModel.add(captureInfo);
                    if (!captureInfo.getIsDataCapture()) continue;
                    this.theDataCaptureInProgressFlag = true;
                }
                IndexAdvisorStatePanel.this.setTheCaptureStateKnown(true);
            }
            catch (SQLException sQLException) {
                String string = TTSQLExceptionScrubber.getInstance().getMessage(Connections.getInstance().getConnectionName(connection), sQLException);
                MessageDialog.error((Component)IndexAdvisorStatePanel.this, (Object)string, (String)Messages.getString("TimesTen.common.error"), null);
                LOGGER.log(Level.SEVERE, "Can't get captures information", sQLException);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        }

        @Override
        public int getColumnCount() {
            return IndexAdvisorStatePanel.this._columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this._dataModel.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CaptureInfo captureInfo = this._dataModel.get(n);
            switch (n2) {
                case 0: {
                    return captureInfo.connectionId;
                }
                case 1: {
                    return captureInfo.getCaptureLevelText();
                }
                case 2: {
                    return captureInfo.getCaptureModeText();
                }
                case 3: {
                    return captureInfo.getCaptureStateText();
                }
                case 4: {
                    return captureInfo.numPrepared;
                }
                case 5: {
                    return captureInfo.numExecuted;
                }
                case 6: {
                    return captureInfo.captureStartTime;
                }
                case 7: {
                    return captureInfo.captureEndTime;
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this._columnClasses[n];
        }

        @Override
        public String getColumnName(int n) {
            return IndexAdvisorStatePanel.this._columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        @Override
        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    private class AdvisorStateTask
    extends SwingWorker<Void, Void> {
        private AdvisorStateTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            IndexAdvisorStatePanel.this.theAdvisorStateModel.populate(IndexAdvisorStatePanel.this.theConnection);
            this.setProgress(100);
            return null;
        }

        @Override
        protected void done() {
            super.done();
            IndexAdvisorStatePanel.this._progressMonitor.finish();
        }
    }

    private class CaptureInfo {
        private Object connectionId;
        private Integer captureLevel;
        private Integer captureState;
        private Integer captureMode;
        private Integer numPrepared;
        private Integer numExecuted;
        private Timestamp captureStartTime;
        private Timestamp captureEndTime;

        private CaptureInfo() {
        }

        public String getCaptureLevelText() {
            if (this.captureLevel == null) {
                return "";
            }
            return this.captureLevel == 0 ? CONNECTION : DATABASE;
        }

        public String getCaptureModeText() {
            if (this.captureMode == null) {
                return "";
            }
            return this.captureMode == 0 ? EXECUTE_SQL : PREPARE_SQL;
        }

        public String getCaptureStateText() {
            if (this.captureState == null) {
                return "";
            }
            return this.captureState == 0 ? COMPLETED : IN_PROGRESS;
        }

        public boolean getIsDataCapture() {
            return this.captureLevel != null && this.captureLevel == 1 && this.captureState == 1;
        }
    }
}

