/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.searchbar;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.searchbar.Result;
import oracle.ide.view.View;
import oracle.ideimpl.searchbar.BaseController;
import oracle.ideimpl.searchbar.ProviderReference;
import oracle.ideimpl.searchbar.ResultContainer;
import oracle.ideimpl.searchbar.ShowAllProvider;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

final class SearchBarController
extends BaseController {
    private final ResultContainer resultContainer;
    private final Action openResultAction = new OpenResultAction();
    private final Action escapeAction = new EscapeAction();
    private final SearchField searchField;

    public SearchBarController(SearchField searchField, Collection<ProviderReference> providers) {
        super(providers);
        this.searchField = searchField;
        searchField.addSearchListener((SearchListener)new SL());
        this.resultContainer = new ResultContainer(searchField, new ShowAllProvider(this));
        this.resultContainer.addActionListener(this.openResultAction);
        searchField.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SearchBarController.this.hidePopup();
            }
        });
        this.installSearchFieldKeyboardActions();
    }

    private void bindKey(JComponent c, String key, String actionName, Action action) {
        c.getInputMap(1).put(KeyStroke.getKeyStroke(key), actionName);
        c.getActionMap().put(actionName, action);
    }

    private void unbindKey(JComponent c, String key) {
        KeyStroke stroke = KeyStroke.getKeyStroke(key);
        c.getInputMap(1).remove(stroke);
        c.getInputMap(0).remove(stroke);
    }

    private void installSearchFieldKeyboardActions() {
        this.unbindKey((JComponent)this.searchField, "UP");
        this.unbindKey((JComponent)this.searchField, "DOWN");
        this.unbindKey((JComponent)this.searchField, "ENTER");
        this.unbindKey((JComponent)this.searchField, "ESCAPE");
        this.bindKey((JComponent)this.searchField, "UP", "selectPreviousRow", this.resultContainer.selectPreviousRowAction());
        this.bindKey((JComponent)this.searchField, "DOWN", "selectNextRow", this.resultContainer.selectNextRowAction());
        this.bindKey((JComponent)this.searchField, "ENTER", "openSelectedAction", this.openResultAction);
        this.bindKey((JComponent)this.searchField, "ESCAPE", "escapeAction", this.escapeAction);
    }

    private void hidePopup() {
        this.resultContainer.hideResults();
        super.stopSearch(true);
    }

    private void showPopup() {
        this.resultContainer.showResults(this.model);
    }

    @Override
    synchronized void stopSearch(boolean clearResults) {
        super.stopSearch(clearResults);
        if (clearResults) {
            this.hidePopup();
        }
    }

    @Override
    synchronized void startSearch(String searchText) {
        super.startSearch(searchText);
        this.showPopup();
    }

    private class OpenResultAction
    extends AbstractAction {
        private OpenResultAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Result selection = SearchBarController.this.resultContainer.selection();
            if (!SearchBarController.this.resultContainer.isShowing()) {
                SearchBarController.this.stopSearch(false);
                SearchBarController.this.startSearch(SearchBarController.this.searchField.getText());
            }
            if (selection == null) {
                return;
            }
            selection.open();
            SearchBarController.this.searchField.clear();
            this.transferFocusAfterOpen();
        }

        private void transferFocusAfterOpen() {
            if (SearchBarController.this.searchField.hasFocus()) {
                return;
            }
            View lastView = Ide.getMainWindow().getLastActiveView();
            if (lastView == null) {
                return;
            }
            lastView.getGUI().requestFocus();
        }
    }

    private class EscapeAction
    extends AbstractAction {
        private EscapeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            View lastView = Ide.getMainWindow().getLastActiveView();
            if (lastView != null) {
                lastView.getGUI().requestFocus();
            }
        }
    }

    private class SL
    implements SearchListener {
        private SL() {
        }

        public void searchPerformed(SearchEvent se) {
            if (se.isFromClear() || se.getSearchText() == null || se.getSearchText().trim().length() == 0) {
                SearchBarController.this.stopSearch(true);
            } else {
                SearchBarController.this.stopSearch(false);
                SearchBarController.this.startSearch(se.getSearchText());
            }
        }

        public void searchCategoryChanged(SearchEvent se) {
            this.searchPerformed(se);
        }
    }
}

