/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.common;

import java.math.BigDecimal;
import oracle.dmt.dataminer.core.utils.format.NumericFormat;

public class NameValuePair
implements Comparable<NameValuePair> {
    protected String _name;
    protected BigDecimal _key;
    protected Object _value;
    protected int _count;
    protected String editedName;
    protected String rangeValue;

    public NameValuePair(String string, Object object, int n) {
        this._name = string;
        this._key = null;
        this._value = object;
        this._count = n;
    }

    public NameValuePair(BigDecimal bigDecimal, Object object, int n) {
        this._key = bigDecimal;
        this._name = bigDecimal.toString();
        this._value = object;
        this._count = n;
    }

    public NameValuePair(String string, Object object) {
        this(string, object, 1);
    }

    public String getName() {
        return this._name;
    }

    public Object getValue() {
        return this._value;
    }

    public int getCount() {
        return this._count;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setValue(Object object) {
        this._value = object;
    }

    public void setCount(int n) {
        this._count = n;
    }

    public void setKey(BigDecimal bigDecimal) {
        this._key = bigDecimal;
    }

    public BigDecimal getKey() {
        return this._key;
    }

    public void setEditedName(String string) {
        this.editedName = string;
    }

    public String getEditedName() {
        return this.editedName;
    }

    public void setRangeValue(String string) {
        this.rangeValue = string;
    }

    public String getRangeValue() {
        return this.rangeValue;
    }

    public boolean equals(Object object) {
        if (object instanceof NameValuePair) {
            NameValuePair nameValuePair = (NameValuePair)object;
            if (this._key != null && nameValuePair._key != null ? !nameValuePair._key.equals(this._key) : !nameValuePair._name.equals(this._name)) {
                return false;
            }
            if (nameValuePair._count != this._count) {
                return false;
            }
            String string = nameValuePair._value.toString();
            String string2 = this._value.toString();
            return string.equals(string2);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n += this._key != null ? this._key.hashCode() : 0;
        n += this._name != null ? this._name.hashCode() : 0;
        n += this._count;
        return n += this._value.hashCode();
    }

    @Override
    public int compareTo(NameValuePair nameValuePair) {
        return this._name.compareTo(nameValuePair._name);
    }

    public String toString() {
        return this._name + ":" + this._value;
    }

    public static boolean areEqual(double d, double d2) {
        String string = NumericFormat.format(d, true, 8);
        String string2 = NumericFormat.format(d2, true, 8);
        return string.equals(string2);
    }
}

