/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay.print;

import java.net.URL;
import java.util.Vector;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.topicDisplay.print.BaseTopicPrintJob;

public class BrowserPrintJob
extends BaseTopicPrintJob {
    private HTMLBrowser _browser;

    public BrowserPrintJob(HTMLBrowser browser) {
        this._browser = browser;
    }

    @Override
    protected void printTopicImpl(Topic topic) {
        URL pageURL = null;
        if (topic != null && topic.hasTarget()) {
            try {
                Target theTarget = topic.getTarget();
                pageURL = theTarget.getURL();
            }
            catch (Exception e) {
                pageURL = null;
            }
        }
        if (pageURL != null) {
            this._browser.printURL(pageURL);
        }
    }

    @Override
    protected void printTopicsImpl(Topic[] topics) {
        Vector<URL> urlVector = new Vector<URL>();
        if (topics != null) {
            for (int i = 0; i < topics.length; ++i) {
                Topic aTopic = topics[i];
                URL pageURL = null;
                if (aTopic.hasTarget()) {
                    try {
                        Target theTarget = aTopic.getTarget();
                        pageURL = theTarget.getURL();
                    }
                    catch (Exception e) {
                        pageURL = null;
                    }
                }
                if (pageURL == null) continue;
                urlVector.addElement(pageURL);
            }
        }
        if (urlVector.size() > 0) {
            Object[] urls = new URL[urlVector.size()];
            urlVector.copyInto(urls);
            this._browser.printURLs((URL[])urls);
        }
    }
}

