/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mle.command;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.mle.command.MLEMessages;
import oracle.dbtools.extension.mle.command.MLESymbols;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.util.Service;

public class MLEEngine {
    private String schemaName;
    private String moduleName;
    private String codeFileName;
    private Boolean isReplace;
    private Boolean ifNotExists;
    private Boolean ifExists;
    private String language;
    private String version;
    private String metadata;
    private String metaFileName;
    private String code;
    private final ScriptRunnerContext ctx;
    private final Connection conn;
    private final ParsedCommand prscmd;
    private final DBUtil dbUtil;
    private boolean verbose;

    public MLEEngine(ScriptRunnerContext context, Connection connection, ParsedCommand parsedCommand) {
        this.ctx = context;
        this.conn = connection;
        this.dbUtil = DBUtil.getInstance((Connection)this.conn);
        this.prscmd = parsedCommand;
        this.schemaName = (String)this.prscmd.getOptionValue((Id)MLESymbols.SCHEMA);
        this.moduleName = (String)this.prscmd.getOptionValue((Id)MLESymbols.MODULE_NAME);
        this.verbose = (Boolean)this.prscmd.getOptionValue((Id)MLESymbols.VERBOSE);
    }

    public void setVerbose(boolean verboseMode) {
        this.verbose = verboseMode;
    }

    public void executeCreateCommand() {
        this.codeFileName = FileUtils.getContextFile((ScriptRunnerContext)this.ctx, (String)((String)this.prscmd.getOptionValue((Id)MLESymbols.FILENAME))).toString();
        this.isReplace = (Boolean)this.prscmd.getOptionValue((Id)MLESymbols.REPLACE);
        this.ifNotExists = (Boolean)this.prscmd.getOptionValue((Id)MLESymbols.IF_NOT_EXISTS);
        this.ifExists = false;
        this.language = (String)this.prscmd.getOptionValue((Id)MLESymbols.LANGUAGE);
        this.version = (String)this.prscmd.getOptionValue((Id)MLESymbols.VERSION);
        this.metadata = (String)this.prscmd.getOptionValue((Id)MLESymbols.METADATA);
        this.metaFileName = (String)this.prscmd.getOptionValue((Id)MLESymbols.METAFILE);
        this.metaFileName = this.metaFileName == null ? null : FileUtils.getContextFile((ScriptRunnerContext)this.ctx, (String)this.metaFileName).toString();
        try {
            this.executeCreate();
        }
        catch (Throwable ex) {
            this.ctx.writeln(ex.getMessage());
            return;
        }
        if (this.metadata != null || this.metaFileName != null) {
            try {
                this.executeAlter();
            }
            catch (Throwable ex) {
                this.ctx.writeln(ex.getMessage());
            }
        }
    }

    public void executeAlterCommand() {
        this.ifExists = (Boolean)this.prscmd.getOptionValue((Id)MLESymbols.IF_EXISTS);
        this.metadata = (String)this.prscmd.getOptionValue((Id)MLESymbols.METADATA);
        this.metaFileName = (String)this.prscmd.getOptionValue((Id)MLESymbols.METAFILE);
        this.metaFileName = this.metaFileName == null ? null : FileUtils.getContextFile((ScriptRunnerContext)this.ctx, (String)this.metaFileName).toString();
        try {
            this.executeAlter();
        }
        catch (Throwable ex) {
            this.ctx.writeln(ex.getMessage());
        }
    }

    private void executeCreate() throws Exception {
        this.requires23();
        try {
            this.verboseLog("filename", this.codeFileName);
            this.code = Service.readFile((String)this.codeFileName);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(MLEMessages.format("MOD_FILE_READ", new File(this.codeFileName).getAbsoluteFile(), ex.getMessage()));
        }
        if (this.code.isEmpty()) {
            throw new IllegalArgumentException(MLEMessages.format("MOD_FILE_EMPTY", this.codeFileName));
        }
        StringBuilder sb = new StringBuilder("create ");
        if (this.isReplace.booleanValue()) {
            sb.append("or replace ");
        }
        sb.append("mle module ");
        if (this.ifNotExists.booleanValue()) {
            sb.append("if not exists ");
        }
        if (this.schemaName != null) {
            this.verboseLog("schema", this.schemaName);
        }
        this.verboseLog("name", this.moduleName);
        sb.append(this.getObjectReference());
        sb.append(" language ");
        this.verboseLog("language", this.language);
        sb.append(this.language);
        if (this.version != null) {
            sb.append(" version '");
            this.verboseLog("version", this.version);
            sb.append(this.version);
            sb.append("'");
        }
        sb.append(" as ");
        sb.append("\n");
        sb.append(this.code);
        String cmd = sb.toString();
        try {
            this.executeDDL(cmd);
            String warnings = this.getCompilationErrors(this.schemaName, this.moduleName);
            if (warnings.isEmpty()) {
                this.ctx.writeln(MLEMessages.format("MOD_CREATED", this.getObjectReference()));
            } else {
                this.ctx.writeln(MLEMessages.format("MOD_WARNINGS", this.getObjectReference(), System.lineSeparator(), warnings));
            }
        }
        catch (Throwable ex) {
            this.ctx.writeln(MLEMessages.format("MOD_NOT_CREATED", this.getObjectReference(), ex));
        }
    }

    private void requires23() throws Exception {
        DatabaseMetaData md = this.conn.getMetaData();
        if (md.getDatabaseMajorVersion() < 23) {
            throw new IllegalArgumentException(MLEMessages.get("NO_MLE_SUPPORT"));
        }
    }

    private void executeAlter() throws Exception {
        String normalized;
        this.requires23();
        if (this.metadata != null && this.metaFileName != null) {
            throw new IllegalArgumentException(MLEMessages.get("META_EXCL_ERR"));
        }
        if (this.metadata == null && this.metaFileName == null) {
            throw new IllegalArgumentException(MLEMessages.get("META_REQ_ERR"));
        }
        if (this.metaFileName != null) {
            this.verboseLog("metafile", this.metaFileName);
            this.metadata = Service.readFile((String)this.metaFileName);
        }
        this.verboseLog("metadata", this.metadata);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(this.metadata));
        try {
            JsonObject json = jsonReader.readObject();
            normalized = json.toString();
        }
        catch (Throwable ex) {
            this.ctx.writeln(MLEMessages.format("MOD_NOT_ALTERED", this.moduleName, MLEMessages.get("INVALID_META") + ": " + ex.getMessage()));
            return;
        }
        StringBuilder sb = new StringBuilder("alter mle module ");
        if (this.ifExists.booleanValue()) {
            sb.append("if exists ");
        }
        if (this.schemaName != null) {
            this.verboseLog("schema", this.schemaName);
        }
        this.verboseLog("name", this.moduleName);
        sb.append(this.getObjectReference());
        sb.append(" set metadata using clob (").append(System.lineSeparator());
        sb.append("select json('").append(System.lineSeparator());
        sb.append(normalized);
        if (!this.metadata.endsWith(System.lineSeparator())) {
            sb.append(System.lineSeparator());
        }
        sb.append("')").append(System.lineSeparator());
        sb.append(")");
        try {
            this.executeDDL(sb.toString());
            this.ctx.writeln(MLEMessages.format("MOD_ALTERED", this.getObjectReference()));
        }
        catch (Throwable ex) {
            this.ctx.writeln(MLEMessages.format("MOD_NOT_ALTERED", this.getObjectReference(), ex.getMessage()));
        }
    }

    private String getObjectReference() {
        if (this.schemaName != null) {
            return this.schemaName + "." + this.moduleName;
        }
        return this.moduleName;
    }

    private String getCompilationErrors(String schema, String object) {
        String qry;
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("name", object.toUpperCase());
        if (schema == null) {
            qry = "select TEXT from USER_ERRORS where NAME=:name and TYPE='MLE MODULE' order by SEQUENCE";
        } else {
            qry = "select TEXT from DBA_ERRORS where OWNER=:owner and NAME=:name and TYPE='MLE MODULE' order by SEQUENCE";
            binds.put("owner", schema.toUpperCase());
        }
        StringBuilder sb = new StringBuilder();
        try {
            ResultSet rs = this.executeQry(qry, binds);
            while (rs.next()) {
                sb.append(rs.getString(1)).append(System.lineSeparator());
            }
        }
        catch (Throwable ex) {
            sb.append(MLEMessages.get("NO_ERR_PRIV") + ": ").append(ex.getMessage());
        }
        return sb.toString();
    }

    private void executeDDL(String cmd) throws Exception {
        this.verboseLog("SQL statement", cmd);
        Statement stm = this.conn.createStatement();
        stm.setEscapeProcessing(false);
        stm.execute(cmd);
    }

    private ResultSet executeQry(String cmd, HashMap<String, String> binds) throws Exception {
        this.verboseLog("SQL statement", cmd);
        this.verboseLog("SQL statement placeholders", binds.toString());
        PreparedStatement stm = this.dbUtil.prepareExecute(cmd, binds);
        return stm.executeQuery();
    }

    private void verboseLog(String key, String value) {
        if (this.verbose) {
            this.ctx.writeln(String.format("%s: %s", key, value));
        }
    }
}

