/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class ArrayMap<K, V>
extends AbstractMap<K, V> {
    private ArrayEntry[] entries;
    private int size;
    private int version;
    private ArrayEntrySet entrySet;

    public ArrayMap() {
        this.entries = (ArrayEntry[])Array.newInstance(ArrayEntry.class, 4);
    }

    public ArrayMap(int size) {
        this.entries = (ArrayEntry[])Array.newInstance(ArrayEntry.class, size);
    }

    public ArrayMap(Map<? extends K, ? extends V> map) {
        this.size = map.size();
        int capacity = (int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE);
        this.entries = (ArrayEntry[])Array.newInstance(ArrayEntry.class, capacity);
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.entries[index++] = new ArrayEntry(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyIndex(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int i = this.size;
            while (--i >= 0) {
                if (this.entries[i].value != null) continue;
                return true;
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (!value.equals(this.entries[i].value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        ArrayEntry entry = this.getEntry(key);
        return entry != null ? (V)entry.value : null;
    }

    @Override
    public V put(K key, V value) {
        return this.put(this.keyIndex(key), value, key);
    }

    @Override
    public V remove(Object key) {
        return this.removeIndex(this.keyIndex(key));
    }

    @Override
    public void clear() {
        ++this.version;
        int i = this.size;
        while (--i >= 0) {
            this.entries[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ArrayEntrySet();
        }
        return this.entrySet;
    }

    private int keyIndex(Object key) {
        int i = this.size;
        if (key == null) {
            while (--i >= 0 && this.entries[i].key != null) {
            }
        } else {
            while (--i >= 0 && !key.equals(this.entries[i].key)) {
            }
        }
        return i;
    }

    private ArrayEntry getEntry(Object key) {
        if (key == null) {
            int i = this.size;
            while (--i >= 0) {
                if (this.entries[i].key != null) continue;
                return this.entries[i];
            }
        } else {
            int i = this.size;
            while (--i >= 0) {
                if (!key.equals(this.entries[i].key)) continue;
                return this.entries[i];
            }
        }
        return null;
    }

    private V put(int index, V value, K key) {
        ++this.version;
        if (index >= 0) {
            ArrayEntry entry = this.entries[index];
            Object oldValue = entry.value;
            entry.value = value;
            return oldValue;
        }
        if (this.size == this.entries.length) {
            int newLength = this.size + this.size;
            ArrayEntry[] newEntries = (ArrayEntry[])Array.newInstance(ArrayEntry.class, newLength);
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            this.entries = newEntries;
        }
        this.entries[this.size] = new ArrayEntry(key, value);
        ++this.size;
        return null;
    }

    private V removeIndex(int index) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        ++this.version;
        Object oldValue = this.entries[index].value;
        if (index < --this.size) {
            this.entries[index] = this.entries[this.size];
            this.entries[this.size] = null;
        } else {
            this.entries[index] = null;
        }
        return oldValue;
    }

    private class ArrayEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public ArrayEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            Object thatKey = that.getKey();
            if (!Objects.equals(this.key, thatKey)) {
                return false;
            }
            Object thatValue = that.getValue();
            return Objects.equals(this.value, thatValue);
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + " = " + this.getValue();
        }
    }

    private class ArrayEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private ArrayEntrySet() {
        }

        @Override
        public int size() {
            return ArrayMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.size == 0;
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry thatEntry = (Map.Entry)object;
            ArrayEntry thisEntry = ArrayMap.this.getEntry(thatEntry.getKey());
            return thisEntry != null && Objects.equals(thisEntry.value, thatEntry.getValue());
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ArrayEntryIterator();
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[ArrayMap.this.size];
            System.arraycopy(ArrayMap.this.entries, 0, array, 0, ArrayMap.this.size);
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            if (array.length < ArrayMap.this.size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), ArrayMap.this.size);
            }
            System.arraycopy(ArrayMap.this.entries, 0, array, 0, ArrayMap.this.size);
            if (array.length > ArrayMap.this.size) {
                array[ArrayMap.this.size] = null;
            }
            return array;
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            Object key = entry.getKey();
            boolean added = !ArrayMap.this.containsKey(key);
            ArrayMap.this.put(key, entry.getValue());
            return added;
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object key = entry.getKey();
            int index = ArrayMap.this.keyIndex(key);
            if (index < 0) {
                return false;
            }
            Object value = entry.getValue();
            if (Objects.equals(value, ArrayMap.this.entries[index].value)) {
                ArrayMap.this.removeIndex(index);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ArrayMap.this.clear();
        }
    }

    private class ArrayEntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int index;
        private int expectedVersion;
        private boolean removable;

        public ArrayEntryIterator() {
            this.expectedVersion = ArrayMap.this.version;
        }

        @Override
        public boolean hasNext() {
            return this.index < ArrayMap.this.size;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.expectedVersion != ArrayMap.this.version) {
                throw new ConcurrentModificationException();
            }
            if (this.index >= ArrayMap.this.size) {
                throw new NoSuchElementException();
            }
            this.removable = true;
            return ArrayMap.this.entries[this.index++];
        }

        @Override
        public void remove() {
            if (this.expectedVersion != ArrayMap.this.version) {
                throw new ConcurrentModificationException();
            }
            if (!this.removable) {
                throw new IllegalStateException();
            }
            ArrayMap.this.removeIndex(this.index - 1);
            this.expectedVersion = ArrayMap.this.version;
            this.removable = false;
        }
    }
}

