/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.model;

import java.util.List;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceElement;

public interface SourceHasModifiers
extends SourceElement {
    public int getModifiers();

    public void addModifiers(int var1);

    public void setModifiers(int var1);

    public void removeModifiers(int var1);

    public boolean isValidModifiers(int var1);

    public List<SourceAnnotation> getSourceAnnotations();

    default public boolean hasSourceAnnotation(String annotationName) {
        if (annotationName == null || annotationName.isEmpty()) {
            return false;
        }
        List<SourceAnnotation> annotations = this.getSourceAnnotations();
        if (annotations.isEmpty()) {
            return false;
        }
        int dotIndex = annotationName.lastIndexOf(46);
        boolean qualified = false;
        if (dotIndex >= 0) {
            if (dotIndex == 9 && annotationName.substring(0, dotIndex).equals("java.lang")) {
                annotationName = annotationName.substring(dotIndex + 1);
            } else {
                qualified = true;
            }
        }
        for (SourceAnnotation annotation : annotations) {
            String thisAnnotationName = annotation.getName();
            if (!qualified) {
                dotIndex = thisAnnotationName.lastIndexOf(46);
                if (dotIndex >= 0) {
                    thisAnnotationName = thisAnnotationName.substring(dotIndex + 1);
                }
                if (!annotationName.equals(thisAnnotationName)) continue;
                return true;
            }
            if (annotationName.equals(thisAnnotationName)) {
                return true;
            }
            JavaType javaType = annotation.getResolvedType();
            if (javaType == null || !javaType.getRawName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }
}

