/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.stmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchLabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchRuleSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchStatementGroupSym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.Stmt;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceSwitchRule;
import oracle.javatools.parser.java.v2.model.SourceSwitchStatementGroup;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;

public final class SwitchStmt
extends Stmt
implements SourceSwitchStatement {
    @Override
    public boolean isExpression() {
        return false;
    }

    @Override
    public boolean isStatement() {
        return true;
    }

    @Override
    public SourceExpression getSelectorExpression() {
        return this.getExpressionSym();
    }

    @Override
    public SourceBlock getSwitchBlock() {
        return this.getBlockSymOverride();
    }

    @Override
    public boolean hasRules() {
        SwitchLabelSym label = (SwitchLabelSym)this.getSym((byte)48, 2, 23);
        return label.hasRule();
    }

    @Override
    public List<SourceSwitchRule> getRules() {
        if (this.hasStatementGroups()) {
            return null;
        }
        ArrayList<SourceSwitchRule> rules = new ArrayList<SourceSwitchRule>();
        for (SourceSwitchLabel label : this.getBlockSymOverride().getSyms((byte)23)) {
            rules.add(new SwitchRuleSym(this.getBlockSymOverride(), label, label.getSiblingAfter()));
        }
        return rules;
    }

    @Override
    public boolean hasStatementGroups() {
        SwitchLabelSym label = (SwitchLabelSym)this.getSym((byte)48, 2, 23);
        return label.hasStatementGroup();
    }

    @Override
    public List<SourceSwitchStatementGroup> getStatementGroups() {
        if (this.hasRules()) {
            return null;
        }
        ArrayList<SourceSwitchStatementGroup> groups = new ArrayList<SourceSwitchStatementGroup>();
        ArrayList<SourceSwitchLabel> labels = null;
        List<SourceElement> elements = null;
        boolean wasLabel = false;
        boolean wasOther = false;
        for (SourceElement element : this.getSwitchBlock().getCodeElements()) {
            if (element instanceof SwitchLabelSym) {
                SwitchLabelSym label = (SwitchLabelSym)element;
                if (wasOther) {
                    groups.add(new SwitchStatementGroupSym(this, this.getBlockSymOverride(), labels, elements));
                    labels = new ArrayList<SwitchLabelSym>(Collections.singletonList(label));
                    elements = new ArrayList<SourceElement>();
                } else if (wasLabel) {
                    labels.add(label);
                } else {
                    labels = new ArrayList<SourceSwitchLabel>(Collections.singletonList(label));
                }
                wasLabel = true;
                wasOther = false;
                continue;
            }
            if (wasOther) {
                elements.add(element);
            } else if (wasLabel) {
                elements = new ArrayList<SourceElement>(Collections.singletonList(element));
            }
            wasOther = true;
            wasLabel = false;
        }
        if (labels != null && !labels.isEmpty()) {
            if (elements == null) {
                elements = Collections.emptyList();
            }
            groups.add(new SwitchStatementGroupSym(this, this.getBlockSymOverride(), (List<SourceSwitchLabel>)labels, elements));
        }
        return groups;
    }

    @Override
    public List<SourceSwitchLabel> getSwitchLabels() {
        BlockSym block = this.getBlockSymOverride();
        if (block == null) {
            return Collections.emptyList();
        }
        return block.getChildrenList(23);
    }

    @Override
    public short getStatementToken() {
        return 134;
    }

    private BlockSym getBlockSymOverride() {
        return (BlockSym)this.getSym((byte)48, 2);
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        return switch (symKind) {
            case 48, 81 -> true;
            default -> super.isValidChildSymKind(symKind);
        };
    }

    @Override
    protected JavaElement compileImplImpl(CompilerDriver compiler) {
        JavaElement result = super.compileImplImpl(compiler);
        if (!compiler.skipCompilations()) {
            compiler.compile(this);
        }
        return result;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

