/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageA;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.LambdaParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InvokeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LambdaExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodReferenceExpr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceWrapperExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.util.Conversions;

abstract class ContextImageB
extends ContextImageA {
    private static final int PASS_1 = 1;
    private static final int PASS_2 = 2;
    private static final int PASS_3 = 3;

    ContextImageB(CompilerDriver compiler, Sym cookie) {
        super(compiler, cookie);
    }

    protected final boolean findVisibleMethod(JavaType targetType, String name) {
        Collection<JavaMethod> declaredMethods;
        if (targetType == null) {
            return false;
        }
        if ("<init>".equals(name)) {
            ContextImageB.panic(this.symCookie);
        }
        if ((declaredMethods = targetType.getDeclaredMethods(name)).size() > 0) {
            return true;
        }
        boolean targetIsNonAbstractClass = this.isNonAbstractClass(targetType);
        Iterator<JavaType> hierarchy = targetType.getHierarchy().iterator();
        boolean isJdk8 = this.compiler.jdkVersion.isGreaterThanOrEqualTo8();
        while (hierarchy.hasNext()) {
            boolean lookingForNonAbstractMethods;
            JavaType type = hierarchy.next();
            boolean bl = lookingForNonAbstractMethods = type.isInterface() && targetIsNonAbstractClass;
            if (!isJdk8 && lookingForNonAbstractMethods) continue;
            for (JavaMethod thing : type.getDeclaredMethods(name)) {
                if (isJdk8 && lookingForNonAbstractMethods && thing.isAbstract() || !this.processVisible(thing)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaMethod findSingleMethod(JavaType targetType, String name, JavaType[] arguments) {
        if (targetType == null) {
            return null;
        }
        ArrayList<JavaMethod> visible = ContextImageB.allocArrayList();
        try {
            if ("<init>".equals(name)) {
                visible.addAll(targetType.getDeclaredConstructors());
            } else {
                visible.addAll(targetType.getDeclaredMethods(name));
                boolean targetIsNonAbstractClass = this.isNonAbstractClass(targetType);
                for (JavaType type : targetType.getHierarchy()) {
                    if (type.isInterface() && targetIsNonAbstractClass) continue;
                    for (JavaMethod method : type.getDeclaredMethods(name)) {
                        if (!this.processVisible(method)) continue;
                        visible.add(method);
                    }
                }
            }
            if (visible.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            this.findMostSpecificMethod(visible, arguments, false);
            if (visible.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            if (visible.size() == 1) {
                JavaMethod javaMethod = visible.get(0);
                return javaMethod;
            }
            JavaMethod javaMethod = this.chooseMostSpecificMethod(visible);
            return javaMethod;
        }
        finally {
            ContextImageB.freeArrayList(visible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaMethod findMethod(InvokeExpr invokeExpression, JavaType targetType, String name, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes, JavaHasType primary) {
        ArrayList<JavaMethod> potential = ContextImageB.allocArrayList();
        try {
            this.findPotentiallyApplicable(targetType, name, typeArguments, argumentTypes, potential, primary);
            JavaMethod javaMethod = this.processMethods(invokeExpression, potential, typeArguments, arguments, argumentTypes, false);
            return javaMethod;
        }
        finally {
            ContextImageB.freeArrayList(potential);
        }
    }

    protected final List<JavaMethod> findMethods(JavaType targetType, String name, JavaType[] typeArguments, JavaHasType primary) {
        ArrayList<JavaMethod> potential = new ArrayList<JavaMethod>();
        this.findPotentiallyApplicable(targetType, name, typeArguments, null, potential, primary);
        for (int i = 0; i < potential.size(); ++i) {
            JavaMethod method = potential.get(i);
            if (!method.hasTypeParameters() || typeArguments == null || typeArguments.length != method.getTypeParameters().size()) continue;
            potential.set(i, ContextImageB.createParameterizedMethod(this.compiler.provider, method, typeArguments));
        }
        return potential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaMethod findImportedMethod(InvokeExpr invokeExpression, String name, JavaHasType[] arguments, JavaType[] argumentTypes) {
        this.flag_instance = false;
        ArrayList<JavaMethod> potential = ContextImageB.allocArrayList();
        try {
            this.processImportedMethods(name, null, argumentTypes, potential);
            JavaMethod javaMethod = this.processMethods(invokeExpression, potential, null, arguments, argumentTypes, false);
            return javaMethod;
        }
        finally {
            ContextImageB.freeArrayList(potential);
        }
    }

    protected final List<JavaMethod> findImportedMethods(String name) {
        this.flag_instance = false;
        ArrayList<JavaMethod> potential = new ArrayList<JavaMethod>();
        this.processImportedMethods(name, null, null, potential);
        return potential;
    }

    protected final boolean checkException(Sym scope, JavaType thrown) {
        if (thrown instanceof JavaTypeVariable) {
            JavaTypeVariable v = (JavaTypeVariable)thrown;
            Collection<JavaType> bounds = v.getBounds();
            JavaClass exception = this.compiler.provider.getClass("java.lang.Exception");
            JavaClass throwable = this.compiler.provider.getClass("java.lang.Throwable");
            boolean extendsThrowable = false;
            boolean extendsException = false;
            for (JavaType type : bounds) {
                if (type.isSubtypeOf(exception)) {
                    extendsException = true;
                    break;
                }
                if (!type.equals(throwable)) continue;
                extendsThrowable = true;
            }
            if (!extendsException && extendsThrowable) {
                return true;
            }
        }
        byte scopeType = scope.symKind;
        switch (scopeType) {
            case 6: 
            case 19: {
                SourceMethod methodSym = (SourceMethod)((Object)scope);
                for (JavaType declared : methodSym.getExceptions()) {
                    if ("java.security.PrivilegedActionException".equals(declared.getRawName())) {
                        return true;
                    }
                    if (!thrown.isSubtypeOf(declared)) continue;
                    return true;
                }
                this.error((short)49, thrown);
                return true;
            }
            case 18: {
                Sym grandParent;
                Sym parent;
                return this.compiler.jdkVersion.isGreaterThanOrEqualTo7() && (parent = scope.getParentSym()) != null && parent.symKind == 30 && (grandParent = parent.getParentSym()) != null && grandParent.symKind == 63 && this.tryCatchesException((SourceTryStatement)((Object)grandParent), thrown);
            }
            case 2: {
                Sym grandparent;
                Sym parent = scope.getParentSym();
                return parent != null && parent.symKind == 48 && (grandparent = parent.getParentSym()) != null && grandparent.symKind == 63 && this.tryCatchesException((SourceTryStatement)((Object)grandparent), thrown);
            }
            case 5: {
                this.error((short)49, thrown);
                return true;
            }
        }
        return false;
    }

    private boolean tryCatchesException(SourceTryStatement tryStmt, JavaType thrown) {
        List<JavaType> caughtExceptions = tryStmt.getCaughtExceptions();
        for (JavaType caughtException : caughtExceptions) {
            if (thrown.isSubtypeOf(caughtException)) {
                return true;
            }
            if (!"java.security.PrivilegedActionException".equals(caughtException.getRawName())) continue;
            return true;
        }
        return false;
    }

    protected final List<ImportSym> getValidStaticImports(FileSym sourceFile) {
        List<SourceImport> importSyms = sourceFile.getSourceImports();
        ArrayList<ImportSym> staticImportList = new ArrayList<ImportSym>();
        for (SourceImport sym : importSyms) {
            ImportSym importSym = (ImportSym)sym;
            if (!importSym.isStatic() || importSym.isInvalid()) continue;
            staticImportList.add(importSym);
        }
        return staticImportList;
    }

    public final JavaMethod processMethods(InvokeExpr invokeExpression, ArrayList<JavaMethod> potential, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes, boolean prohibitBoxing) {
        JavaMethod method;
        if (typeArguments == null) {
            typeArguments = JavaType.EMPTY_ARRAY;
        }
        if ((method = this.processMethodsImpl(potential, typeArguments, arguments, argumentTypes, prohibitBoxing, false)) == null) {
            return null;
        }
        if (!method.hasTypeParameters()) {
            return method;
        }
        JavaType targetType = null;
        if (typeArguments.length == 0) {
            if (invokeExpression != null) {
                Sym rhsExpr = invokeExpression;
                Sym parentSym = invokeExpression.getParentSym();
                while (parentSym != null && parentSym.getSymbolKind() == 81) {
                    parentSym = parentSym.getParentSym();
                    rhsExpr = rhsExpr.getParentSym();
                }
                if (parentSym != null) {
                    Collection<JavaType> targetTypes;
                    int kind = parentSym.getSymbolKind();
                    boolean getTargetType = false;
                    switch (kind) {
                        case 7: 
                        case 10: 
                        case 17: 
                        case 52: 
                        case 58: 
                        case 59: 
                        case 64: {
                            getTargetType = true;
                            break;
                        }
                        case 68: {
                            SourceAssignmentExpression assignment = (SourceAssignmentExpression)((Object)parentSym);
                            getTargetType = rhsExpr == assignment.getSecondOperand();
                            break;
                        }
                    }
                    if (getTargetType && !(targetTypes = CommonUtilities.getTargetType(invokeExpression, null)).isEmpty()) {
                        targetType = targetTypes.iterator().next();
                    }
                }
            }
            if ((typeArguments = this.inferTypeArguments(method, arguments, argumentTypes, targetType)).length == 0) {
                return method;
            }
        }
        if (method.hasActualTypeArguments()) {
            ContextImageB.panic("But it already has actual type arguments.");
        }
        return ContextImageB.createParameterizedMethod(this.compiler.provider, method, typeArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaMethod processMethodsImpl(ArrayList<JavaMethod> potential, JavaType[] tArguments, JavaHasType[] arguments, JavaType[] argumentTypes, boolean prohibitBoxing, boolean resolvingMethodReference) {
        if (tArguments == null) {
            tArguments = JavaType.EMPTY_ARRAY;
        }
        if (potential.isEmpty()) {
            return null;
        }
        ArrayList<JavaMethod> applicable = ContextImageB.allocArrayList();
        try {
            int pass = -1;
            if (applicable.isEmpty()) {
                pass = 1;
                this.findApplicable(pass, tArguments, arguments, argumentTypes, potential, applicable, prohibitBoxing, resolvingMethodReference);
            }
            if (applicable.isEmpty()) {
                pass = 2;
                this.findApplicable(pass, tArguments, arguments, argumentTypes, potential, applicable, prohibitBoxing, resolvingMethodReference);
            }
            if (applicable.isEmpty()) {
                pass = 3;
                this.findApplicable(pass, tArguments, arguments, argumentTypes, potential, applicable, prohibitBoxing, resolvingMethodReference);
            }
            if (applicable.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            if (applicable.size() == 1) {
                JavaMethod javaMethod = applicable.get(0);
                return javaMethod;
            }
            this.findMostSpecificMethod(applicable, argumentTypes, pass == 2 || pass == 3);
            if (applicable.isEmpty()) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            if (applicable.size() == 1) {
                JavaMethod javaMethod = applicable.get(0);
                return javaMethod;
            }
            JavaMethod result = this.chooseMostSpecificMethod(applicable);
            if (result != null) {
                JavaMethod javaMethod = result;
                return javaMethod;
            }
            this.error((short)41);
            JavaMethod javaMethod = null;
            return javaMethod;
        }
        finally {
            ContextImageB.freeArrayList(applicable);
        }
    }

    private void findPotentiallyApplicable(JavaType targetType, String targetName, JavaType[] typeArguments, JavaType[] arguments, ArrayList<JavaMethod> output, JavaHasType primary) {
        if (targetType == null) {
            return;
        }
        boolean isJdk8 = this.compiler.jdkVersion.isGreaterThanOrEqualTo8();
        boolean targetIsNonAbstractClass = this.isNonAbstractClass(targetType);
        ArrayList<JavaMethod> rejected = new ArrayList<JavaMethod>();
        boolean lookForNonAbstractMethods = targetType.isInterface() && targetIsNonAbstractClass;
        this.findPotentiallyApplicableImpl(targetType, targetName, typeArguments, arguments, output, primary, false, rejected);
        if ("<init>".equals(targetName)) {
            return;
        }
        for (JavaType type : targetType.getHierarchy()) {
            boolean bl = lookForNonAbstractMethods = type.isInterface() && targetIsNonAbstractClass;
            if (!isJdk8 && lookForNonAbstractMethods) continue;
            this.findPotentiallyApplicableImpl(type, targetName, typeArguments, arguments, output, primary, isJdk8 && lookForNonAbstractMethods, rejected);
        }
    }

    private boolean isNonAbstractClass(JavaType type) {
        if (type.isInterface() || type.isAbstract() || type.isEnum()) {
            return false;
        }
        int elementKind = type.getElementKind();
        return elementKind != 10 && elementKind != 11;
    }

    private void findPotentiallyApplicableImpl(JavaType targetType, String targetName, JavaType[] tArguments, JavaType[] argumentTypes, ArrayList<JavaMethod> output, JavaHasType primary, boolean lookForNonAbstractMethods, List<JavaMethod> rejected) {
        int argCount = argumentTypes == null ? -1 : argumentTypes.length;
        boolean findConstructors = "<init>".equals(targetName);
        Iterator<JavaMethod> methods = findConstructors ? targetType.getDeclaredConstructors().iterator() : targetType.getDeclaredMethods(targetName).iterator();
        if (rejected == null) {
            rejected = new ArrayList<JavaMethod>();
        }
        this.findPotentiallyApplicableMethods(methods, tArguments, argCount, output, primary, lookForNonAbstractMethods, rejected, findConstructors);
    }

    public void findPotentiallyApplicableMethods(Iterator<JavaMethod> methods, JavaType[] tArguments, int argCount, ArrayList<JavaMethod> output, JavaHasType primary, boolean lookForNonAbstractMethods, List<JavaMethod> rejected, boolean findConstructors) {
        int derivedMethodCount = output.size();
        block0: while (methods.hasNext()) {
            JavaMethod method = methods.next();
            rejected.add(method);
            if (lookForNonAbstractMethods && method.isAbstract()) continue;
            if (derivedMethodCount > 0 && method.isStatic()) {
                JavaClass owningClass = method.getOwningClass();
                boolean owningClassIsInterface = owningClass != null && owningClass.isInterface();
                String methodName = method.getName();
                if (owningClassIsInterface && methodName != null) {
                    for (int x = 0; x < derivedMethodCount; ++x) {
                        String outputMethodName;
                        JavaMethod outputMethod = output.get(x);
                        if (outputMethod.isStatic() && methodName.equals(outputMethodName = outputMethod.getName())) continue block0;
                    }
                }
            }
            if (argCount >= 0) {
                int arity;
                boolean isVarargs = method.isVarargs();
                int parameterCount = method.getParameters().size();
                if (isVarargs ? argCount < (arity = parameterCount - 1) : parameterCount != argCount) continue;
            }
            if (tArguments != null) {
                int typeParameterCount = method.getTypeParameters().size();
                int typeArgCount = tArguments.length;
                if (typeArgCount > 0 && typeParameterCount != typeArgCount) continue;
            }
            if (!findConstructors && !this.flag_instance && !method.isStatic() || !this.processVisible(method) || !this.allowAccess(method, primary)) continue;
            JavaClass owner = method.getOwningClass();
            if (this.compiler.jdkVersion.isGreaterThanOrEqualTo8() && owner != null && owner.isInterface() && !method.isAbstract()) {
                for (JavaMethod reject : rejected) {
                    JavaClass rejectOwner;
                    if (reject == method || (rejectOwner = reject.getOwningClass()) == null || rejectOwner.equals(owner) || !rejectOwner.isSubtypeOf(owner) || !Conversions.hasSubsignatureOf(reject, method)) continue;
                    continue block0;
                }
            }
            output.add(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImportedMethods(String name, JavaType[] tArguments, JavaType[] arguments, ArrayList<JavaMethod> output) {
        FileSym sourceFile = this.symCookie.symFile;
        if (sourceFile == null) {
            return;
        }
        List<ImportSym> importSyms = this.getValidStaticImports(sourceFile);
        if (importSyms.size() == 0) {
            return;
        }
        HashSet<String> signatures = new HashSet<String>();
        ArrayList<JavaMethod> tmp = ContextImageB.allocArrayList();
        try {
            for (ImportSym importSym : importSyms) {
                String fqname;
                int lastDot;
                String importedName;
                if (!importSym.isNarrow() || !(importedName = (lastDot = (fqname = importSym.getName()).lastIndexOf(46)) == -1 ? fqname : fqname.substring(lastDot + 1)).equals(name)) continue;
                this.processImportedMethods(importSym, name, tArguments, arguments, signatures, tmp, output);
            }
            HashSet<String> importKeys = new HashSet<String>();
            for (ImportSym importSym : importSyms) {
                String importName;
                if (importSym.isNarrow() || importKeys.contains(importName = importSym.getName())) continue;
                importKeys.add(importName);
                this.processImportedMethods(importSym, name, tArguments, arguments, signatures, tmp, output);
            }
        }
        finally {
            ContextImageB.freeArrayList(tmp);
        }
    }

    private void processImportedMethods(ImportSym importSym, String name, JavaType[] tArguments, JavaType[] arguments, HashSet<String> signatures, ArrayList<JavaMethod> tmp, ArrayList<JavaMethod> output) {
        JavaType qualifying;
        importSym.resolve();
        if (qualifying == null) {
            return;
        }
        tmp.clear();
        for (qualifying = importSym.getQualifyingType(); qualifying != null; qualifying = qualifying.getSuperclass()) {
            this.findPotentiallyApplicableImpl(qualifying, name, tArguments, arguments, tmp, null, false, null);
        }
        if (tmp.isEmpty()) {
            return;
        }
        for (JavaMethod method : tmp) {
            String signature = method.getSignature();
            if (signatures.contains(signature)) continue;
            signatures.add(signature);
            output.add(method);
            importSym.setUsed();
            ArrayList<JavaHasType> importList = importSym.getImportObj().importList;
            if (importList == null || importList.contains(method)) continue;
            importList.add(method);
        }
    }

    private void findApplicable(int pass, JavaType[] typeArguments, JavaHasType[] arguments, JavaType[] argumentTypes, ArrayList<JavaMethod> input, ArrayList<JavaMethod> output, boolean prohibitBoxing, boolean resolvingMethodReference) {
        int typeArgCount = typeArguments.length;
        int argCount = arguments.length;
        Iterator<JavaMethod> iterator = input.iterator();
        block0: while (iterator.hasNext()) {
            Collection<JavaTypeVariable> typeParameterCollection;
            JavaMethod method = iterator.next();
            if (typeArgCount > 0 && pass == 1 && (typeParameterCollection = method.getTypeParameters()).size() != typeArgCount) {
                iterator.remove();
                continue;
            }
            Collection<JavaVariable> parameterCollection = method.getParameters();
            int parameterCount = parameterCollection.size();
            boolean isVararg = method.isVarargs();
            if (argCount != parameterCount && (pass < 3 || !isVararg)) continue;
            Iterator<JavaVariable> parameters = parameterCollection.iterator();
            JavaVariable parameter = null;
            for (int a = 0; a < argCount; ++a) {
                boolean isLambdaParam;
                if (parameters.hasNext()) {
                    parameter = parameters.next();
                }
                JavaHasType argumentA = arguments[a];
                JavaType argumentType = argumentTypes[a];
                if (argumentType == null) continue;
                JavaType parameterType = parameter.getResolvedType();
                if (pass == 3 && parameterType != null && parameter.isVarargs()) {
                    if (parameterType.isArray()) {
                        parameterType = parameterType.getComponentType();
                    } else {
                        IllegalStateException e = new IllegalStateException("Varargs parameter not an array type");
                        e.printStackTrace();
                    }
                }
                while (argumentA instanceof SourceWrapperExpression) {
                    argumentA = ((SourceWrapperExpression)argumentA).getFirstOperand();
                }
                if (this.compiler.jdkVersion.isGreaterThanOrEqualTo8() && (argumentA instanceof LambdaExpr || argumentA instanceof MethodReferenceExpr)) {
                    if (pass == 1 && argumentA instanceof MethodReferenceExpr && ((MethodReferenceExpr)argumentA).resolutionRequiredBoxing()) continue block0;
                    if (argumentA instanceof LambdaExpr) {
                        int lambdaParamCount;
                        JavaMethod functionalInterfaceMethod = CommonUtilities.getFunctionalInterfaceMethod(parameterType);
                        if (functionalInterfaceMethod == null || (lambdaParamCount = ((LambdaExpr)argumentA).getFormalParameterTypes().length) != functionalInterfaceMethod.getParameters().size()) continue block0;
                        parameterType = functionalInterfaceMethod.getResolvedType();
                    }
                }
                if (parameterType == null) {
                    iterator.remove();
                    continue block0;
                }
                boolean allowBoxing = !prohibitBoxing && 2 <= pass && this.compiler.jdkVersion.isGreaterThanOrEqualTo5();
                boolean bl = isLambdaParam = argumentA instanceof Expr && ((Expr)argumentA).getResolvedObject() instanceof LambdaParameterSym;
                if ((resolvingMethodReference || isLambdaParam) && (argumentType.getElementKind() == 10 || argumentType.getElementKind() == 11)) {
                    if (ContextImageB.applyMethodConversion(parameterType, argumentType, allowBoxing, this.compiler.provider, this.compiler.jdkVersion)) continue;
                    continue block0;
                }
                if (argumentA instanceof SourceMethodCallExpression) {
                    argumentType = this.resolveMethodCallUsingTargetType((SourceMethodCallExpression)argumentA, parameterType, argumentType);
                }
                if (!ContextImageB.applyMethodConversion(argumentType, parameterType, allowBoxing, this.compiler.provider, this.compiler.jdkVersion)) continue block0;
            }
            output.add(method);
        }
    }

    public void findMostSpecificMethod(ArrayList<JavaMethod> methods, JavaType[] argumentTypes, boolean allowBoxing) {
        HashSet<JavaMethod> losers = new HashSet<JavaMethod>();
        for (JavaMethod favorite : methods) {
            if (losers.contains(favorite)) continue;
            JavaClass favoriteClass = favorite.getOwningClass();
            for (JavaMethod contender : methods) {
                JavaType paramType;
                JavaType[] contenderParamTypes;
                int len;
                if (losers.contains(contender) || favorite.equals(contender)) continue;
                JavaClass contenderClass = contender.getOwningClass();
                boolean favored = false;
                if (favoriteClass != null && !favoriteClass.equals(contenderClass) && favorite.hasSubsignatureOf(contender)) {
                    favored = true;
                } else if (ContextImageB.isMoreSpecific(favorite, contender, argumentTypes, allowBoxing, this.compiler.provider, this.compiler.jdkVersion) && !ContextImageB.isMoreSpecific(contender, favorite, argumentTypes, allowBoxing, this.compiler.provider, this.compiler.jdkVersion)) {
                    favored = true;
                } else if (favoriteClass != null && contenderClass != null && !favoriteClass.isInterface() && contenderClass.isInterface() && !favorite.isAbstract() && !contender.isAbstract()) {
                    favored = true;
                } else if (favorite.isVarargs() && !contender.isVarargs() && (len = (contenderParamTypes = contender.getParameterTypes()).length) > 0 && (paramType = contenderParamTypes[contenderParamTypes.length - 1]) != null && (paramType.isArray() || len == 1 && paramType.getElementKind() == 10)) {
                    favored = true;
                }
                if (!favored) continue;
                losers.add(contender);
            }
        }
        methods.removeAll(losers);
    }

    private JavaMethod chooseMostSpecificMethod(ArrayList<JavaMethod> methods) {
        Iterator<JavaMethod> iterator = methods.iterator();
        JavaMethod output = null;
        String masterDescriptor = null;
        boolean sameDescriptors = true;
        while (iterator.hasNext()) {
            JavaMethod javaMethod = iterator.next();
            if ((javaMethod.getModifiers() & 0x400) == 0) {
                if (output != null) {
                    return null;
                }
                output = javaMethod;
            }
            if (!sameDescriptors) continue;
            String descriptor = javaMethod.getDescriptor();
            if (masterDescriptor == null) {
                masterDescriptor = descriptor;
                continue;
            }
            sameDescriptors = masterDescriptor.equals(descriptor);
        }
        if (output != null) {
            return output;
        }
        if (!sameDescriptors) {
            return null;
        }
        return methods.get(0);
    }

    JavaType[] inferTypeArguments(JavaMethod method, JavaHasType[] arguments, JavaType[] argumentTypes, JavaType targetType) {
        int x;
        Collection<JavaTypeVariable> typeParameters;
        int tpCount;
        if (argumentTypes == null) {
            argumentTypes = new JavaType[]{};
        }
        if (arguments == null) {
            arguments = new JavaHasType[]{};
        }
        if ((tpCount = (typeParameters = method.getTypeParameters()).size()) == 0) {
            ContextImageB.panic("No parameters");
        }
        JavaTypeVariable[] tpArray = typeParameters.toArray(new JavaTypeVariable[tpCount]);
        JavaType[] constraints = new JavaType[tpCount];
        for (x = 0; x < tpCount; ++x) {
            constraints[x] = null;
        }
        this.inferTypeArguments(method, tpArray, arguments, argumentTypes, targetType, constraints);
        for (x = 0; x < tpCount; ++x) {
            if (constraints[x] == null) continue;
            this.fillInMissingConstraints(constraints, tpArray, tpCount);
            return constraints;
        }
        return new JavaType[0];
    }

    void inferTypeArguments(JavaMethod method, JavaTypeVariable[] tpArray, JavaHasType[] arguments, JavaType[] argumentTypes, JavaType targetType, JavaType[] constraints) {
        if (argumentTypes.length == 0 && targetType == null) {
            return;
        }
        JavaType[] parameters = method.getParameterTypes();
        if (method.isVarargs() && parameters.length > 0) {
            JavaType lastParameter;
            boolean takeComponentType;
            boolean bl = takeComponentType = argumentTypes.length > parameters.length;
            if (argumentTypes.length == parameters.length) {
                JavaType lastArg = argumentTypes[argumentTypes.length - 1];
                if (lastArg == null || !lastArg.isArray()) {
                    takeComponentType = true;
                } else {
                    JavaType argComponentType = lastArg.getComponentType();
                    if (argComponentType != null && argComponentType.isPrimitive()) {
                        takeComponentType = true;
                    }
                }
            }
            if (takeComponentType && (lastParameter = parameters[parameters.length - 1]) != null && lastParameter.isArray()) {
                parameters[parameters.length - 1] = lastParameter.getComponentType();
            }
        }
        int loopCount = Math.min(parameters.length, argumentTypes.length);
        for (int i = 0; i < loopCount; ++i) {
            JavaMethod functionalInterfaceMethod;
            JavaType parameter = parameters[i];
            if (this.compiler.jdkVersion.isGreaterThanOrEqualTo8() && arguments[i] instanceof LambdaExpr && (functionalInterfaceMethod = CommonUtilities.getFunctionalInterfaceMethod(parameter)) != null) {
                parameter = functionalInterfaceMethod.getResolvedType();
            }
            this.inferFromOneArgument(parameter, argumentTypes[i], tpArray, constraints);
        }
        if (targetType != null) {
            this.inferFromTargetType(method.getReturnType(), targetType, tpArray, constraints);
        }
    }

    void fillInMissingConstraints(JavaType[] constraints, JavaTypeVariable[] tpArray, int tpCount) {
        for (int i = 0; i < tpCount; ++i) {
            if (constraints[i] == null) {
                constraints[i] = tpArray[i];
            }
            if (constraints[i] == null || constraints[i].getElementKind() != 11) continue;
            JavaWildcardType wildcard = (JavaWildcardType)constraints[i];
            Collection<JavaType> bounds = wildcard.getUpperBounds();
            if (bounds.isEmpty()) {
                bounds = wildcard.getLowerBounds();
            }
            constraints[i] = !bounds.isEmpty() ? bounds.iterator().next() : constraints[i].getTypeErasure();
        }
    }

    void inferFromTargetType(JavaType returnType, JavaType targetType, JavaType[] typeParameters, JavaType[] constraints) {
        if (returnType == null || targetType == null) {
            return;
        }
        if (!ContextImageB.hasTypeParameter(returnType, typeParameters)) {
            return;
        }
        if (targetType.isPrimitive()) {
            targetType = ContextImageB.applyBoxingConversion(targetType, (JavaProvider)this.compiler.provider, this.compiler.jdkVersion);
        }
        this.inferFromTargetTypeImpl(returnType, targetType, typeParameters, constraints);
    }

    private void inferFromTargetTypeImpl(JavaType returnType, JavaType targetType, JavaType[] tArray, JavaType[] constraints) {
        if (returnType == null || targetType == null) {
            return;
        }
        block0 : switch (returnType.getElementKind()) {
            case 10: {
                int count = tArray.length;
                for (int i = 0; i < count; ++i) {
                    int constraintsElemKind;
                    if (!returnType.equals(tArray[i])) continue;
                    int targetElemKind = targetType.getElementKind();
                    int n = constraintsElemKind = constraints[i] != null ? constraints[i].getElementKind() : -1;
                    if (constraints[i] != null && (constraintsElemKind != 10 || targetElemKind != 3) && (targetElemKind != 3 || constraintsElemKind != 3 || !targetType.isAssignableFrom(constraints[i]))) break block0;
                    constraints[i] = targetType;
                    break block0;
                }
                break;
            }
            case 3: {
                JavaClass rawReturnType;
                if (returnType.isArray() && targetType.isArray()) {
                    this.inferFromTargetTypeImpl(returnType.getComponentType(), targetType.getComponentType(), tArray, constraints);
                    break;
                }
                if (!returnType.hasActualTypeArguments() || this.inferFromTargetTypeClass(returnType, rawReturnType = returnType.getTypeErasure(), targetType, tArray, constraints)) break;
                for (JavaType superType : returnType.getHierarchy()) {
                    JavaClass rawSuperType;
                    if (this.inferFromTargetTypeClass(superType, rawSuperType = superType.getTypeErasure(), targetType, tArray, constraints)) break;
                }
                break;
            }
        }
    }

    private boolean inferFromTargetTypeClass(JavaType returnType, JavaType rawReturnType, JavaType targetType, JavaType[] tArray, JavaType[] constraints) {
        boolean match = rawReturnType.equals(targetType.getTypeErasure());
        if (targetType.hasActualTypeArguments() && match) {
            Iterator<JavaType> returnTypeTypeArgs = returnType.getActualTypeArguments().iterator();
            Iterator<JavaType> targetTypeTypeArgs = targetType.getActualTypeArguments().iterator();
            while (returnTypeTypeArgs.hasNext() && targetTypeTypeArgs.hasNext()) {
                JavaType returnTypeTypeArg = returnTypeTypeArgs.next();
                JavaType targetTypeTypeArg = targetTypeTypeArgs.next();
                this.inferFromTargetTypeImpl(returnTypeTypeArg, targetTypeTypeArg, tArray, constraints);
            }
        }
        return match;
    }

    void inferFromOneArgument(JavaType parameter, JavaType argument, JavaType[] typeParameters, JavaType[] constraints) {
        JavaType a;
        if (argument == null || parameter == null) {
            return;
        }
        if (!ContextImageB.hasTypeParameter(parameter, typeParameters)) {
            return;
        }
        if (argument.isPrimitive()) {
            if ("null".equals(argument.getQualifiedName())) {
                return;
            }
            a = ContextImageB.applyBoxingConversion(argument, (JavaProvider)this.compiler.provider, this.compiler.jdkVersion);
        } else {
            a = argument;
        }
        this.inferFromOneArgumentImpl(parameter, a, typeParameters, constraints);
    }

    private void inferFromOneArgumentImpl(JavaType f, JavaType a, JavaType[] tArray, JavaType[] constraints) {
        if (f == null || a == null) {
            return;
        }
        block0 : switch (f.getElementKind()) {
            case 11: {
                JavaWildcardType wildcardType = (JavaWildcardType)f;
                Collection<JavaType> fBounds = wildcardType.getUpperBounds();
                if (fBounds.isEmpty()) {
                    fBounds = wildcardType.getLowerBounds();
                }
                if (a.getElementKind() == 11) {
                    wildcardType = (JavaWildcardType)a;
                    Collection<JavaType> aBounds = wildcardType.getUpperBounds();
                    if (aBounds.isEmpty()) {
                        aBounds = wildcardType.getLowerBounds();
                    }
                    Iterator<JavaType> fBoundIter = fBounds.iterator();
                    Iterator<JavaType> aBoundIter = aBounds.iterator();
                    while (fBoundIter.hasNext() && aBoundIter.hasNext()) {
                        JavaType fBound = fBoundIter.next();
                        JavaType aBound = aBoundIter.next();
                        this.inferFromOneArgumentImpl(fBound, aBound, tArray, constraints);
                    }
                    return;
                }
                if (fBounds.isEmpty()) break;
                for (JavaType boundType : fBounds) {
                    this.inferFromOneArgumentImpl(boundType, a, tArray, constraints);
                }
                break;
            }
            case 10: {
                int count = tArray.length;
                for (int i = 0; i < count; ++i) {
                    if (!f.equals(tArray[i])) continue;
                    if (constraints[i] != null && !a.isAssignableFrom(constraints[i])) break block0;
                    constraints[i] = a;
                    break block0;
                }
                break;
            }
            case 3: {
                JavaClass g;
                if (f.isArray() && a.isArray()) {
                    this.inferFromOneArgumentImpl(f.getComponentType(), a.getComponentType(), tArray, constraints);
                    break;
                }
                if (!f.hasActualTypeArguments() || this.inferFromClass(f, g = f.getTypeErasure(), a, tArray, constraints)) break;
                for (JavaType supertype : a.getHierarchy()) {
                    if (this.inferFromClass(f, g, supertype, tArray, constraints)) break;
                }
                break;
            }
        }
    }

    private boolean inferFromClass(JavaType f, JavaType g, JavaType a, JavaType[] tArray, JavaType[] constraints) {
        boolean match = g.equals(a.getTypeErasure());
        if (a.hasActualTypeArguments() && match) {
            Iterator<JavaType> fActuals = f.getActualTypeArguments().iterator();
            Iterator<JavaType> aActuals = a.getActualTypeArguments().iterator();
            while (fActuals.hasNext() && aActuals.hasNext()) {
                JavaType u = fActuals.next();
                JavaType v = aActuals.next();
                this.inferFromOneArgumentImpl(u, v, tArray, constraints);
            }
        }
        return match;
    }

    JavaType resolveMethodCallUsingTargetType(SourceMethodCallExpression rhsExpr, JavaType lhsType, JavaType methodType) {
        Collection<JavaTypeVariable> originalMethodTypeParams;
        JavaMethod resolvedMethod;
        JavaMethod originalMethod;
        if (lhsType == null) {
            return methodType;
        }
        JavaHasType resolvedObject = rhsExpr.getResolvedObject();
        if (resolvedObject instanceof JavaMethod && (originalMethod = (resolvedMethod = (JavaMethod)resolvedObject).getNonParameterizedMethod()) != null && (originalMethodTypeParams = originalMethod.getTypeParameters()).size() > 0) {
            JavaType[] inferredTypeArgs;
            SourceListExpression argumentList = rhsExpr.getArgumentList();
            JavaHasType[] arguments = new JavaHasType[argumentList.getOperandCount()];
            JavaType[] argumentTypes = new JavaType[argumentList.getOperandCount()];
            boolean error = false;
            for (int x = 0; x < argumentList.getOperandCount(); ++x) {
                SourceExpression argument = argumentList.getOperandAt(x);
                JavaHasType argumentResolvedObject = argument.getResolvedObject();
                if (argumentResolvedObject == null) {
                    error = true;
                } else {
                    arguments[x] = argumentResolvedObject;
                }
                JavaType argumentResolvedType = argument.getResolvedType();
                if (argumentResolvedType == null) {
                    error = true;
                    continue;
                }
                argumentTypes[x] = argumentResolvedType;
            }
            if (!error && (inferredTypeArgs = this.inferTypeArguments(originalMethod, arguments, argumentTypes, lhsType)).length == originalMethodTypeParams.size()) {
                JavaMethod newResolvedMethod = ContextImageB.createParameterizedMethod(this.compiler.provider, originalMethod, inferredTypeArgs);
                return newResolvedMethod.getResolvedType();
            }
        }
        return methodType;
    }
}

