/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickComponent;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.ConstantExpressionEvaluator;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.CatchParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.LambdaParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.AssertStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.DoStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ExpressionStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.IfStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ReturnStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SwitchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SynchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ThrowStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.TryStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.WhileStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.YieldStmt;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceSwitchElement;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesElement;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.util.Conversions;

abstract class CompilerLayer4
extends CompilerLayer3 {
    CompilerLayer4() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaAnnotation resolve(AnnotateSym sym) {
        TypeSym typeSym = sym.getTypeSym();
        if (typeSym != null) {
            JavaType result = typeSym.getResolvedType();
            if (result == null) {
                return sym;
            }
            if (result.isAnnotation() && sym.getArgumentCount() > 0) {
                ListExpr args = sym.getArgumentListSym();
                CompilerContext savedContext = this.getCompilerContext();
                try {
                    this.setCompilerContext(this.newContext(sym));
                    this.processComponents(result, sym, args);
                }
                finally {
                    this.setCompilerContext(savedContext);
                }
            }
        }
        return sym;
    }

    public final JavaAnnotation compile(AnnotateSym sym) {
        assert (!this.skipCompilations());
        sym.resolve();
        JavaType annotateType = sym.getResolvedType();
        if (annotateType == null) {
            return sym;
        }
        if (!annotateType.isAnnotation()) {
            this.error(sym, (short)64, annotateType);
            return sym;
        }
        if (sym.dimensionIndex > 0 && !CommonUtilities.isTypeUseAnnotation(sym, false)) {
            this.error(sym, (short)123);
            return sym;
        }
        if (sym.getArgumentCount() == 0) {
            Collection<JavaMethod> methods = annotateType.getDeclaredMethods();
            for (JavaMethod method : methods) {
                if (method.getDefaultValue() != null) continue;
                this.error(sym, (short)108, method);
                break;
            }
        }
        return sym;
    }

    public final JavaElement compile(BlockSym sym) {
        assert (!this.skipCompilations());
        this.processBlockDuplicates(sym);
        return sym;
    }

    public final JavaElement compile(TryStmt sym) {
        List<SourceTryResourcesElement> resourcesElements;
        assert (!this.skipCompilations());
        if (sym.hasTryResourcesElements() && (resourcesElements = sym.getTryResourcesElements()).size() > 0) {
            JavaClass autoCloseable;
            this.processDuplicates(sym.getSyms((byte)119));
            if (this.jdkVersion.isGreaterThanOrEqualTo7() && (autoCloseable = this.provider.getClassByVMName("java/lang/AutoCloseable")) != null) {
                for (SourceTryResourcesElement element : resourcesElements) {
                    SourceSimpleNameExpression name;
                    JavaType type;
                    if (element.getSymbolKind() == 18) {
                        List<SourceVariable> vars = ((SourceLocalVariableDeclaration)element).getVariables();
                        for (SourceVariable var : vars) {
                            JavaType type2 = var.getResolvedType();
                            if (type2 == null || type2.isSubtypeOf(autoCloseable)) continue;
                            this.error((Sym)((Object)var), (short)86);
                        }
                        continue;
                    }
                    if (element.getSymbolKind() != 77 || (type = (name = (SourceSimpleNameExpression)element).getResolvedType()) == null || type.isSubtypeOf(autoCloseable)) continue;
                    this.error((Sym)((Object)name), (short)86);
                }
            }
        }
        return sym;
    }

    public final JavaVariable resolve(VariableSym sym) {
        return sym;
    }

    public final JavaVariable compile(VariableSym sym) {
        assert (!this.skipCompilations());
        Expr e = sym.getExpressionSym();
        if (e != null) {
            JavaType lhsType = sym.getResolvedType();
            this.processConversion(lhsType, e, Conversions.ConversionType.ASSIGNMENT);
        }
        return sym;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaType resolve(CatchParameterSym sym) {
        ArrayList resolvedTypes = CompilerLayer4.allocArrayList();
        try {
            List<SourceTypeReference> list = sym.getSourceTypes();
            for (SourceTypeReference type : list) {
                JavaType resolvedType = type.getResolvedType();
                if (resolvedType == null) continue;
                resolvedTypes.add(resolvedType);
            }
            if (resolvedTypes.isEmpty()) {
                Iterator<SourceTypeReference> iterator = null;
                return iterator;
            }
            if (!this.skipCompilations()) {
                block5: for (int i = 0; i < resolvedTypes.size(); ++i) {
                    for (int j = i + 1; j < resolvedTypes.size(); ++j) {
                        String lubName;
                        JavaType two;
                        JavaType one = (JavaType)resolvedTypes.get(i);
                        JavaType lub = CompilerUtilities.leastUpperBound(this.provider, one, two = (JavaType)resolvedTypes.get(j));
                        if (lub == null || !(lubName = lub.getRawName()).equals(one.getRawName()) && !lubName.equals(two.getRawName())) continue;
                        this.error(sym, (short)85);
                        break block5;
                    }
                }
            }
            while (resolvedTypes.size() > 1) {
                JavaType two;
                JavaType one = (JavaType)resolvedTypes.get(0);
                JavaType lub = CompilerUtilities.leastUpperBound(this.provider, one, two = (JavaType)resolvedTypes.get(1));
                if (lub == null) {
                    resolvedTypes.remove(1);
                    continue;
                }
                resolvedTypes.remove(0);
                resolvedTypes.remove(0);
                resolvedTypes.add(0, lub);
            }
            JavaType javaType = (JavaType)resolvedTypes.get(0);
            return javaType;
        }
        finally {
            CompilerLayer4.freeArrayList(resolvedTypes);
        }
    }

    public final JavaType resolve(LambdaParameterSym sym) {
        if (sym.isInferredFormalParameter()) {
            JavaMethod targetMethod;
            SourceLambdaExpression parent = sym.getOwningLambdaExpression();
            if (parent != null && (targetMethod = parent.getTargetMethod()) != null) {
                JavaType[] targetParameterTypes;
                int targetMethodIndex = -1;
                List<SourceLambdaParameter> formalParameters = parent.getFormalParameters();
                for (int i = 0; i < formalParameters.size(); ++i) {
                    if (sym != formalParameters.get(i)) continue;
                    targetMethodIndex = i;
                    break;
                }
                if (targetMethodIndex > 0 && targetMethodIndex < (targetParameterTypes = targetMethod.getParameterTypes()).length) {
                    return targetParameterTypes[targetMethodIndex];
                }
            }
            return null;
        }
        return sym.getSourceType().getResolvedType();
    }

    public final JavaElement compile(ExpressionStmt sym) {
        assert (!this.skipCompilations());
        this.processExpressionStatement(sym.getExpressionSym());
        return null;
    }

    public final JavaElement compile(ForStmt sym) {
        Expr conditionalSym;
        assert (!this.skipCompilations());
        if (sym.getForType() == 2) {
            SourceLocalVariable localVariable;
            JavaType lhsType;
            Expr collectionSym = sym.getCollectionSym();
            JavaType elementType = this.getEnhancedLoopElementType(sym);
            List<SourceLocalVariable> forVariables = sym.getForVariables();
            if (forVariables.size() > 0 && !Conversions.applyAssignmentConversion(elementType, collectionSym, lhsType = (localVariable = forVariables.get(0)).getResolvedType(), false, this.provider, this.jdkVersion)) {
                this.error((Sym)((Object)localVariable), (short)43, elementType, lhsType);
            }
        } else {
            this.processExpressionStatements(sym.getInitializationsSym());
            this.processExpressionStatements(sym.getUpdatesSym());
        }
        if (sym.getForType() != 2 && (conditionalSym = sym.getConditionalSym()) != null) {
            this.checkExpressionIsBoolean(conditionalSym);
        }
        return sym;
    }

    public final JavaElement compile(ReturnStmt sym) {
        assert (!this.skipCompilations());
        JavaType returnType = null;
        boolean isConstructor = false;
        Conversions.ConversionType conversionType = Conversions.ConversionType.ASSIGNMENT;
        for (Sym owner = sym.getParentSym(); owner != null; owner = owner.getParentSym()) {
            Sym parent;
            if (owner.symKind != 2 || (parent = owner.getParentSym()) == null) continue;
            if (parent.isFilter((byte)104)) {
                if (parent.symKind != 19 && parent.symKind != 6) break;
                returnType = ((SourceMethod)((Object)parent)).getReturnType();
                isConstructor = parent.symKind == 6;
                break;
            }
            if (parent.symKind != 83) continue;
            returnType = ((SourceLambdaExpression)((Object)parent)).getResolvedType();
            if (returnType != null && returnType.isPrimitive()) {
                returnType = Conversions.applyBoxingConversion(returnType, (JavaProvider)this.provider, this.jdkVersion);
            }
            conversionType = Conversions.ConversionType.METHOD;
            break;
        }
        Expr e = sym.getExpressionSym();
        if (CompilerLayer4.isVoidType(returnType) || isConstructor) {
            if (e != null) {
                this.error(e, (short)76);
            }
        } else if (returnType != null) {
            if (e != null) {
                JavaType type;
                boolean typeIsFine;
                JavaHasType hasType = e.getResolvedObject();
                boolean bl = typeIsFine = e.getSymbolKind() == 82;
                if (!typeIsFine && e.getSymbolKind() == 76) {
                    SourceExpression questionOperand = e.getSecondOperand();
                    if (questionOperand != null && questionOperand.getSymbolKind() == 82) {
                        typeIsFine = true;
                    } else {
                        questionOperand = e.getThirdOperand();
                        if (questionOperand != null && questionOperand.getSymbolKind() == 82) {
                            typeIsFine = true;
                        }
                    }
                }
                if (!typeIsFine && hasType instanceof JavaType) {
                    this.error(e, (short)74, hasType);
                }
                if ((type = e.getResolvedType()) != null) {
                    this.processConversion(returnType, e, conversionType);
                }
            } else {
                this.error(sym, (short)43, PrimitiveType.getVoidType(), returnType);
            }
        }
        return null;
    }

    public final JavaElement compile(YieldStmt sym) {
        Expr expression;
        assert (!this.skipCompilations());
        block4: for (Sym owner = sym.getParentSym(); owner != null; owner = owner.getParentSym()) {
            switch (owner.symKind) {
                case 85: {
                    break block4;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 19: 
                case 60: 
                case 83: {
                    this.error(sym, (short)129);
                    return null;
                }
                default: {
                    continue block4;
                }
            }
        }
        if ((expression = sym.getExpressionSym()) == null) {
            return null;
        }
        if (CompilerLayer4.isVoidType(expression.getResolvedType())) {
            this.error(expression, (short)130);
        }
        return null;
    }

    public final JavaElement compile(SwitchStmt statement) {
        assert (!this.skipCompilations());
        this.compileSwitchElement(statement);
        return null;
    }

    protected final void compileSwitchElement(SourceSwitchElement switchElement) {
        if (this.skipCompilations()) {
            return;
        }
        Expr selectorExpression = (Expr)switchElement.getSelectorExpression();
        if (selectorExpression == null) {
            return;
        }
        JavaType selectorType = selectorExpression.getResolvedType();
        if (selectorType == null) {
            return;
        }
        if (!this.isValidSwitchSelectorType(selectorType)) {
            this.error(selectorExpression, (short)136, selectorType);
            return;
        }
        List<SourceSwitchLabel> switchLabels = switchElement.getSwitchLabels();
        if (switchLabels.isEmpty()) {
            if (switchElement.isExpression()) {
                this.error((Sym)((Object)switchElement), (short)134);
            }
            return;
        }
        HashSet<Object> caseValues = new HashSet<Object>();
        SourceSwitchLabel defaultLabel = null;
        for (SourceSwitchLabel label : switchLabels) {
            if (label.isDefault()) {
                if (defaultLabel == null) {
                    defaultLabel = label;
                    continue;
                }
                this.error((Sym)((Object)label), (short)135);
                continue;
            }
            List<SourceExpression> expressions = label.getExpressions();
            if (!this.jdkVersion.isGreaterThanOrEqualTo14() && expressions.size() > 1) {
                this.error((Sym)((Object)label), (short)132, expressions);
            }
            for (SourceExpression expression : expressions) {
                Object value = expression.getConstantValue();
                if (value == null) {
                    this.error((Sym)((Object)expression), (short)113);
                    continue;
                }
                if (!caseValues.add(value)) {
                    this.error((Sym)((Object)expression), (short)52, value.toString());
                    continue;
                }
                JavaType valueType = expression.getResolvedType();
                PrimitiveType unboxedType = PrimitiveType.applyUnboxingConversion(valueType, this.jdkVersion);
                if (unboxedType != null) {
                    valueType = unboxedType;
                }
                if (Conversions.applyAssignmentConversion(valueType, expression, selectorType, true, this.provider, this.jdkVersion)) continue;
                this.error((Sym)((Object)expression), (short)115, selectorType, valueType);
            }
        }
        if (switchElement.isStatement()) {
            return;
        }
        if (defaultLabel == null) {
            if (selectorType.isEnum()) {
                ArrayList<JavaField> missing = new ArrayList<JavaField>();
                for (JavaField field : selectorType.getDeclaredFields()) {
                    if (!field.isEnumConstant() || caseValues.contains(field)) continue;
                    missing.add(field);
                }
                if (!missing.isEmpty()) {
                    this.error((Sym)((Object)switchElement), (short)131, missing);
                }
            } else {
                this.error((Sym)((Object)switchElement), (short)131);
            }
        }
    }

    private boolean isValidSwitchSelectorType(JavaType type) {
        PrimitiveType unboxed = PrimitiveType.applyUnboxingConversion(type, this.jdkVersion);
        if (unboxed != null) {
            type = unboxed;
        }
        if (type.isPrimitive()) {
            return switch (((PrimitiveType)type).primCode) {
                case 1, 2, 3, 4 -> true;
                default -> false;
            };
        }
        if (type.isEnum()) {
            return true;
        }
        return this.jdkVersion.isGreaterThanOrEqualTo7() && type.equals(this.getPreloadedClass((byte)6));
    }

    public final JavaElement compile(SynchStmt sym) {
        assert (!this.skipCompilations());
        Expr e = sym.getExpressionSym();
        if (e == null) {
            return null;
        }
        JavaHasType lhs = this.processExpression(e);
        if (lhs == null) {
            return null;
        }
        if (lhs instanceof JavaType) {
            this.error(e, (short)71, lhs);
        }
        return null;
    }

    public final JavaElement compile(ThrowStmt sym) {
        assert (!this.skipCompilations());
        Expr e = sym.getExpressionSym();
        if (e == null) {
            return null;
        }
        if (this.jdkVersion.isGreaterThanOrEqualTo7() && e.getCompiledObject() instanceof SourceCatchParameter) {
            return null;
        }
        JavaType type = e.getResolvedType();
        if (type == null) {
            return null;
        }
        this.checkException(sym, type);
        return null;
    }

    public final JavaElement compile(AssertStmt sym) {
        assert (!this.skipCompilations());
        this.checkExpressionIsBoolean(sym.getExpressionSym());
        Expr e = (Expr)sym.getNthChild((byte)108, 1);
        if (e != null) {
            JavaType type = e.getResolvedType();
            if (PrimitiveType.getVoidType().equals(type)) {
                this.error(e, (short)74, type);
            }
        }
        return sym;
    }

    public final JavaElement compile(IfStmt sym) {
        assert (!this.skipCompilations());
        this.checkExpressionIsBoolean(sym.getExpressionSym());
        return sym;
    }

    public final JavaElement compile(WhileStmt sym) {
        assert (!this.skipCompilations());
        this.checkExpressionIsBoolean(sym.getExpressionSym());
        return sym;
    }

    public final JavaElement compile(DoStmt sym) {
        assert (!this.skipCompilations());
        this.checkExpressionIsBoolean(sym.getExpressionSym());
        return sym;
    }

    private void checkExpressionIsBoolean(Expr e) {
        if (e == null) {
            return;
        }
        JavaType type = e.getResolvedType();
        if (type == null) {
            return;
        }
        if (CompilerUtilities.isBooleanType(type)) {
            return;
        }
        this.error(e, (short)115, PrimitiveType.getPrimitiveType(0), type);
    }

    private void processComponents(JavaType annotateType, AnnotateSym sym, ListExpr args) {
        Expr e;
        if (args == null) {
            return;
        }
        int count = args.getOperandCount();
        if (count == 0) {
            return;
        }
        HashSet<JavaMethod> nonDefaultMethods = new HashSet<JavaMethod>();
        Collection<JavaMethod> methods = annotateType.getDeclaredMethods();
        for (JavaMethod method : methods) {
            if (method.getDefaultValue() != null) continue;
            nonDefaultMethods.add(method);
        }
        if (count == 1 && (e = args.getNthOperandSym(0)) != null && e.exprOptcode != 6) {
            this.processSingleValueNoName(annotateType, sym, e, nonDefaultMethods);
            return;
        }
        for (int i = 0; i < count; ++i) {
            Expr arg = args.getNthOperandSym(i);
            this.processNormalComponent(sym, arg, nonDefaultMethods);
        }
        for (JavaMethod nonDefaultMethod : nonDefaultMethods) {
            this.error(sym, (short)108, nonDefaultMethod);
        }
    }

    private void processSingleValueNoName(JavaType annotateType, AnnotateSym sym, Expr arg, Set<JavaMethod> nonDefaultMethods) {
        JavaMethod valueM = annotateType.getDeclaredMethod("value", JavaType.EMPTY_ARRAY);
        if (valueM == null) {
            this.error(arg, (short)59, "value", annotateType, annotateType.getQualifiedName());
            if (!nonDefaultMethods.isEmpty()) {
                this.error(arg, (short)109);
            }
            return;
        }
        for (JavaMethod method : annotateType.getDeclaredMethods()) {
            String name = method.getName();
            if ("value".equals(name) || method.getDefaultValue() != null) continue;
            this.error(sym, (short)108, method);
            return;
        }
        JavaType expected = valueM.getResolvedType();
        Object value = this.processComponentValue(expected, arg);
        if (value != null) {
            sym.getComponents().assignValue("value", value, arg.getConstantValue());
        }
    }

    private void processNormalComponent(AnnotateSym sym, Expr arg, Set<JavaMethod> nonDefaultMethods) {
        JavaType expected;
        Object value;
        byte optCode = arg.exprOptcode;
        if (optCode != 6) {
            if (optCode != 53) {
                this.error(arg, (short)109);
            }
            return;
        }
        Expr lhs = arg.getNthOperandSym(0);
        JavaHasType result = lhs.getResolvedObject();
        if (result == null || result.getElementKind() != 4) {
            String text = lhs.getName();
            if (text == null || text.isEmpty()) {
                text = lhs.getText();
            }
            this.error(lhs, (short)111, text);
            return;
        }
        Expr rhs = arg.getNthOperandSym(1);
        QuickComponent qc = (QuickComponent)result;
        JavaMethod method = qc.getMethod();
        if (method != null) {
            nonDefaultMethods.remove(method);
        }
        if ((value = this.processComponentValue(expected = qc.getResolvedType(), rhs)) != null) {
            sym.getComponents().assignValue(qc.getName(), value, rhs.getConstantValue());
        }
    }

    private Object processComponentValue(JavaType expected, Expr arg) {
        Object value = arg.getConstantValue();
        if (value == null) {
            this.error(arg, (short)113);
            return null;
        }
        JavaType argType = arg.getResolvedType();
        if (argType == null) {
            return null;
        }
        if (expected == null) {
            return value;
        }
        if (expected.isArray() && argType.isArray() && expected.getArrayDimensions() == 1 && argType.getArrayDimensions() == 1 && value instanceof Object[]) {
            Object[] valueArray = (Object[])value;
            Object[] castedArray = new Object[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                Object oneValue = valueArray[i];
                JavaType baseExpected = expected.getComponentType();
                Object casted = ConstantExpressionEvaluator.cast(oneValue, baseExpected);
                castedArray[i] = casted != null ? casted : oneValue;
            }
            return castedArray;
        }
        if (expected.getArrayDimensions() == 1 && argType.getArrayDimensions() == 0) {
            JavaType baseExpected = expected.getComponentType();
            if (baseExpected == null || Conversions.applyAssignmentConversion(argType, arg, baseExpected, true, this.provider, this.jdkVersion)) {
                Object casted = ConstantExpressionEvaluator.cast(value, baseExpected);
                return new Object[]{casted != null ? casted : value};
            }
        } else if (Conversions.applyAssignmentConversion(argType, arg, expected, true, this.provider, this.jdkVersion)) {
            Object casted = ConstantExpressionEvaluator.cast(value, expected);
            return casted != null ? casted : value;
        }
        this.error(arg, (short)43, argType, expected);
        return null;
    }

    private JavaVariable lookupExclusiveLocal(VariableSym cookie, String name) {
        CompilerContext context = this.getCompilerContext();
        if (context == null) {
            return null;
        }
        Sym scope = context.cleanAndInitializeScope();
        if (scope == null) {
            return null;
        }
        while (scope != null && scope.symKind != 3) {
            if (scope.symKind != 18) {
                JavaVariable foundVariable = context.findVariable(scope, name, true);
                boolean noError = false;
                if (foundVariable != null && foundVariable != cookie) {
                    SourceForStatement forStmt;
                    SourceLocalVariableDeclaration decl;
                    SourceElement declParent;
                    JavaElement variableOwner;
                    if (cookie.getSymbolKind() == 31 && (variableOwner = foundVariable.getOwner()) instanceof SourceLocalVariableDeclaration && (declParent = (decl = (SourceLocalVariableDeclaration)((Object)variableOwner)).getParent()) != null && declParent.getSymbolKind() == 57 && (forStmt = (SourceForStatement)declParent).getForType() == 2) {
                        SourceExpression forStmtCollection = forStmt.getForCollection();
                        for (SourceElement lambdaParam = cookie; lambdaParam != null; lambdaParam = lambdaParam.getParent()) {
                            if (lambdaParam != forStmtCollection) continue;
                            noError = true;
                            break;
                        }
                    }
                    if (!noError) {
                        return foundVariable;
                    }
                }
            }
            scope = context.nextScope();
        }
        return null;
    }

    protected final void processDuplicates(Collection variables) {
        HashMap<String, VariableSym> locals = null;
        for (Object variable : variables) {
            VariableSym found;
            VariableSym thing = (VariableSym)variable;
            String name = thing.getName();
            if (locals == null) {
                locals = new HashMap<String, VariableSym>();
            }
            if ((found = (VariableSym)locals.get(name)) != null) {
                Sym cookie = thing;
                NameSym nameSym = thing.getNameSym();
                if (nameSym != null) {
                    cookie = nameSym;
                }
                this.error(cookie, (short)52, name, found);
            }
            locals.put(name, thing);
        }
    }

    protected final void processBlockDuplicates(BlockSym block) {
        Collection<SourceLocalVariable> variables = block.getLocalVariables();
        if (variables == null || variables.isEmpty()) {
            return;
        }
        HashMap<String, LocalVariableSym> locals = new HashMap<String, LocalVariableSym>();
        for (SourceLocalVariable variable : variables) {
            VariableSym predecessor;
            String name;
            LocalVariableSym v;
            block7: {
                block6: {
                    Sym sym;
                    v = (LocalVariableSym)variable;
                    name = v.getName();
                    predecessor = (VariableSym)locals.get(name);
                    if (v.symKind == 87) break block6;
                    if (v.symParent == null || !((sym = v.symParent.symParent) instanceof ForStmt)) break block7;
                    ForStmt forStmt = (ForStmt)sym;
                }
                if (predecessor == null) continue;
            }
            if (predecessor != null) {
                NameSym nameSym = v.getNameSym();
                this.error(nameSym != null ? nameSym : v, (short)52, name, predecessor);
                continue;
            }
            locals.put(name, v);
        }
    }

    protected final void processMethodDuplicates(Collection methods) {
        HashMap<String, List> previousMethodList = new HashMap<String, List>(methods.size());
        for (Object o : methods) {
            MethodSym method = (MethodSym)o;
            String methodName = method.getName();
            List previousMethods = previousMethodList.computeIfAbsent(methodName, k -> new ArrayList());
            previousMethods.add(method);
        }
        HashMap<String, MethodSym> methodSignatureList = new HashMap<String, MethodSym>();
        for (List previousMethods : previousMethodList.values()) {
            if (previousMethods.size() <= 1) continue;
            for (MethodSym method : previousMethods) {
                String signature = CompilerLayer4.methodEquivalenceSignature(method);
                MethodSym previousMethod = (MethodSym)methodSignatureList.get(signature);
                if (previousMethod != null) {
                    JavaClass owner;
                    String errorName = method.isConstructor() ? ((owner = method.getOwningClass()) != null ? owner.getName() : method.getName()) : method.getName();
                    this.error(method, (short)52, errorName, previousMethod);
                    continue;
                }
                methodSignatureList.put(signature, method);
            }
            methodSignatureList.clear();
        }
        previousMethodList.clear();
    }

    private static String methodEquivalenceSignature(SourceMethod method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getName()).append('(');
        List<SourceVariable> parameters = method.getSourceParameters();
        int count = 0;
        for (int i = 0; i < parameters.size(); ++i) {
            JavaClass erasedType;
            JavaType paramType;
            SourceVariable parameter = parameters.get(i);
            if (i == 0 && method.getJdkVersion().isGreaterThanOrEqualTo8() && "this".equals(parameter.getName()) || (paramType = parameter.getResolvedType()) == null || (erasedType = paramType.getTypeErasure()) == null) continue;
            if (count++ > 0) {
                builder.append(", ");
            }
            builder.append(erasedType.getTypeSignature());
        }
        return builder.append(')').toString();
    }

    private void processConversion(JavaType lhsType, Expr e, Conversions.ConversionType conversionType) {
        Expr unwrappedExpr;
        if (e == null || lhsType == null) {
            return;
        }
        JavaType rhsType = e.getResolvedType();
        if (rhsType == null) {
            return;
        }
        for (unwrappedExpr = e; unwrappedExpr != null && unwrappedExpr.symKind == 81; unwrappedExpr = (Expr)unwrappedExpr.getNthChild((byte)108, 0)) {
        }
        if (unwrappedExpr != null) {
            lhsType = this.checkForLambdaLhs(unwrappedExpr, lhsType);
            switch (unwrappedExpr.symKind) {
                case 82: 
                case 83: {
                    if (!PrimitiveType.getVoidType().equals(lhsType)) break;
                    return;
                }
                case 76: {
                    SourceExpression o3;
                    SourceExpression o2 = unwrappedExpr.getSecondOperand();
                    if (o2 != null && o2.getSymbolKind() == 82 || (o3 = unwrappedExpr.getThirdOperand()) != null && o3.getSymbolKind() == 82) break;
                }
                default: {
                    JavaHasType hasType = e.getResolvedObject();
                    if (!(hasType instanceof JavaType)) break;
                    this.error(e, (short)74, hasType);
                    return;
                }
            }
        }
        Object constantRhsValue = e.getConstantValue();
        if (rhsType.isPrimitive() && ((PrimitiveType)rhsType).isIntegral() && constantRhsValue instanceof Number) {
            int value = ((Number)constantRhsValue).intValue();
            PrimitiveType primitiveLhs = this.getPrimitiveType(lhsType);
            if (primitiveLhs != null) {
                boolean constantValueError = false;
                boolean handled = false;
                switch (primitiveLhs.primCode) {
                    case 1: {
                        constantValueError = value > 127 || value < -128;
                        handled = true;
                        break;
                    }
                    case 2: {
                        constantValueError = value > 65535 || value < 0;
                        handled = true;
                        break;
                    }
                    case 3: {
                        constantValueError = value > Short.MAX_VALUE || value < Short.MIN_VALUE;
                        handled = true;
                    }
                }
                if (constantValueError) {
                    this.error(e, (short)43, rhsType, lhsType);
                    return;
                }
                if (handled) {
                    return;
                }
            }
        }
        if (conversionType == Conversions.ConversionType.ASSIGNMENT) {
            if (CompilerLayer4.applyAssignmentConversion(rhsType, e, lhsType, constantRhsValue != null, this.provider, this.jdkVersion)) {
                return;
            }
        } else {
            assert (conversionType == Conversions.ConversionType.METHOD);
            if (CompilerLayer4.applyMethodConversion(rhsType, lhsType, true, this.provider, this.jdkVersion)) {
                return;
            }
        }
        if (this.allowDiamondSyntaxAssign(e, rhsType, lhsType)) {
            return;
        }
        if (this.allowAssignAfterInferringWithTargetType(conversionType, e, rhsType, lhsType)) {
            return;
        }
        this.error(e, (short)43, rhsType, lhsType);
    }

    private PrimitiveType getPrimitiveType(JavaType type) {
        if (!type.isPrimitive()) {
            return PrimitiveType.applyUnboxingConversion(type, this.jdkVersion);
        }
        return (PrimitiveType)type;
    }

    private void processExpressionStatements(ListExpr list) {
        if (list == null) {
            return;
        }
        for (SourceExpression sourceExpression : list.getOperands()) {
            this.processExpressionStatement((Expr)sourceExpression);
        }
    }

    private void processExpressionStatement(Expr e) {
        if (e == null) {
            return;
        }
        switch (e.symKind) {
            case 68: 
            case 73: 
            case 75: {
                return;
            }
            case 80: {
                switch (e.exprOptcode) {
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        return;
                    }
                }
            }
        }
        this.error(e, (short)55);
    }
}

