/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.Parameterization;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.WrapperClass;
import oracle.javatools.parser.java.v2.common.WrapperField;
import oracle.javatools.parser.java.v2.common.WrapperLocalVariable;
import oracle.javatools.parser.java.v2.common.WrapperMethod;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

public final class ParameterizedClass
extends WrapperClass {
    private JavaType qualifyingType;
    Parameterization params;
    private JavaType boundSuperclass;
    private Collection<JavaType> boundInterfaces;
    private Collection<JavaField> fields;
    private Collection<JavaMethod> methods;
    private Collection<JavaMethod> constructors;
    private Collection<JavaClass> classes;

    ParameterizedClass(JavaProvider provider, JavaClass baseType, JavaType[] arguments) {
        super(baseType);
        this.params = new Parameterization(provider, baseType, arguments);
    }

    @Override
    public JavaClass getOwningClass() {
        return super.getOwningClass();
    }

    @Override
    public boolean hasActualTypeArguments() {
        return true;
    }

    @Override
    public Collection<JavaType> getActualTypeArguments() {
        return this.params.boundArguments.length == 0 ? Collections.emptyList() : Arrays.asList(this.params.boundArguments);
    }

    @Override
    public JavaClass getTypeErasure() {
        return super.getTypeErasure();
    }

    private String getNameImpl(boolean qualified) {
        Object prefix;
        JavaClass owningClass = this.getOwningClass();
        if (owningClass == null) {
            prefix = qualified ? this.delegate.getQualifiedName() : this.delegate.getUnqualifiedName();
        } else {
            Object object = prefix = qualified ? owningClass.getQualifiedName() + "." + this.getName() : owningClass.getUnqualifiedName() + "." + this.getName();
        }
        if (((String)prefix).length() == 0) {
            return "";
        }
        int count = this.params.boundArguments.length;
        if (count == 0) {
            return prefix;
        }
        StringBuilder builder = new StringBuilder((String)prefix);
        builder.append('<');
        int comma = 0;
        for (int i = 0; i < count; ++i) {
            JavaType arg;
            if (comma++ > 0) {
                builder.append(", ");
            }
            if ((arg = this.params.boundArguments[i]) != null) {
                builder.append(qualified ? arg.getQualifiedName() : arg.getUnqualifiedName());
                continue;
            }
            builder.append('?');
        }
        builder.append('>');
        return builder.toString();
    }

    @Override
    public String getUnqualifiedName() {
        return this.getNameImpl(false);
    }

    @Override
    public String getQualifiedName() {
        return this.getNameImpl(true);
    }

    @Override
    public String getDescriptor() {
        JavaClass erasure = this.getTypeErasure();
        return erasure != null ? erasure.getDescriptor() : super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaType getSuperclass() {
        if (this.boundSuperclass == null) {
            ParameterizedClass parameterizedClass = this;
            synchronized (parameterizedClass) {
                if (this.boundSuperclass == null) {
                    JavaType superclass = super.getSuperclass();
                    if (superclass == null) {
                        return null;
                    }
                    this.boundSuperclass = this.params.bindNoWildcard(superclass);
                }
            }
        }
        return this.boundSuperclass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JavaType> getInterfaces() {
        if (this.boundInterfaces == null) {
            ParameterizedClass parameterizedClass = this;
            synchronized (parameterizedClass) {
                if (this.boundInterfaces == null) {
                    this.boundInterfaces = this.params.bind(super.getInterfaces());
                }
            }
        }
        return this.boundInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JavaField> getDeclaredFields() {
        if (this.fields != null) {
            return this.fields;
        }
        ParameterizedClass parameterizedClass = this;
        synchronized (parameterizedClass) {
            if (this.fields == null) {
                Collection<JavaField> declared = super.getDeclaredFields();
                this.fields = new ArrayList<JavaField>(declared.size());
                for (JavaField field : declared) {
                    this.fields.add(field.isStatic() ? field : new BoundMemberField(this, field));
                }
            }
        }
        return this.fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        ParameterizedClass parameterizedClass = this;
        synchronized (parameterizedClass) {
            if (this.methods == null) {
                Collection<JavaMethod> declared = super.getDeclaredMethods();
                this.methods = new ArrayList<JavaMethod>(declared.size());
                for (JavaMethod method : declared) {
                    this.methods.add(method.isStatic() ? method : new BoundMemberMethod(this, method));
                }
            }
        }
        return this.methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JavaMethod> getDeclaredConstructors() {
        if (this.constructors != null) {
            return this.constructors;
        }
        ParameterizedClass parameterizedClass = this;
        synchronized (parameterizedClass) {
            if (this.constructors == null) {
                Collection<JavaMethod> declared = super.getDeclaredConstructors();
                this.constructors = new ArrayList<JavaMethod>(declared.size());
                for (JavaMethod constructor : declared) {
                    this.constructors.add(constructor.isStatic() ? constructor : new BoundMemberMethod(this, constructor));
                }
            }
        }
        return this.constructors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JavaClass> getDeclaredClasses() {
        if (this.classes != null) {
            return this.classes;
        }
        ParameterizedClass parameterizedClass = this;
        synchronized (parameterizedClass) {
            if (this.classes == null) {
                Collection<JavaClass> declared = super.getDeclaredClasses();
                this.classes = new ArrayList<JavaClass>();
                for (JavaClass type : declared) {
                    this.classes.add(type.isStatic() ? type : new BoundMemberClass(type));
                }
            }
        }
        return this.classes;
    }

    public JavaType eraseUnresolvedMethodTypeArguments(JavaMethod typeParameterOwner) {
        Collection<JavaTypeVariable> typeParameters = typeParameterOwner.getTypeParameters();
        if (typeParameters == null || typeParameters.isEmpty()) {
            return this;
        }
        JavaType[] boundArguments = this.params.boundArguments;
        JavaType[] newBoundArguments = new JavaType[boundArguments.length];
        boolean changed = false;
        block0: for (int i = 0; i < boundArguments.length; ++i) {
            if (boundArguments[i] != null && boundArguments[i].getElementKind() == 10) {
                for (JavaTypeVariable typeParameter : typeParameters) {
                    if (!typeParameter.equals(boundArguments[i])) continue;
                    newBoundArguments[i] = boundArguments[i].getTypeErasure();
                    changed = true;
                    continue block0;
                }
            }
            newBoundArguments[i] = boundArguments[i];
        }
        if (changed) {
            return new ParameterizedClass(this.params.provider, (JavaClass)this.params.baseObject, newBoundArguments);
        }
        return this;
    }

    @Override
    public JavaType getQualifyingType() {
        if (this.qualifyingType != null) {
            return this.qualifyingType;
        }
        return this.delegate.getQualifyingType();
    }

    @Override
    public void setQualifyingType(JavaType qualifyingType) {
        this.qualifyingType = qualifyingType;
    }

    private class BoundMemberField
    extends WrapperField {
        private JavaType type;
        private final JavaClass owningClass;

        private BoundMemberField(JavaClass owningClass, JavaField field) {
            super(field);
            this.type = null;
            this.owningClass = owningClass;
        }

        @Override
        public JavaType getResolvedType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bindNoWildcard(this.thing.getResolvedType());
            }
            return this.type;
        }

        @Override
        public JavaClass getOwningClass() {
            return this.owningClass;
        }

        @Override
        public JavaElement getOwner() {
            return this.owningClass;
        }
    }

    private class BoundMemberMethod
    extends WrapperMethod {
        private JavaType type;
        private Collection<JavaVariable> parameters;
        private Collection<JavaType> exceptions;
        private JavaClass owningClass;

        private BoundMemberMethod(JavaClass owningClass, JavaMethod method) {
            super(method);
            this.owningClass = owningClass;
        }

        @Override
        public JavaType getReturnType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bindNoWildcard(this.method.getResolvedType());
                if (this.type == null) {
                    this.type = PrimitiveType.getVoidType();
                }
            }
            return this.type;
        }

        @Override
        public JavaType getResolvedType() {
            return this.getReturnType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<JavaVariable> getParameters() {
            if (this.parameters != null) {
                return this.parameters;
            }
            BoundMemberMethod boundMemberMethod = this;
            synchronized (boundMemberMethod) {
                if (this.parameters == null) {
                    Collection<JavaVariable> declared = this.method.getParameters();
                    this.parameters = new ArrayList<JavaVariable>(declared.size());
                    for (JavaVariable parameter : declared) {
                        this.parameters.add(new BoundParameter((JavaLocalVariable)parameter));
                    }
                }
            }
            return this.parameters;
        }

        @Override
        public Collection<JavaType> getExceptions() {
            if (this.exceptions == null) {
                this.exceptions = ParameterizedClass.this.params.bind(this.method.getExceptions());
            }
            return this.exceptions;
        }

        @Override
        public JavaClass getOwningClass() {
            return this.owningClass;
        }

        @Override
        public JavaElement getOwner() {
            return this.owningClass;
        }

        @Override
        public String getDescriptor() {
            return this.method.getDescriptor();
        }

        @Override
        public String getTypeSignature() {
            return this.method.getTypeSignature();
        }

        private class BoundParameter
        extends WrapperLocalVariable {
            private JavaType type;

            private BoundParameter(JavaLocalVariable thing) {
                super(thing);
                this.type = null;
            }

            @Override
            public JavaType getResolvedType() {
                if (this.type == null) {
                    this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
                }
                return this.type;
            }

            @Override
            public UnresolvedType getUnresolvedType() {
                return this.thing.getUnresolvedType();
            }

            @Override
            public JavaElement getOwner() {
                return BoundMemberMethod.this;
            }

            @Override
            public JavaLocalVariable getLocalVariableErasure() {
                return this.thing;
            }
        }
    }

    private class BoundMemberClass
    extends WrapperClass {
        private JavaType type;
        private JavaType qualifyingType;

        private BoundMemberClass(JavaClass type) {
            super(type);
        }

        @Override
        public JavaClass getOwningClass() {
            return ParameterizedClass.this;
        }

        @Override
        public JavaType getResolvedType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bindNoWildcard(this.delegate.getResolvedType());
            }
            return this.type;
        }

        @Override
        public String getQualifiedName() {
            StringBuilder builder = new StringBuilder();
            String owningClassQualfiedName = ParameterizedClass.this.getQualifiedName();
            if (owningClassQualfiedName != null && owningClassQualfiedName.length() > 0) {
                builder.append(owningClassQualfiedName);
                builder.append('.');
            }
            builder.append(this.getName());
            return builder.toString();
        }

        @Override
        public Collection<JavaMethod> getDeclaredMethods() {
            return this.handleDeclaredMethods(super.getDeclaredMethods());
        }

        @Override
        public Collection<JavaMethod> getDeclaredConstructors() {
            return this.handleDeclaredMethods(super.getDeclaredConstructors());
        }

        private Collection<JavaMethod> handleDeclaredMethods(Collection<JavaMethod> methods) {
            if (methods.size() == 0) {
                return methods;
            }
            ArrayList<JavaMethod> boundMethods = new ArrayList<JavaMethod>(methods.size());
            for (JavaMethod method : methods) {
                boundMethods.add(method.isStatic() ? method : new BoundMemberMethod(this, method));
            }
            return boundMethods;
        }

        @Override
        public Collection<JavaField> getDeclaredFields() {
            Collection<JavaField> fields = super.getDeclaredFields();
            if (fields.size() == 0) {
                return fields;
            }
            ArrayList<JavaField> boundFields = new ArrayList<JavaField>(fields.size());
            for (JavaField field : fields) {
                boundFields.add(field.isStatic() ? field : new BoundMemberField(this, field));
            }
            return boundFields;
        }

        @Override
        public JavaType getQualifyingType() {
            if (this.qualifyingType != null) {
                return this.qualifyingType;
            }
            return this.getOwningClass();
        }

        @Override
        public void setQualifyingType(JavaType qualifyingType) {
            this.qualifyingType = qualifyingType;
        }
    }
}

