/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.ClassHierarchy;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.common.Value;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaRecordComponent;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.util.Conversions;

public abstract class AbstractType
extends AbstractElement
implements JavaType {
    private WeakReference<ClassHierarchy> hierarchyRef;
    private WeakReference<Value> thisValueRef;

    @Override
    public abstract int getElementKind();

    @Override
    public abstract String getName();

    @Override
    public abstract String getQualifiedName();

    @Override
    public abstract String getVMName();

    @Override
    public abstract String getDescriptor();

    @Override
    public abstract String getUniqueIdentifier();

    @Override
    public abstract JavaClass getTypeErasure();

    @Override
    public JavaType getResolvedType() {
        return this;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.createUnresolvedType(this);
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public JavaElement getOwner() {
        return null;
    }

    @Override
    public JavaClass getOwningClass() {
        return null;
    }

    public JavaMethod getOwningMethod() {
        return null;
    }

    @Override
    public boolean isExported() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isMemberClass() {
        return false;
    }

    @Override
    public boolean isAnonymousClass() {
        return false;
    }

    @Override
    public boolean isLocalClass() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public JavaType getComponentType() {
        return null;
    }

    @Override
    public int getArrayDimensions() {
        return 0;
    }

    @Override
    public JavaType getBaseComponentType() {
        return null;
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return CommonUtilities.getTypeParameter(this, name);
    }

    @Override
    public String getUnqualifiedName() {
        return this.getName();
    }

    @Override
    public String getRawName() {
        JavaClass erasure = this.getTypeErasure();
        return erasure != null ? erasure.getQualifiedName() : this.getQualifiedName();
    }

    public String getSourceName() {
        return this.getRawName();
    }

    @Override
    public String getSignature() {
        return this.getDescriptor();
    }

    @Override
    public String printCompiledInfo() {
        return this.getUniqueIdentifier();
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    @Deprecated
    public JavaClass getClosestClass() {
        return this.getTypeErasure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompiledTmpVariable getThisValue() {
        AbstractType abstractType = this;
        synchronized (abstractType) {
            Value o;
            if (this.thisValueRef != null && (o = (Value)this.thisValueRef.get()) != null) {
                return o;
            }
            Value value = Value.createValue(this);
            this.thisValueRef = new WeakReference<Value>(value);
            return value;
        }
    }

    @Override
    public JavaPackage getPackage() {
        return null;
    }

    @Override
    public String getPackageName() {
        return "";
    }

    @Override
    public JavaType getSuperclass() {
        return null;
    }

    @Override
    public UnresolvedType getUnresolvedSuperclass() {
        return null;
    }

    @Override
    public Collection<JavaType> getInterfaces() {
        return Collections.emptyList();
    }

    @Override
    public Collection<JavaType> getPermittedSubclasses() {
        return Collections.emptyList();
    }

    @Override
    public Collection<UnresolvedType> getUnresolvedInterfaces() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<JavaType> getHierarchy() {
        AbstractType abstractType = this;
        synchronized (abstractType) {
            ClassHierarchy o;
            if (this.hierarchyRef != null && (o = (ClassHierarchy)this.hierarchyRef.get()) != null) {
                return o;
            }
            ClassHierarchy hierarchy = new ClassHierarchy(this);
            this.hierarchyRef = new WeakReference<ClassHierarchy>(hierarchy);
            return hierarchy;
        }
    }

    @Override
    public boolean isAssignableFrom(JavaType subject) {
        return Conversions.applyAssignmentConversion(subject, this, false, null);
    }

    @Override
    public boolean isSubtypeOf(JavaType supertype) {
        return Conversions.isSubtypeOf(this, supertype);
    }

    @Override
    public Collection<JavaField> getDeclaredFields() {
        return Collections.emptyList();
    }

    @Override
    public JavaField getDeclaredField(String name) {
        return CommonUtilities.getDeclaredField(this, name);
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        return Collections.emptyList();
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods(String name) {
        return CommonUtilities.getDeclaredMethods(this, name);
    }

    @Override
    public Collection<JavaRecordComponent> getDeclaredRecordComponents() {
        return Collections.emptyList();
    }

    @Override
    public JavaRecordComponent getDeclaredRecordComponent(String name) {
        return CommonUtilities.getDeclaredRecordComponent(this, name);
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaType[] targetTypes) {
        return CommonUtilities.getDeclaredMethod(this, name, targetTypes);
    }

    @Override
    public Collection<JavaMethod> getDeclaredConstructors() {
        return Collections.emptyList();
    }

    @Override
    public JavaMethod getDeclaredConstructor(JavaType[] targetTypes) {
        return CommonUtilities.getDeclaredConstructor(this, targetTypes);
    }

    @Override
    public JavaMethod getClinitMethod() {
        return null;
    }

    @Override
    public Collection<JavaClass> getDeclaredClasses() {
        return Collections.emptyList();
    }

    @Override
    public JavaClass getDeclaredClass(String name) {
        return CommonUtilities.getDeclaredClass(this, name);
    }

    @Override
    public Collection<JavaClass> getDeclaredAnonymousClasses() {
        return Collections.emptyList();
    }

    @Override
    public Collection<JavaClass> getDeclaredLocalClasses() {
        return Collections.emptyList();
    }

    @Override
    public Collection<JavaField> getFields() {
        return CommonUtilities.getFields(this);
    }

    @Override
    public JavaField getField(String name) {
        return CommonUtilities.getField(this, name);
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        return CommonUtilities.getMethods(this);
    }

    @Override
    public Collection<JavaMethod> getMethods(String name) {
        return CommonUtilities.getMethods(this, name);
    }

    @Override
    public JavaMethod getMethod(String name, JavaType ... targetTypes) {
        return CommonUtilities.getMethod(this, name, targetTypes);
    }

    @Override
    public Collection<JavaClass> getClasses() {
        return CommonUtilities.getClasses(this);
    }

    @Override
    public JavaClass getClass(String name) {
        return CommonUtilities.getClass(this, name);
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        return CommonUtilities.getAnnotations(this);
    }

    @Override
    public JavaAnnotation getAnnotation(JavaType annotationType) {
        return CommonUtilities.getAnnotation(this, annotationType);
    }

    public boolean equals(Object object) {
        JavaType type;
        return object instanceof JavaType && CommonUtilities.equals(this, type = (JavaType)object);
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    public String toString() {
        return this.getRawName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        AbstractType abstractType = this;
        synchronized (abstractType) {
            this.hierarchyRef = null;
        }
    }

    @Override
    public Collection<JavaAnnotation> getTypeAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean isErasedType() {
        return false;
    }
}

