/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.filesystem;

import java.io.IOException;
import java.net.URI;
import java.nio.Buffer;
import java.nio.file.Path;
import java.util.Map;
import oracle.javatools.filesystem.BufferFileSystem;
import oracle.javatools.filesystem.FileSystemProviderImpl;
import oracle.javatools.filesystem.PathImpl;

public abstract class BufferFileSystemProvider
extends FileSystemProviderImpl {
    private BufferFileSystem bufferFileSystem = new BufferFileSystem(this);

    public BufferFileSystemProvider(String scheme) {
        super(scheme);
    }

    public BufferFileSystem getFileSystem() {
        return this.bufferFileSystem;
    }

    protected Buffer getBuffer(PathImpl path) {
        return this.bufferFileSystem.getBuffer(path);
    }

    protected Buffer putBuffer(PathImpl path, Buffer buffer) throws IOException {
        if (path == null || path.isDirectory()) {
            throw new IllegalStateException("Path is not file path");
        }
        return this.bufferFileSystem.putBuffer(path, buffer);
    }

    @Override
    public BufferFileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        this.checkURI(uri);
        return this.bufferFileSystem;
    }

    @Override
    public BufferFileSystem newFileSystem(Path path, Map<String, ?> env) throws IOException {
        if (!(path instanceof PathImpl)) {
            throw new UnsupportedOperationException(path == null ? "<NULL>" : path.getClass().getName());
        }
        return this.bufferFileSystem;
    }

    @Override
    public BufferFileSystem getFileSystem(URI uri) {
        this.checkURI(uri);
        return this.bufferFileSystem;
    }
}

