/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util.jsonproc;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.spatial.util.jsonproc.JsonGenerator;

public class JsonNode
implements Iterable<JsonNode> {
    protected static JsonNode NULL = new JsonNode(JsonNodeType.NULL, new Object[0]);
    protected String json;
    private final JsonNodeType type;
    private Object value;
    protected Map<String, JsonNode> fields;
    private List<JsonNode> arrayValues;

    protected JsonNode(JsonNodeType jsonNodeType, Object ... objectArray) {
        this.type = jsonNodeType;
        switch (jsonNodeType) {
            case OBJECT: {
                this.fields = new LinkedHashMap<String, JsonNode>();
                break;
            }
            case STRING: 
            case BOOLEAN: 
            case NUMBER: {
                this.value = objectArray[0];
                break;
            }
            case NULL: {
                break;
            }
            case ARRAY: {
                this.arrayValues = new ArrayList<JsonNode>();
            }
        }
    }

    protected void addField(String string, JsonNode jsonNode) {
        this.fields.put(string, jsonNode);
    }

    protected void addArrayValue(JsonNode jsonNode) {
        this.arrayValues.add(jsonNode);
    }

    public JsonNodeType getNodeType() {
        return this.type;
    }

    public boolean has(String string) {
        return this.fields.containsKey(string);
    }

    public boolean isValueNode() {
        switch (this.type) {
            case STRING: 
            case BOOLEAN: 
            case NUMBER: 
            case NULL: {
                return true;
            }
        }
        return false;
    }

    public JsonNode get(String string) {
        return this.fields.get(string);
    }

    public Iterator<JsonNode> elements() {
        switch (this.type) {
            case OBJECT: {
                return this.fields.values().iterator();
            }
            case ARRAY: {
                return this.arrayValues.iterator();
            }
        }
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<JsonNode> iterator() {
        return this.elements();
    }

    public Iterator<Map.Entry<String, JsonNode>> fields() {
        if (this.fields == null) {
            return Collections.emptyIterator();
        }
        return this.fields.entrySet().iterator();
    }

    public String textValue() {
        if (this.type != JsonNodeType.STRING) {
            return null;
        }
        return (String)this.value;
    }

    public Iterator<String> fieldNames() {
        return this.fields.keySet().iterator();
    }

    public JsonNode get(int n) {
        if (this.type != JsonNodeType.ARRAY) {
            return null;
        }
        return this.arrayValues.get(n);
    }

    public JsonNode findValue(String string) {
        JsonNode jsonNode = null;
        jsonNode = this.fields.get(string);
        while (jsonNode != null) {
            for (JsonNode jsonNode2 : jsonNode) {
                jsonNode = jsonNode2.findValue(string);
            }
        }
        return jsonNode;
    }

    public boolean isNumber() {
        return this.type == JsonNodeType.NUMBER;
    }

    public long asLong() {
        switch (this.type) {
            case BOOLEAN: {
                if ((Boolean)this.value == Boolean.TRUE) {
                    return 1L;
                }
                return 0L;
            }
            case STRING: 
            case NUMBER: {
                return Long.parseLong((String)this.value);
            }
        }
        return 0L;
    }

    public double asDouble() {
        switch (this.type) {
            case BOOLEAN: {
                if ((Boolean)this.value == Boolean.TRUE) {
                    return 1.0;
                }
                return 0.0;
            }
            case STRING: 
            case NUMBER: {
                return Double.parseDouble((String)this.value);
            }
        }
        return 0.0;
    }

    public boolean asBoolean() {
        switch (this.type) {
            case BOOLEAN: {
                return (Boolean)this.value;
            }
            case NUMBER: {
                return Double.parseDouble((String)this.value) != 0.0;
            }
            case STRING: {
                return "true".equals(this.value);
            }
        }
        return false;
    }

    public int asInt() {
        switch (this.type) {
            case BOOLEAN: {
                if ((Boolean)this.value == Boolean.TRUE) {
                    return 1;
                }
                return 0;
            }
            case STRING: 
            case NUMBER: {
                return Integer.parseInt((String)this.value);
            }
        }
        return 0;
    }

    public int asInt(int n) {
        switch (this.type) {
            case BOOLEAN: {
                if ((Boolean)this.value == Boolean.TRUE) {
                    return 1;
                }
                return 0;
            }
            case STRING: 
            case NUMBER: {
                return Integer.parseInt((String)this.value);
            }
        }
        return n;
    }

    public String asText() {
        switch (this.type) {
            case STRING: 
            case BOOLEAN: 
            case NUMBER: {
                return this.value.toString();
            }
        }
        return "";
    }

    public boolean isNull() {
        return this.type == JsonNodeType.NULL;
    }

    public boolean isArray() {
        return this.type == JsonNodeType.ARRAY;
    }

    public boolean isTextual() {
        return this.type == JsonNodeType.STRING;
    }

    public boolean isIntegralNumber() {
        return !this.isFloatingPointNumber();
    }

    public boolean isFloatingPointNumber() {
        return ((String)this.value).contains(".") || ((String)this.value).contains("E");
    }

    public boolean isInt() {
        if (this.type != JsonNodeType.NUMBER) {
            return false;
        }
        try {
            return String.valueOf(Integer.parseInt((String)this.value)).equals(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean isObject() {
        return this.type == JsonNodeType.OBJECT;
    }

    public boolean isDouble() {
        if (this.type != JsonNodeType.NUMBER) {
            return false;
        }
        try {
            return String.valueOf(Double.parseDouble((String)this.value)).equals(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public int size() {
        switch (this.type) {
            case OBJECT: {
                return this.fields.size();
            }
            case ARRAY: {
                return this.arrayValues.size();
            }
        }
        return 0;
    }

    private void getJsonString(JsonGenerator jsonGenerator) throws IOException {
        switch (this.type) {
            case OBJECT: {
                jsonGenerator.writeStartObject();
                Iterator<Map.Entry<String, JsonNode>> iterator = this.fields();
                while (iterator.hasNext()) {
                    Map.Entry<String, JsonNode> entry = iterator.next();
                    jsonGenerator.writeFieldName(entry.getKey());
                    entry.getValue().getJsonString(jsonGenerator);
                }
                jsonGenerator.writeEndObject();
                break;
            }
            case ARRAY: {
                jsonGenerator.writeStartArray();
                for (JsonNode jsonNode : this.arrayValues) {
                    jsonNode.getJsonString(jsonGenerator);
                }
                jsonGenerator.writeEndArray();
                break;
            }
            case STRING: {
                jsonGenerator.writeString((String)this.value);
                break;
            }
            case BOOLEAN: {
                jsonGenerator.writeBoolean((Boolean)this.value);
                break;
            }
            case NUMBER: {
                jsonGenerator.writeNumber((String)this.value);
                break;
            }
            case NULL: {
                jsonGenerator.writeNull();
            }
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try (JsonGenerator jsonGenerator = new JsonGenerator(stringWriter);){
            this.getJsonString(jsonGenerator);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
        return stringWriter.toString();
    }

    public static class ObjectNode
    extends JsonNode {
        protected ObjectNode() {
            super(JsonNodeType.OBJECT, new Object[0]);
        }

        public ObjectNode put(String string, String string2) {
            this.fields.put(string, new JsonNode(JsonNodeType.STRING, string2));
            return this;
        }
    }

    public static enum JsonNodeType {
        ARRAY,
        BINARY,
        BOOLEAN,
        MISSING,
        NULL,
        NUMBER,
        OBJECT,
        POJO,
        STRING;

    }

    public static class BooleanNode
    extends JsonNode {
        public static final BooleanNode TRUE = new BooleanNode(Boolean.TRUE);
        public static final JsonNode FALSE = new BooleanNode(Boolean.FALSE);

        private BooleanNode(Boolean bl) {
            super(JsonNodeType.BOOLEAN, bl);
        }
    }
}

