/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.certpath;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.cert.PKCS7;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;

public class X509CertPathImpl
extends CertPath {
    static final List certPathEncodings;
    private List certList;
    private PKCS7 pkcs7;

    public X509CertPathImpl(List list) throws CertificateException {
        super("X.509");
        this.certList = Collections.unmodifiableList(new ArrayList(list));
        for (Object obj : this.certList) {
            if (obj instanceof X509Certificate) continue;
            String className = obj.getClass().getName();
            throw new CertificateException("Object " + className + "in the list is not a X509Certificate");
        }
    }

    public X509CertPathImpl(InputStream inputstream) throws CertificateException {
        this(inputstream, "PkiPath");
    }

    public X509CertPathImpl(InputStream inputstream, String encoding) throws CertificateException {
        super("X.509");
        if (encoding.equals("PkiPath")) {
            this.certList = this.decodePkiPath(inputstream);
        } else if (encoding.equals("PKCS7")) {
            this.certList = this.decodePkcs7(inputstream);
        } else {
            throw new CertificateException("encoding " + encoding + " is not supported");
        }
    }

    private List decodePkiPath(InputStream in) throws CertificateException {
        ArrayList<Certificate> listRes = new ArrayList<Certificate>();
        try {
            ASN1Sequence seq = new ASN1Sequence(in);
            if (seq.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int i = 0; i < seq.size(); ++i) {
                ASN1Object asn1obj = seq.elementAt(i);
                UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
                asn1obj.output((OutputStream)bos);
                listRes.add(cf.generateCertificate((InputStream)new UnsyncByteArrayInputStream(bos.toByteArray())));
            }
            return Collections.unmodifiableList(listRes);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe);
        }
    }

    private List decodePkcs7(InputStream in) throws CertificateException {
        List list = null;
        if (in == null) {
            throw new CertificateException("input stream data is null");
        }
        try {
            this.pkcs7 = new PKCS7(in);
            Vector phaosCerts = this.pkcs7.getCertificates();
            list = phaosCerts == null ? Collections.EMPTY_LIST : this.convertToJDKCerts(phaosCerts);
            return Collections.unmodifiableList(list);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe);
        }
    }

    private List convertToJDKCerts(Vector pCerts) throws CertificateException {
        ArrayList<Certificate> res = new ArrayList<Certificate>(pCerts.size());
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < pCerts.size(); ++i) {
            X509 pCert = (X509)pCerts.elementAt(i);
            res.add(cf.generateCertificate((InputStream)new UnsyncByteArrayInputStream(pCert.getEncoded())));
        }
        return res;
    }

    private Vector convertToPhaosCerts(List jdkCerts) throws CertificateException {
        Vector<X509> res = new Vector<X509>(jdkCerts.size());
        for (int i = 0; i < jdkCerts.size(); ++i) {
            X509Certificate jdkCert = (X509Certificate)jdkCerts.get(i);
            try {
                res.add(new X509((InputStream)new UnsyncByteArrayInputStream(jdkCert.getEncoded())));
                continue;
            }
            catch (IOException ioe) {
                throw new CertificateException(ioe);
            }
        }
        return res;
    }

    private byte[] encodePkiPath() throws CertificateEncodingException {
        try {
            ASN1Sequence seq = new ASN1Sequence();
            for (int i = this.certList.size() - 1; i >= 0; --i) {
                X509Certificate x509cert = (X509Certificate)this.certList.get(i);
                ASN1Sequence s = new ASN1Sequence((InputStream)new ByteArrayInputStream(x509cert.getEncoded()));
                seq.addElement((ASN1Object)s);
            }
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            seq.output((OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new CertificateEncodingException(ioe);
        }
        catch (CertificateException ce) {
            throw new CertificateEncodingException(ce);
        }
    }

    private byte[] encodePkcs7() throws CertificateEncodingException {
        try {
            if (this.pkcs7 == null) {
                Vector phaosCerts = this.convertToPhaosCerts(this.certList);
                this.pkcs7 = new PKCS7(phaosCerts, null);
            }
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            this.pkcs7.output((OutputStream)bos);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new CertificateEncodingException(ioe);
        }
        catch (CertificateException ce) {
            throw new CertificateEncodingException(ce);
        }
    }

    public Iterator getEncodings() {
        return certPathEncodings.iterator();
    }

    public static Iterator getEncodingsStatic() {
        return certPathEncodings.iterator();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.encodePkiPath();
    }

    @Override
    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        if (encoding.equals("PkiPath")) {
            return this.encodePkiPath();
        }
        if (encoding.equals("PKCS7")) {
            return this.encodePkcs7();
        }
        throw new CertificateEncodingException("encoding " + encoding + " is not supported");
    }

    public List getCertificates() {
        return this.certList;
    }

    static {
        ArrayList<String> arraylist = new ArrayList<String>();
        arraylist.add("PkiPath");
        arraylist.add("PKCS7");
        certPathEncodings = Collections.unmodifiableList(arraylist);
    }
}

