/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipOutputHandler {
    ZipOutputStream _out;
    ZipEntry _entry;
    FileOutputStream _fout;
    ZipOutputStream _zout;
    OutputStreamWriter _stringWriter;
    String _encoding;
    String _fileName;
    boolean _entryOpened = false;
    private ArrayList<String> _createdEntries;

    public void openZip(String zipfile) throws FileNotFoundException {
        this._out = new ZipOutputStream(new FileOutputStream(zipfile));
        this._createdEntries = new ArrayList();
    }

    public void closeZip() throws IOException {
        this._out.close();
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void openEntry(String fileName) throws IOException {
        this._fileName = fileName;
        this._entryOpened = false;
    }

    public void openEntry() throws IOException {
        ZipEntry entry = new ZipEntry(this._fileName);
        this._createdEntries.add(this._fileName.toString());
        this._out.putNextEntry(entry);
        this._entryOpened = true;
    }

    public void writeEntryText(String text) throws IOException {
        int bytesRead;
        if (!this._entryOpened) {
            this.openEntry();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes(Charset.forName("UTF-8")));
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            this._out.write(buffer, 0, bytesRead);
        }
    }

    public void writeEntryBinaryStream(InputStream reader) throws IOException {
        int bytesRead;
        if (!this._entryOpened) {
            this.openEntry();
        }
        byte[] buffer = new byte[4096];
        while ((bytesRead = reader.read(buffer)) != -1) {
            this._out.write(buffer, 0, bytesRead);
        }
    }

    public void writeEntryCharStream(Reader reader) throws IOException {
        int bytesRead;
        if (!this._entryOpened) {
            this.openEntry();
        }
        char[] inBuffer = new char[4096];
        String temp = null;
        byte[] buffer = new byte[4096];
        while ((bytesRead = reader.read(inBuffer)) != -1) {
            temp = new String(inBuffer);
            buffer = temp.getBytes(Charset.forName("UTF-8"));
            this._out.write(buffer, 0, bytesRead);
        }
    }

    public void writeFileEntry(String filename) throws IOException {
        this.writeFileEntry(filename, true);
    }

    public void writeFileEntry(String filename, boolean skipEmpty) throws IOException {
        File file = new File(filename);
        this.writeFileEntry(file.toURI().toURL(), skipEmpty);
    }

    public void writeFileEntry(URL url) throws IOException {
        this.writeFileEntry(url, true);
    }

    public void writeFileEntry(URL url, boolean skipEmpty) throws IOException {
        int bytesRead;
        File f = null;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (f.length() == 0L) {
            return;
        }
        if (f.isDirectory()) {
            return;
        }
        FileInputStream in = new FileInputStream(f);
        ZipEntry entry = new ZipEntry(f.getName());
        this._out.putNextEntry(entry);
        this._createdEntries.add(f.getName());
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            this._out.write(buffer, 0, bytesRead);
        }
        in.close();
    }

    public void writeFileEntry(String filePath, String entryPath, boolean skipEmpty) throws IOException {
        int bytesRead;
        File f = null;
        f = new File(filePath);
        if (f.length() == 0L) {
            return;
        }
        if (f.isDirectory()) {
            return;
        }
        FileInputStream in = new FileInputStream(f);
        ZipEntry entry = new ZipEntry(entryPath);
        this._out.putNextEntry(entry);
        this._createdEntries.add(entryPath);
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            this._out.write(buffer, 0, bytesRead);
        }
        in.close();
    }

    public void flush() throws IOException {
    }

    public void closeEntry() throws IOException {
        this._out.closeEntry();
    }

    public void addSQLControllingFile(String controllingFile, String hdrLines, boolean isExecutableControllingFile) throws IOException {
        this.openEntry(controllingFile);
        if (hdrLines != null) {
            this.writeEntryText(hdrLines);
        }
        this._createdEntries.remove(this._createdEntries.size() - 1);
        if (isExecutableControllingFile) {
            for (String s : this._createdEntries) {
                if (s.endsWith(".sql")) {
                    this.writeEntryText("@" + s + "\n");
                    continue;
                }
                this.writeEntryText("--@" + s + "\n");
            }
        } else {
            for (String s : this._createdEntries) {
                if (s.endsWith(".sql")) {
                    this.writeEntryText("SQL " + s + "\n");
                    continue;
                }
                if (!s.endsWith(".ctl")) continue;
                this.writeEntryText("LDR " + s + "\n");
            }
        }
        this.closeEntry();
    }

    public String getUniqueEntryName(String candidateFileName, String extension) {
        String fileName = candidateFileName + extension;
        int suffix = 0;
        while (this._createdEntries.contains(fileName)) {
            fileName = candidateFileName + "_" + ++suffix + extension;
        }
        return fileName;
    }
}

