/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.vault;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.vault.VaultConnection;
import oracle.dbtools.raptor.vault.VaultMessages;
import oracle.dbtools.raptor.vault.VaultResponse;
import oracle.dbtools.raptor.vault.VaultUtils;

@Restricted(level=Restricted.Level.R4)
public class VaultCmd
extends CommandListener
implements IHelp,
SQLCLService {
    private static final String VAULT_BASE_PATH = "vault.base.path";
    private static final String VAULT_AUTO_STORE = "vault.auto.store";
    private static String NAME = "Vault Command";
    private static String DESC = "Adds Hashicorp Vault support";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (VaultCmd.matches("connect", cmd.getSql())) {
            String[] parts = cmd.getSql().replace("\n", "").split("\\s+");
            VaultResponse vaultRespone = null;
            VaultUtils v = this.getVaultUtils(ctx);
            if (v.isValid()) {
                String dbName;
                ctx.write(VaultMessages.getString("VaultCmd.0") + "\n");
                String path = dbName = parts[1].trim();
                vaultRespone = v.getVaultBaseConnectionDetails(path);
                if (vaultRespone != null && vaultRespone.getResponseData() != null) {
                    try {
                        VaultConnection vconn = v.getConnection(path);
                        ctx.write("\t" + VaultMessages.getString("VaultCmd.1") + vaultRespone.getResponseData().get("user") + "/xxxx@" + (vaultRespone.getResponseData().get("jdbc.url") != null ? vaultRespone.getResponseData().get("jdbc.url") : vaultRespone.getResponseData().get("tns")) + "\n");
                        ctx.write(VaultMessages.getString("VaultCmd.2") + vaultRespone.getURL() + "\n");
                        ctx.write("Connected.\n");
                        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
                        sqlcl.setConn(vconn.getConn());
                        sqlcl.getScriptRunnerContext().setCurrentConnection(vconn.getConn());
                        sqlcl.getScriptRunnerContext().setBaseConnection(vconn.getConn());
                        sqlcl.getScriptRunnerContext().putProperty("script.runner.sqlplus.nolog", Boolean.FALSE);
                        ctx.putProperty("cli.conn.url", vconn.getJdbcUrl());
                        ctx.putProperty("cli.conn.props", vconn.getProps());
                        return true;
                    }
                    catch (SQLException e) {
                        ctx.write(e.getLocalizedMessage());
                        ctx.write("\n -- " + VaultMessages.getString("VaultCmd.3") + " -- \n");
                        ctx.write("\n -- " + vaultRespone.getURL() + " -- \n");
                        for (Map.Entry<String, ?> entry : vaultRespone.getResponseData().entrySet()) {
                            ctx.write("\t" + VaultMessages.getString("VaultCmd.4") + entry.getKey() + ":" + entry.getValue() + "\n");
                        }
                        return false;
                    }
                }
            }
            return false;
        }
        if (VaultCmd.matches("vault", cmd.getSql())) {
            VaultUtils v = this.getVaultUtils(ctx);
            if (v.isValid()) {
                String[] parts = cmd.getSql().replace("\n", "").split("\\s+");
                if ((parts.length == 2 || parts.length == 3) && parts[1].equalsIgnoreCase("store")) {
                    if (conn != null) {
                        String path = parts.length == 3 ? parts[2] : null;
                        try {
                            path = v.store2vault(conn, (String)ctx.getProperty("cli.conn.url"), (Properties)ctx.getProperty("cli.conn.props"), path);
                            ctx.write(VaultMessages.getString("VaultCmd.6") + path + "\n");
                        }
                        catch (IOException e) {
                            ctx.write(VaultMessages.getString("VaultCmd.7") + path + ":" + e.getLocalizedMessage() + "\n");
                        }
                    } else {
                        ctx.write(VaultMessages.getString("VaultCmd.8") + "\n");
                    }
                    return true;
                }
                if (parts.length == 3 && parts[1].equalsIgnoreCase("autostore")) {
                    ctx.write(VaultMessages.getString("VaultCmd.9") + Boolean.parseBoolean(parts[2]) + "\n");
                    ctx.putProperty(VAULT_AUTO_STORE, parts[2]);
                    return true;
                }
                if (parts.length == 2 && parts[1].equalsIgnoreCase("config")) {
                    ctx.write(VaultMessages.getString("VaultCmd.10") + "\n");
                    ctx.write(v.toString());
                    ctx.write("\t" + VaultMessages.getString("VaultCmd.11") + Boolean.parseBoolean((String)ctx.getProperty(VAULT_AUTO_STORE)));
                    ctx.write("\n");
                    return true;
                }
                if (parts.length == 3 && parts[1].equalsIgnoreCase("delete")) {
                    try {
                        v.delete(parts[2]);
                        ctx.write(VaultMessages.getString("VaultCmd.19") + "\n");
                    }
                    catch (IOException e) {
                        ctx.write(VaultMessages.getString("VaultCmd.20") + e.getLocalizedMessage() + "\n");
                    }
                    return true;
                }
                if (parts.length == 3 && parts[1].equalsIgnoreCase("base")) {
                    ctx.putProperty(VAULT_BASE_PATH, parts[2]);
                    return true;
                }
                if ((parts.length == 2 || parts.length == 3) && parts[1].equalsIgnoreCase("list")) {
                    this.list(v, ctx, parts.length == 2 || parts[2] == null ? null : parts[2]);
                    return true;
                }
                ctx.write("\n" + VaultMessages.getString("VaultCmd.12") + cmd.getSql() + "\n");
                return true;
            }
            ctx.write(VaultMessages.getString("VaultCmd.13") + "\n\t VAULT_ADDR :" + System.getenv("VAULT_ADDR") + "\n\t VAULT_TOKEN:" + System.getenv("VAULT_TOKEN") + "\n\n");
            return true;
        }
        return false;
    }

    private VaultUtils getVaultUtils(ScriptRunnerContext ctx) {
        String address = System.getenv("VAULT_ADDR");
        String token = System.getenv("VAULT_TOKEN");
        if (token == null) {
            try {
                byte[] bytes = Files.readAllBytes(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".vault-token"));
                token = new String(bytes, "UTF-8").trim();
            }
            catch (Exception bytes) {
                // empty catch block
            }
        }
        String base = ctx.getProperty(VAULT_BASE_PATH) != null ? (String)ctx.getProperty(VAULT_BASE_PATH) : null;
        return new VaultUtils.Builder().setAddress(address).setBase(base).setToken(token).build();
    }

    private void list(VaultUtils v, ScriptRunnerContext ctx, String filter) {
        try {
            List<String> all = v.listVault();
            ctx.write("\n" + VaultMessages.getString("VaultCmd.14") + v.getVaultAddress() + " > " + v.getBasePath() + " \n");
            boolean found = false;
            for (String name : all) {
                if (filter != null && name.indexOf(filter) <= 0) continue;
                ctx.write("\t" + name.replace(v.getBasePath(), "") + "\n");
                found = true;
            }
            if (!found) {
                ctx.write(VaultMessages.getString("VaultCmd.15") + "\n");
            }
        }
        catch (IOException e) {
            ctx.write(VaultMessages.getString("VaultCmd.16") + e.getLocalizedMessage() + "\n");
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (conn != null && VaultCmd.matches("connect", cmd.getSql()) && ctx.getProperty(VAULT_AUTO_STORE) != null && Boolean.parseBoolean((String)ctx.getProperty(VAULT_AUTO_STORE)) && ctx.getProperty("cli.conn.props") != null && ctx.getProperty("cli.conn.url") != null) {
            VaultUtils v = this.getVaultUtils(ctx);
            String path = null;
            try {
                path = v.store2vault(conn, (String)ctx.getProperty("cli.conn.url"), (Properties)ctx.getProperty("cli.conn.props"), null);
                ctx.write(VaultMessages.getString("VaultCmd.17") + path + "\n");
            }
            catch (IOException e) {
                ctx.write(VaultMessages.getString("VaultCmd.18") + path + ":" + e.getLocalizedMessage() + "\n");
            }
        }
    }

    @Override
    public String getCommand() {
        return "VAULT";
    }

    @Override
    public String getHelp() {
        return VaultMessages.getString("VaultCmd.HELP");
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public Class<? extends CommandListener> getCommandListener() {
        return this.getClass();
    }

    @Override
    public String getExtensionDescription() {
        return DESC;
    }

    @Override
    public String getExtensionName() {
        return NAME;
    }

    @Override
    public String getExtensionVersion() {
        return VaultMessages.getString("VERSION");
    }
}

