/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.tokenizer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Tokenizer;

public abstract class AbstractTokenizer
implements Tokenizer {
    @Override
    public List<Token> tokenize(String line, Locale locale, Consumer<String> errorConsumer) {
        Token lastToken;
        ArrayList<Token> tokens = new ArrayList<Token>();
        this.findMatches(line, (reducedValue, rawValue, start, end) -> tokens.add(new TokenImpl(reducedValue, rawValue, line, start, end, locale, errorConsumer)));
        if (tokens.isEmpty()) {
            return tokens;
        }
        int charNo = 0;
        int syntaxErrorAt = -1;
        String errorToken = null;
        Token firstToken = (Token)tokens.get(0);
        String divider = line.substring(0, firstToken.getStart());
        if (!divider.trim().isEmpty()) {
            syntaxErrorAt = 0;
            errorToken = divider;
        }
        if (errorToken == null) {
            for (Token token : tokens) {
                String divider2 = line.substring(charNo, token.getStart());
                if (!divider2.trim().isEmpty()) {
                    syntaxErrorAt = token.getStart();
                    errorToken = divider2;
                    break;
                }
                charNo = token.getEnd();
            }
        }
        if (errorToken == null && !(divider = line.substring((lastToken = (Token)tokens.get(tokens.size() - 1)).getEnd(), line.length())).trim().isEmpty()) {
            syntaxErrorAt = lastToken.getEnd();
            errorToken = divider;
        }
        if (errorToken != null) {
            errorConsumer.accept(MessageFormat.format(Messages.getString(Messages.Key.SYNTAX_ERROR, locale), syntaxErrorAt, errorToken));
            return Collections.EMPTY_LIST;
        }
        return tokens;
    }

    protected abstract void findMatches(String var1, MatchRegistry var2);

    private static class TokenImpl
    implements Token {
        final Token.Type type;
        final String value;
        final String rawValue;
        final String line;
        final int start;
        final int end;

        TokenImpl(String reducedValue, String rawValue, String line, int start, int end, Locale locale, Consumer<String> errorConsumer) {
            char first = reducedValue.charAt(0);
            switch (first) {
                case '\"': 
                case '\'': {
                    int length = reducedValue.length();
                    if (length > 1 && reducedValue.charAt(length - 1) == first) {
                        this.type = Token.Type.LITERAL;
                        this.value = reducedValue.substring(1, length - 1);
                        break;
                    }
                    this.type = Token.Type.LITERAL;
                    this.value = "";
                    errorConsumer.accept(MessageFormat.format(Messages.getString(Messages.Key.SYNTAX_ERROR, locale), start, rawValue));
                    break;
                }
                default: {
                    this.type = Token.Type.SYMBOL;
                    this.value = reducedValue;
                }
            }
            this.rawValue = rawValue;
            this.line = line;
            this.start = start;
            this.end = end;
        }

        @Override
        public Token.Type getType() {
            return this.type;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getRawValue() {
            return this.rawValue;
        }

        @Override
        public String getLine() {
            return this.line;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return this.value;
        }
    }

    protected static interface MatchRegistry {
        public void addMatch(String var1, String var2, int var3, int var4);
    }
}

