/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.command;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public abstract class ParsedCommandListener
extends CommandListener
implements IHelp,
Connected {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!this.matches(cmd)) {
            return false;
        }
        ArrayList<String> errors = new ArrayList<String>();
        Optional<ParsedCommand> optParsedCommand = this.parseCommand(conn, ctx, cmd, errors::add);
        if (!optParsedCommand.isPresent()) {
            this.handleParserErrors(conn, ctx, cmd, errors);
            return true;
        }
        ParsedCommand parsedCommand = optParsedCommand.get();
        this.loadParams(ctx, parsedCommand);
        return this.handleEvent(conn, ctx, cmd, parsedCommand);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public Type getParserType() {
        return this.createType();
    }

    protected abstract boolean handleEvent(Connection var1, ScriptRunnerContext var2, ISQLCommand var3, ParsedCommand var4);

    protected abstract Type createType();

    protected String getParameterSetName() {
        return null;
    }

    protected Optional<ParsedCommand> parseCommand(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, Consumer<String> errorConsumer) {
        Type type = this.createType();
        Parser parser = new Parser(type, ctx.getEnvironment());
        return parser.parse(this.adjustCmdSql(cmd.getSql()), errorConsumer);
    }

    protected String adjustCmdSql(String cmdSql) {
        return cmdSql;
    }

    protected void loadParams(ScriptRunnerContext ctx, ParsedCommand parsedCommand) {
        if (this.getParameterSetName() != null) {
            for (Option<?> option : parsedCommand.getType().getOptions()) {
                ctx.getParameterInstance().putParameter(this.getParameterSetName(), option.getName().toLowerCase(), parsedCommand.getOptionValue(option.getId()));
            }
        }
    }

    protected void handleParserErrors(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, List<String> errors) {
        if (errors != null && !errors.isEmpty()) {
            errors.forEach(ctx::writeln);
            StringBuilder baseHelpPath = new StringBuilder(this.getCommand().toUpperCase());
            String helpPath = this.handleHelpPath(cmd, this.createType(), baseHelpPath);
            ctx.writeln(this.getHelp(ctx, helpPath).orElse(""));
        }
    }

    private String handleHelpPath(ISQLCommand cmd, Type myType, StringBuilder helpPath) {
        if (!myType.getNestedTypes().isEmpty()) {
            for (Type type : myType.getNestedTypes()) {
                if (!cmd.getSql().toUpperCase().startsWith(this.createType().getName().toUpperCase()) || !cmd.getSql().toUpperCase().contains(type.getName().toUpperCase())) continue;
                helpPath.append("/").append(type.getName().toUpperCase());
                if (!type.getNestedTypes().isEmpty()) {
                    this.handleHelpPath(cmd, type, helpPath);
                }
                return helpPath.toString();
            }
        }
        return helpPath.toString();
    }

    protected HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        int lineSize = Integer.parseInt(ctx.getProperty("script.runner.setlinesize").toString());
        HelpPagesBuilder helpPages = new HelpPagesBuilder(ctx.getEnvironment()).lineSize(lineSize).addHelpContainerFor(this).addPages(new CommandPageAssemblers(type, new Type[0]));
        return helpPages.build();
    }

    protected boolean matches(ISQLCommand cmd) {
        Type type = this.createType();
        String cmdString = cmd.getSql().toUpperCase().trim();
        if (cmdString.startsWith(type.getName().toUpperCase())) {
            return true;
        }
        for (String abbr : type.getSynonyms().get()) {
            if (!cmdString.startsWith(abbr.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCommand() {
        return this.createType().getName();
    }

    @Override
    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, this.createType()).get(pagePath);
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean needsConnection() {
        return true;
    }
}

