/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeFactory;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataTypeSQLException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataTypeImpl;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.metadata.ArgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.MetadataLoader;
import oracle.dbtools.raptor.datatypes.oracle.sql.DatumWithConnection;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingUDT;
import oracle.dbtools.raptor.datatypes.strategies.preparedstatement.PrepareBindingUDT;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.values.CompositeValue;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.jdbc.internal.OracleStruct;
import oracle.sql.Datum;

public class STRUCT
extends DatumWithConnection {
    protected STRUCT(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, STRUCT.expandTypeMetadata(context, typeMetadata));
    }

    protected static TypeMetadata expandTypeMetadata(DataTypeContext context, TypeMetadata typeMetadata) {
        TypeMetadata newTypeMetadata = typeMetadata;
        try {
            List<NamedValue<TypeMetadata>> attributes = STRUCT.loadAttributes(context, typeMetadata);
            HashMap<TypeMetadata.Attribute, Object> attributeMap = new HashMap<TypeMetadata.Attribute, Object>();
            attributeMap.put(TypeMetadata.Attribute.TYPE_COMPONENTS, attributes);
            newTypeMetadata = DataTypeFactory.getTypeMetadata(typeMetadata, attributeMap);
        }
        catch (SQLException e) {
            throw new DataTypeSQLException(e);
        }
        return newTypeMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<NamedValue<TypeMetadata>> loadAttributes(DataTypeContext context, TypeMetadata typeMetadata) throws SQLException {
        DataTypeConnectionProvider provider = context.getDataTypeConnectionProvider();
        LinkedList<NamedValue<TypeMetadata>> typeComponents = new LinkedList<NamedValue<TypeMetadata>>();
        Object conn = provider.lockDataTypeConnection();
        if (conn != null) {
            try {
                LinkedList<ArgMetadata> loadStack = new LinkedList<ArgMetadata>();
                String typeOwner = typeMetadata.get_type_owner();
                String typeName = typeMetadata.get_type_name();
                new MetadataLoader((Connection)conn).loadSQLAttributes(loadStack, typeOwner, typeName, 0);
                while (!loadStack.isEmpty()) {
                    ArgMetadata argMetadata = (ArgMetadata)loadStack.pop();
                    TypeMetadata componentTypeMetadata = context.getDataTypeFactory().getTypeMetadata((Map)argMetadata.getValue());
                    typeComponents.add(new NamedValue<TypeMetadata>(argMetadata.getName(), componentTypeMetadata));
                }
            }
            finally {
                provider.unlockDataTypeConnection();
            }
        }
        return typeComponents;
    }

    private static Integer getIntegerResult(ResultSet rset, String name) throws SQLException {
        return rset.getObject(name) != null ? Integer.valueOf(rset.getInt(name)) : null;
    }

    private static void addAttribute(HashMap<TypeMetadata.Attribute, Object> attributes, TypeMetadata.Attribute attribute, Object value) {
        if (value != null) {
            attributes.put(attribute, value);
        }
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        StringBuilder sb = new StringBuilder();
        int len = 0;
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append("(");
        }
        ++len;
        List<DataValue> components = this.getComponents(value);
        int i = 0;
        for (DataValue component : components) {
            if (i > 0) {
                if (maxLen < 0 || sb.length() < maxLen) {
                    sb.append(", ");
                }
                len += 2;
            }
            String fieldTag = component.getName() != null ? component.getName() + "=" : "";
            String componentValue = "" + component.getStringValue(connectionProvider, stringType, maxLen);
            if (maxLen < 0 || sb.length() < maxLen) {
                sb.append(fieldTag);
            }
            len += fieldTag.length();
            if (maxLen < 0 || sb.length() < maxLen) {
                sb.append(componentValue);
            }
            len += componentValue.length();
            ++i;
        }
        if (maxLen < 0 || sb.length() < maxLen) {
            sb.append(")");
        }
        return new StringValue(sb.toString(), ++len);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        try {
            List dataValueList = this.customComponents(value);
            int arraySize = ((LinkedList)dataValueList).size();
            ArrayList<Object> objectArray = new ArrayList<Object>(arraySize);
            for (DataValue dataValue : dataValueList) {
                objectArray.add(dataValue.getTypedValue(connectionProvider, valueType));
            }
            switch (valueType) {
                case JDBC: 
                case DATUM: {
                    Object validConnection = connectionProvider.getValidDataTypeConnection();
                    return validConnection.createStruct(this.getUserDataTypeString(), objectArray.toArray(new Object[arraySize]));
                }
            }
            return objectArray;
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, internalValue, e);
        }
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        return Struct.class;
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 2002;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        LinkedList<DataValue> dataValueList = new LinkedList<DataValue>();
        try {
            if (value == null) {
                return this.customInternalValue(connectionProvider, dataValueList);
            }
            if (value instanceof OracleStruct) {
                OracleStruct valueStruct = (OracleStruct)value;
                Datum[] datumArray = valueStruct.getOracleAttributes();
                return this.customInternalValue(connectionProvider, datumArray);
            }
            if (value.getClass().isArray()) {
                int arrayLength = Array.getLength(value);
                int i = 0;
                Collection<NamedValue<DataType>> components = this.getTypeComponents();
                for (NamedValue namedValue : components) {
                    Object fieldValue = i < arrayLength ? Array.get(value, i++) : null;
                    DataValue newDataValue = ((DataType)namedValue.getValue()).getDataValue(fieldValue);
                    dataValueList.add(NamedDataValue.getNamedDataValue(namedValue.getName(), newDataValue));
                }
                return dataValueList;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                Object[] values = collection.toArray(new Object[0]);
                return this.customInternalValue(connectionProvider, values);
            }
            throw new DataTypeIllegalArgumentException(this, value);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    @Override
    protected Object customInternalValueFilter(DataTypeConnectionProvider connectionProvider, Object value) {
        if (DataTypesUtil.isEmpty(value)) {
            return this.customInternalValue(connectionProvider, null);
        }
        return super.customInternalValueFilter(connectionProvider, value);
    }

    @Override
    public <P extends DataBinding> BindingStrategy getBind(BindContext context, P param) {
        if (CallableStatement.class.isAssignableFrom(context.getEffectiveStatementClass())) {
            return new CallableBindingUDT(context, param);
        }
        return new PrepareBindingUDT(context, param);
    }

    protected LinkedList<DataValue> customComponents(DataValueInternal value) {
        return (LinkedList)value.getInternalValue();
    }

    @Override
    protected DataValue customDataValue(Object object) {
        return new CompositeValue((DataTypeImpl)this, object);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return this.customInternalValue(this.getDataTypeContext().getDataTypeConnectionProvider(), null);
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
    }

    @Override
    public void bodyDataValue(NamedValue value, String text) {
    }

    @Override
    public void bodyDataValue(NamedValue value, DataValue dataValue) {
        LinkedList dataValueList = (LinkedList)value.getValue();
        int i = 0;
        for (DataValue valueSlot : dataValueList) {
            String slotName = valueSlot.getName();
            String valueName = dataValue.getName();
            if (slotName != null && valueName != null && slotName.equals(valueName)) {
                dataValueList.set(i, NamedDataValue.getNamedDataValue(slotName, dataValue));
            }
            ++i;
        }
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        return this.customDataValue(value.getValue());
    }

    @Override
    public StructureType getStructureType() {
        return StructureType.RECORD;
    }
}

