/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.app.Format;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.plsql.Function;
import oracle.dbtools.plsql.Member;
import oracle.dbtools.plsql.Parameter;
import oracle.dbtools.plsql.Procedure;
import oracle.dbtools.plsql.Type;
import oracle.dbtools.util.Service;

public class CompilationUnit {
    private static final String path = "/oracle/dbtools/plsql/";
    private static SqlProgram programInstance = null;
    private String input = null;
    private List<LexerToken> fullCode = null;
    private Parsed target = null;
    int headerStart = -1;
    int headerEnd = -1;
    Map<Integer, Member> members = new TreeMap<Integer, Member>();

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(CompilationUnit.class, (String)"customer_data.pkgspec");
        CompilationUnit obj = new CompilationUnit(input);
        System.out.println(obj.toString());
    }

    public CompilationUnit(String input) throws Exception {
        this.input = input;
        this.parse();
    }

    public CompilationUnit(String schema, String object, Connection conn) throws Exception {
        StringBuilder ret = new StringBuilder();
        PreparedStatement stmt = conn.prepareStatement("select text from all_source \nwhere owner = :owner and name = :name \nand type in ('PACKAGE','PROCEDURE','FUNCTION') \norder by line ");
        stmt.setString(1, schema);
        stmt.setString(2, object);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            ret.append(rs.getString(1));
        }
        rs.close();
        stmt.close();
        this.input = ret.toString();
        this.parse();
    }

    public String getHeader() {
        for (LexerToken t : this.fullCode) {
            if (t.type != Token.COMMENT || 0 >= t.content.indexOf("@headcom")) continue;
            return t.content;
        }
        return null;
    }

    public Map<Integer, Member> getMembers() {
        return this.members;
    }

    public static Map<String, CompilationUnit> getPlsqlDocs(String schema, Connection conn) throws Exception {
        HashMap<String, CompilationUnit> ret = new HashMap<String, CompilationUnit>();
        PreparedStatement stmt = conn.prepareStatement("select object_name from all_objects \nwhere owner = :owner and object_type in ('PACKAGE','PROCEDURE','FUNCTION')");
        stmt.setString(1, schema);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String name = rs.getString(1);
            ret.put(name, null);
        }
        rs.close();
        stmt.close();
        for (String name : ret.keySet()) {
            ret.put(name, new CompilationUnit(schema, name, conn));
        }
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getHeader());
        ret.append("\n");
        for (int charOffset : this.getMembers().keySet()) {
            ret.append(this.getMembers().get(charOffset).toString());
            ret.append("\n");
            ret.append("-------------------------------------\n");
        }
        return ret.toString();
    }

    private void parse() throws Exception {
        if (programInstance == null) {
            programInstance = new SqlProgram(Service.readFile(Format.class, (String)"/oracle/dbtools/plsql/pldoc.arbori"));
        }
        this.fullCode = Lexer.parse((String)this.input, (boolean)true);
        LinkedList<LexerToken> src1 = new LinkedList<LexerToken>();
        for (LexerToken t : this.fullCode) {
            if (t.type == Token.WS || t.type == Token.COMMENT || t.type == Token.LINE_COMMENT) continue;
            src1.add(t);
        }
        SqlEarley earley = SqlEarley.getInstance();
        Matrix matrix = new Matrix((Parser)earley);
        earley.parse(src1, matrix);
        ParseNode root = earley.forest(src1, matrix);
        this.target = new Parsed(this.input, src1, root);
        programInstance.eval(this.target, (Object)this);
        for (LexerToken t : this.fullCode) {
            if (t.type != Token.COMMENT && t.type != Token.LINE_COMMENT || t.content.contains("@headcom")) continue;
            boolean embeddedComment = false;
            int closestDeclOffset = Integer.MAX_VALUE;
            for (int charOffset : this.members.keySet()) {
                Member cmp = this.members.get(charOffset);
                if (charOffset <= t.begin && t.end <= charOffset + cmp.code.length()) {
                    embeddedComment = true;
                    break;
                }
                if (charOffset < t.begin || charOffset >= closestDeclOffset) continue;
                closestDeclOffset = charOffset;
            }
            if (embeddedComment || closestDeclOffset == Integer.MAX_VALUE) continue;
            this.members.get(closestDeclOffset).setComment(t.content);
        }
    }

    void headerLocation(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode is = tuple.get("is_or_as");
        this.headerStart = ((LexerToken)target.getSrc().get((int)is.from)).end;
        this.headerEnd = ((LexerToken)target.getSrc().get((int)is.to)).begin;
    }

    void type(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode decl = tuple.get("ty_d");
        String name = ((LexerToken)target.getSrc().get((int)(decl.from + 1))).content;
        String code = target.getInput().substring(((LexerToken)target.getSrc().get((int)decl.from)).begin, ((LexerToken)target.getSrc().get((int)decl.to)).begin);
        this.members.put(((LexerToken)target.getSrc().get((int)decl.from)).begin, new Type(name, code));
    }

    void procedure(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode decl = tuple.get("subprg_spec");
        String name = ((LexerToken)target.getSrc().get((int)(decl.from + 1))).content;
        String code = target.getInput().substring(((LexerToken)target.getSrc().get((int)decl.from)).begin, ((LexerToken)target.getSrc().get((int)decl.to)).begin);
        this.members.put(((LexerToken)target.getSrc().get((int)decl.from)).begin, new Procedure(name, code));
    }

    void function(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode decl = tuple.get("subprg_spec");
        String name = ((LexerToken)target.getSrc().get((int)(decl.from + 1))).content;
        String code = target.getInput().substring(((LexerToken)target.getSrc().get((int)decl.from)).begin, ((LexerToken)target.getSrc().get((int)decl.to)).begin);
        this.members.put(((LexerToken)target.getSrc().get((int)decl.from)).begin, new Function(name, code));
    }

    void parameter(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode decl = tuple.get("basic_decl_item");
        Member member = this.members.get(((LexerToken)target.getSrc().get((int)decl.from)).begin);
        ParseNode prm = tuple.get("prm_spec");
        String name = ((LexerToken)target.getSrc().get((int)prm.from)).content;
        int charOffset = ((LexerToken)target.getSrc().get((int)prm.from)).begin;
        String code = target.getInput().substring(charOffset, ((LexerToken)target.getSrc().get((int)prm.to)).begin);
        ParseNode type = tuple.get("datatype");
        String deflt = null;
        if (prm.to != type.to) {
            deflt = target.getInput().substring(((LexerToken)target.getSrc().get((int)type.to)).begin, ((LexerToken)target.getSrc().get((int)prm.to)).begin);
        }
        member.addParam(charOffset, new Parameter(name, ((LexerToken)target.getSrc().get((int)type.from)).content, CompilationUnit.mode(code, "IN"), CompilationUnit.mode(code, "OUT"), CompilationUnit.mode(code, "NOCOPY"), deflt));
    }

    private static boolean mode(String code, String mode) {
        return 0 < code.toLowerCase().indexOf(mode.toLowerCase());
    }

    void ret(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode decl = tuple.get("basic_decl_item");
        Member member = this.members.get(((LexerToken)target.getSrc().get((int)decl.from)).begin);
        ParseNode ret = tuple.get("func_return");
        int charOffset = ((LexerToken)target.getSrc().get((int)ret.from)).begin;
        member.addParam(charOffset, new Parameter(null, ((LexerToken)target.getSrc().get((int)ret.from)).content, false, true, false, null));
    }

    void fld(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode decl = tuple.get("basic_decl_item");
        Member member = this.members.get(((LexerToken)target.getSrc().get((int)decl.from)).begin);
        ParseNode field = tuple.get("field");
        String name = ((LexerToken)target.getSrc().get((int)field.from)).content;
        int charOffset = ((LexerToken)target.getSrc().get((int)field.from)).begin;
        ParseNode type = tuple.get("datatype");
        String datatype = target.getInput().substring(((LexerToken)target.getSrc().get((int)type.from)).begin, ((LexerToken)target.getSrc().get((int)(type.to - 1))).end);
        String deflt = null;
        if (field.to != type.to) {
            deflt = target.getInput().substring(((LexerToken)target.getSrc().get((int)type.to)).begin, ((LexerToken)target.getSrc().get((int)field.to)).begin);
        }
        member.addParam(charOffset, new Parameter(name, datatype, false, false, false, deflt));
    }
}

