/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.metrics;

import java.util.logging.Level;
import oracle.adf.share.logging.ADFLogger;

public abstract class Metric {
    protected final Level level;
    protected final String fullName;

    protected Metric(Level level, String fullName) {
        this.level = level;
        this.fullName = fullName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", fullName=" + this.fullName + ", level=" + this.level;
    }

    public void reset() {
    }

    public void destroy() {
    }

    public boolean isActive() {
        return LevelHolder.INST.isLoggable(this.level);
    }

    public String getFullName() {
        return this.fullName;
    }

    static class LevelHolder {
        static final String METRICS_LOGGER_NAME = "oracle.adf.metrics";
        static final ADFLogger INST = ADFLogger.createADFLogger("oracle.adf.metrics");

        LevelHolder() {
        }
    }
}

