/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.logging.ADFLoggerUtil;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.dms.context.ExecutionContext;

public class ADFLoggerHelper {
    private static final ADFLogger utilLogger = ADFLogger.createADFLogger(ADFLoggerHelper.class);
    public static final String ADF_LOGGER_MESSAGE_BUNDLE = "oracle.adf.share.logging.resources.LoggerMessageBundle";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginNPS(String loggerName, String actionName, HashMap<String, String> contextData) {
        ADFLogger logger = ADFLogger.createADFLogger(loggerName);
        if (logger.isLoggable(Level.CONFIG) && actionName != null) {
            String data = this.setBeginExecutionContext(logger, contextData, actionName, "begin", "begin");
            try {
                logger.log(Level.CONFIG, actionName);
            }
            catch (Exception e) {
                utilLogger.severe(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("EXCEPTION_LOGGING_A_MESSAGE") + e.getMessage());
            }
            finally {
                this.resetBeginExecutionContext(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginNodeNPS(String loggerName, Level level, String actionName, Map<String, String> contextData, String methodName) {
        ADFLogger logger = ADFLogger.createADFLogger(loggerName);
        if (logger.isLoggable(level) && actionName != null) {
            String data = this.setBeginExecutionContext(logger, contextData, actionName, methodName, "begin");
            try {
                logger.log(level, actionName);
            }
            catch (Exception e) {
                utilLogger.severe(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("EXCEPTION_LOGGING_A_MESSAGE") + e.getMessage());
            }
            finally {
                this.resetBeginExecutionContext(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextDataNPS(String loggerName, String actionName, HashMap<String, String> contextData) {
        ADFLogger logger = ADFLogger.createADFLogger(loggerName);
        if (logger.isLoggable(Level.CONFIG) && actionName != null) {
            this.setaddContextDataExecutionContext(actionName, contextData);
            try {
                logger.log(Level.CONFIG, actionName);
            }
            finally {
                this.resetaddContextDataExecutionContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestMessageNPS(String loggerName, Level level, String actionName, Map<String, String> contextData, String MessageTag, String methodName, Throwable thrown) {
        ADFLogger logger = ADFLogger.createADFLogger(loggerName);
        if (logger.isLoggable(level)) {
            this.setaddRequestmessageExecutionContext(actionName, contextData, MessageTag, methodName);
            try {
                if (thrown != null) {
                    logger.log(level, actionName, thrown);
                } else {
                    logger.log(level, actionName);
                }
            }
            catch (Exception e) {
                utilLogger.severe(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("EXCEPTION_LOGGING_A_MESSAGE") + e.getMessage());
            }
            finally {
                this.resetaddContextDataExecutionContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endNodeNPS(String loggerName, Level level, String actionName) {
        ADFLogger logger = ADFLogger.createADFLogger(loggerName);
        if (logger.isLoggable(level)) {
            if (AdfServerPlatformUtil.isWebLogicCore() || !AdfServerPlatformUtil.isDMS4LoggingAvailable()) {
                logger.log(level, actionName);
                return;
            }
            ExecutionContext context = ExecutionContext.get();
            context.setValue("ADF_MESSAGE_STATUS", "end");
            context.setValue("ADF_MESSAGE_ACTION_NAME", actionName);
            try {
                logger.log(level, actionName);
            }
            finally {
                context.setValue("ADF_MESSAGE_STATUS", null);
                context.setValue("ADF_MESSAGE_ACTION_NAME", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void LogRelativeADFRequest(String loggerName, String parentEcid) {
        ADFLogger logger = ADFLogger.createADFLogger(loggerName);
        if (logger.isLoggable(Level.CONFIG)) {
            if (AdfServerPlatformUtil.isWebLogicCore() || !AdfServerPlatformUtil.isDMS4LoggingAvailable()) {
                logger.log(Level.CONFIG, "Secondary ADF Request");
                return;
            }
            ExecutionContext context = ExecutionContext.get();
            context.setValue("ADF_MESSAGE_STATUS", "PARENT_REQUEST_ECID");
            context.setValue("PARENT_REQUEST_ECID", parentEcid);
            try {
                logger.log(Level.CONFIG, "Secondary ADF Request");
            }
            finally {
                context.setValue("ADF_MESSAGE_STATUS", null);
                context.setValue("PARENT_REQUEST_ECID", null);
            }
        }
    }

    private void setaddRequestmessageExecutionContext(String actionName, Map<String, String> contextData, String MessageTag, String methodName) {
        String ctxData;
        if (AdfServerPlatformUtil.isWebLogicCore() || !AdfServerPlatformUtil.isDMS4LoggingAvailable()) {
            return;
        }
        ExecutionContext context = ExecutionContext.get();
        if (contextData == null) {
            contextData = new HashMap<String, String>();
        }
        if (!ADFLoggerUtil.isADFComponentAdded(contextData)) {
            contextData.put("Component", ADFLoggerUtil.getModuleName(methodName));
        }
        if ((ctxData = ADFLoggerUtil.convertContextDataMap(contextData)).length() > 0) {
            context.setValue("ADF_MESSAGE_CONTEXT_DATA", ctxData);
        }
        context.setValue("ADF_MESSAGE_ACTION_NAME", actionName);
        context.setValue("ADF_MESSAGE_STATUS", MessageTag);
    }

    private void setaddContextDataExecutionContext(String actionName, HashMap<String, String> contextData) {
        String ctxData;
        if (AdfServerPlatformUtil.isWebLogicCore() || !AdfServerPlatformUtil.isDMS4LoggingAvailable()) {
            return;
        }
        ExecutionContext context = ExecutionContext.get();
        if (contextData == null) {
            contextData = new HashMap();
        }
        if (!ADFLoggerUtil.isADFComponentAdded(contextData)) {
            contextData.put("Component", ADFLoggerUtil.getModuleName("addContextData"));
        }
        if ((ctxData = ADFLoggerUtil.convertContextDataMap(contextData)).length() > 0) {
            context.setValue("ADF_MESSAGE_CONTEXT_DATA", ctxData);
        }
        context.setValue("ADF_MESSAGE_ACTION_NAME", actionName);
        context.setValue("ADF_MESSAGE_STATUS", "add_context_data");
    }

    private void resetaddContextDataExecutionContext() {
        if (AdfServerPlatformUtil.isWebLogicCore() || !AdfServerPlatformUtil.isDMS4LoggingAvailable()) {
            return;
        }
        ExecutionContext context = ExecutionContext.get();
        context.setValue("ADF_MESSAGE_CONTEXT_DATA", null);
        context.setValue("ADF_MESSAGE_ACTION_NAME", null);
        context.setValue("ADF_MESSAGE_STATUS", null);
    }

    private String setBeginExecutionContext(ADFLogger logger, Map<String, String> contextData, String actionName, String methodName, String messageTag) {
        String ctxData;
        if (AdfServerPlatformUtil.isWebLogicCore() || !AdfServerPlatformUtil.isDMS4LoggingAvailable()) {
            return this._setBeginExecutionContext(logger, contextData, actionName, methodName, messageTag);
        }
        ExecutionContext context = ExecutionContext.get();
        ResourceBundle rb = logger.getResourceBundle();
        String actionDesc = "";
        String disCol = "";
        String disColValue = "";
        if (rb != null) {
            String actionNamePrefix = actionName.trim().replace(' ', '_');
            try {
                actionDesc = rb.getString(actionNamePrefix + "_DESC");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                disCol = rb.getString(actionNamePrefix + "_DISPLAY_COL");
                String val = contextData.get(disCol);
                if (val != null) {
                    disColValue = val;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (contextData == null) {
            contextData = new HashMap<String, String>();
        }
        if (!ADFLoggerUtil.isADFComponentAdded(contextData)) {
            contextData.put("Component", ADFLoggerUtil.getModuleName(methodName));
        }
        if ((ctxData = ADFLoggerUtil.convertContextDataMap(contextData)).length() > 0) {
            context.setValue("ADF_MESSAGE_CONTEXT_DATA", ctxData);
        }
        context.setValue("ADF_MESSAGE_ACTION_NAME", actionName);
        context.setValue("ADF_MESSAGE_ACTION_DESC", actionDesc);
        context.setValue("ADF_MESSAGE_STATUS", messageTag);
        if (disCol != null && disCol.trim().length() > 0) {
            context.setValue("ADF_MESSAGE_DEFAULT_CONTEXT_DATA", disCol + "=" + disColValue);
        }
        return ctxData;
    }

    private String _setBeginExecutionContext(ADFLogger logger, Map<String, String> contextData, String actionName, String methodName, String messageTag) {
        ResourceBundle rb = logger.getResourceBundle();
        String actionDesc = "";
        String disCol = "";
        String disColValue = "";
        if (rb != null) {
            String actionNamePrefix = actionName.trim().replace(' ', '_');
            try {
                actionDesc = rb.getString(actionNamePrefix + "_DESC");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            try {
                disCol = rb.getString(actionNamePrefix + "_DISPLAY_COL");
                String val = contextData.get(disCol);
                if (val != null) {
                    disColValue = val;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (contextData == null) {
            contextData = new HashMap<String, String>();
        }
        if (!ADFLoggerUtil.isADFComponentAdded(contextData)) {
            contextData.put("Component", ADFLoggerUtil.getModuleName(methodName));
        }
        String ctxData = ADFLoggerUtil.convertContextDataMap(contextData);
        return ctxData;
    }

    private void resetBeginExecutionContext(String ctxData) {
        if (AdfServerPlatformUtil.isWebLogicCore() || !AdfServerPlatformUtil.isDMS4LoggingAvailable()) {
            return;
        }
        ExecutionContext context = ExecutionContext.get();
        context.setValue("ADF_MESSAGE_CONTEXT_DATA", null);
        context.setValue("ADF_MESSAGE_ACTION_NAME", null);
        context.setValue("ADF_MESSAGE_ACTION_DESC", null);
        context.setValue("ADF_MESSAGE_STATUS", null);
        context.setValue("ADF_MESSAGE_DEFAULT_CONTEXT_DATA", null);
        if (ctxData.length() > 0) {
            context.setValue("ADF_MESSAGE_CONTEXT_DATA", null);
        }
    }
}

