/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.codesharing.audit.annotation.CodeSharingSafe;
import oracle.adf.share.common.impl.PlatformUtil;
import oracle.adf.share.common.rc.util.impl.LoaderUtilImpl;
import oracle.adf.share.common.rc.util.impl.URLUtil;
import oracle.adf.share.common.util.ADFJarUtil;

@CodeSharingSafe(value="StaticInitializer")
public class LoaderUtil {
    private static final Logger logger = Logger.getLogger(LoaderUtil.class.getName());
    @CodeSharingSafe(value="MutableStaticField")
    private static ThreadLocal<HashMap<Object, ClassLoader>> tlMap = new ThreadLocal();
    private static final NOPEnumeration NOP_ENUM = new NOPEnumeration();
    private static final NOPParent NOP_PARENT = new NOPParent();
    private static final URLClassLoader NOP_LOADER = new URLClassLoader(new URL[0], (ClassLoader)NOP_PARENT);
    private static final boolean DISABLE_JRL = LoaderUtil.getDisableJRLBoolean();
    private static final boolean JRL_AVAILABLE = LoaderUtil.initJRLAvailable();

    public static ClassLoader getLoader(URL[] urls, ClassLoader parent) {
        urls = LoaderUtil.cleanURLs(urls);
        if (parent == null) {
            parent = NOP_PARENT;
            if (urls.length == 1 && LoaderUtil.isTLCacheActive()) {
                return LoaderUtil.getAndCacheLoader(urls, parent);
            }
        }
        return LoaderUtil.justGetLoader(urls, parent);
    }

    static URL[] cleanURLs(URL[] urls) {
        if (urls == null) {
            urls = new URL[]{};
        } else {
            try {
                urls = URLUtil.getURLForPath(urls);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    private static ClassLoader justGetLoader(URL[] urls, ClassLoader parent) {
        if (!(urls != null && urls.length != 0 || parent != null && parent != NOP_PARENT)) {
            return NOP_LOADER;
        }
        if (DISABLE_JRL || !JRL_AVAILABLE) {
            return new URLClassLoader(URLUtil.stripCleanedURLs(urls), parent);
        }
        return LoaderUtilImpl.newJRLClassLoader(urls, parent);
    }

    public static ClassLoader getAndCacheLoader(URL[] urls, ClassLoader parent) {
        if (!LoaderUtil.isTLCacheActive()) {
            throw new IllegalStateException("Must activate the TLCache first");
        }
        String mapKey = LoaderUtil.getTLCacheKey(urls, parent);
        ClassLoader ldr = tlMap.get().get(mapKey);
        if (ldr == null) {
            ldr = LoaderUtil.justGetLoader(urls, parent);
            tlMap.get().put(mapKey, ldr);
        }
        return ldr;
    }

    private static String getTLCacheKey(URL[] urls, ClassLoader parent) {
        StringBuilder mapKey = new StringBuilder();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                Object k = urls[i].toString();
                int x = ((String)k).indexOf(58);
                if (x != -1) {
                    String proto = ((String)k).substring(0, x);
                    if (!ADFJarUtil.isJarProtocol(urls[i]) && !proto.equals("zip") && URLUtil.getArchiveExtension((String)k) != null) {
                        k = "jar:" + (String)k + "!/";
                    }
                }
                mapKey.append("@" + ((String)k).hashCode());
            }
        }
        mapKey.append("@" + String.valueOf(parent).hashCode());
        return mapKey.toString();
    }

    public static boolean activateTLCache() {
        if (LoaderUtil.isTLCacheActive()) {
            return false;
        }
        tlMap.set(new HashMap(4));
        return true;
    }

    public static void clearTLCache() {
        tlMap.remove();
    }

    public static boolean isTLCacheActive() {
        return tlMap.get() != null;
    }

    public static void dumpClassLoaderHierarchy(ClassLoader loader, StringBuilder buf, String prefix, String incr) {
        ClassLoader sysCL;
        ClassLoader classLoader = sysCL = loader != null ? ClassLoader.getSystemClassLoader() : null;
        while (loader != null) {
            String appe = sysCL == loader ? " (sysCL)" : "";
            buf.append((String)prefix + loader + appe + "\n");
            prefix = incr + (String)prefix;
            loader = loader.getParent();
        }
    }

    public static ClassLoader getNOPParent() {
        return NOP_PARENT;
    }

    private static boolean initJRLAvailable() {
        block5: {
            try {
                ClassLoader cl = LoaderUtilImpl.newJRLClassLoader(new URL[0], NOP_PARENT);
                if (cl == null && logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "ClassLoader returned null, continuing with JRL impl", logger.isLoggable(Level.FINE) ? new Throwable("DIAGNOSTIC, NOT AN ERROR") : null);
                }
                return true;
            }
            catch (NoClassDefFoundError ncdf) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("DIAGNOSTIC AID, NOT AN ERROR: " + ncdf);
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, "", t);
            }
        }
        return false;
    }

    private static final boolean getDisableJRLBoolean() {
        boolean jrlEnabled = false;
        boolean jrlDisabled = true;
        try {
            String disableJRL = System.getProperty("oracle.adf.share.common.rc.util.disableJRL");
            if (disableJRL != null) {
                return "true".equalsIgnoreCase(disableJRL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !new PlatformUtil().useURLFileSystem();
    }

    private static class NOPParent
    extends ClassLoader {
        private NOPParent() {
        }

        @Override
        protected URL findResource(String name) {
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return NOP_ENUM;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return NOP_ENUM;
        }
    }

    private static class NOPEnumeration
    implements Enumeration<URL> {
        private NOPEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            return null;
        }
    }
}

