/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import java.util.List;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentWithDatatype;
import oracle.javatools.util.ModelUtil;

public abstract class Operation
extends AbstractSQLFragment
implements SQLFragmentWithDatatype {
    private String m_separator = ", ";
    private boolean m_funcFormat;
    private boolean m_commutative;

    public Operation() {
    }

    public Operation(SQLFragment[] sQLFragmentArray) {
        this.setArguments(sQLFragmentArray);
    }

    protected void setFunctionFormat(boolean bl) {
        this.m_funcFormat = bl;
    }

    protected void setCommutative(boolean bl) {
        this.m_commutative = bl;
    }

    public SQLFragment[] getArguments() {
        return this.getChildSupport("arguments").getChildArray(SQLFragment.class);
    }

    public void setArguments(SQLFragment[] sQLFragmentArray) {
        this.checkNewSize(sQLFragmentArray == null ? 0 : sQLFragmentArray.length);
        this.getChildSupport("arguments").setChildArray(sQLFragmentArray);
    }

    public void addArgument(SQLFragment sQLFragment) {
        this.checkNewSize(this.getArgumentCount() + 1);
        this.getChildSupport("arguments").addChild(sQLFragment);
    }

    public void addArgument(int n, SQLFragment sQLFragment) {
        this.checkNewSize(this.getArgumentCount() + 1);
        this.getChildSupport("arguments").addChild(n, sQLFragment);
    }

    public void addArguments(SQLFragment[] sQLFragmentArray) {
        this.checkNewSize(this.getArgumentCount() + sQLFragmentArray.length);
        for (SQLFragment sQLFragment : sQLFragmentArray) {
            this.getChildSupport("arguments").addChild(sQLFragment);
        }
    }

    public boolean removeArgument(SQLFragment sQLFragment) {
        this.checkNewSize(this.getArgumentCount() - 1);
        return this.getChildSupport("arguments").removeChild(sQLFragment);
    }

    @Override
    public DBObjectID getDataTypeID() {
        return null;
    }

    protected void checkNewSize(int n) {
    }

    public int getArgumentCount() {
        return this.getChildSupport("arguments").getChildCount();
    }

    protected abstract String getOperatorText();

    protected void checkArgument(List<SQLFragment> list, SQLFragment sQLFragment) throws IllegalArgumentException {
    }

    protected void setSeparator(String string) {
        this.m_separator = !ModelUtil.hasLength((String)string) ? null : string;
    }

    protected String getSeparator() {
        return this.m_separator;
    }

    protected String getDistinctText() {
        return "";
    }

    @Override
    public String getSQLText() {
        String string = this.getSeparator();
        List<SQLFragment> list = Arrays.asList(this.getArguments());
        if (this.m_funcFormat) {
            Object object = this.getDistinctText() + this.argsToString(list, this.m_commutative, string, 0);
            object = this.surroundWithBrackets((String)object, true);
            return this.getOperatorText() + (String)object;
        }
        if (string == null) {
            return this.argsToString(list, this.m_commutative, " " + this.getOperatorText() + " ", 0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && list.size() > 0) {
            boolean bl = ModelUtil.areEqual((Object)string, (Object)", ") && list.size() > 2;
            stringBuilder.append(list.iterator().next());
            stringBuilder.append(" ").append(this.getOperatorText()).append(" ");
            String string2 = this.argsToString(list, this.m_commutative, string, 1);
            if (bl) {
                string2 = this.surroundWithBrackets(string2, true);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject abstractDBObject) {
        return super.equalsImpl(abstractDBObject) && ModelUtil.areEqual((Object)((Operation)abstractDBObject).m_separator, (Object)this.m_separator);
    }

    @Override
    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        super.copyToImpl(abstractDBObject, dBObject, iDPolicy);
        ((Operation)abstractDBObject).m_funcFormat = this.m_funcFormat;
        ((Operation)abstractDBObject).m_commutative = this.m_commutative;
        ((Operation)abstractDBObject).m_separator = this.m_separator;
    }
}

