/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.Collection;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.property.Derived;

public class PlSqlReference
extends DBObjectPlSqlFragment {
    public static final String TYPE = "PlSqlReference";

    public PlSqlReference() {
        this.setReferenceType(ReferenceType.DIRECT);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Deprecated
    public void setReferenceID(DBObjectID dBObjectID) {
        if (dBObjectID == null) {
            this.setReferences(null);
        } else {
            DBObjectID[] dBObjectIDArray = new DBObjectID[]{dBObjectID};
            this.setReferences(dBObjectIDArray);
        }
    }

    public DBObjectID getReferenceID() {
        DBObjectID[] dBObjectIDArray = this.getReferences();
        if (dBObjectIDArray.length > 0) {
            return dBObjectIDArray[0];
        }
        DataTypeUsage dataTypeUsage = this.getDataTypeUsage();
        if (dataTypeUsage != null) {
            return dataTypeUsage.getDataTypeID();
        }
        return null;
    }

    public void setReferenceNames(String[] stringArray) {
        this.setProperty("referenceNames", stringArray);
    }

    public String[] getReferenceNames() {
        return (String[])this.getProperty("referenceNames");
    }

    public void setReferences(DBObjectID[] dBObjectIDArray) {
        this.getChildSupport("references").setChildArray(dBObjectIDArray);
    }

    @Derived(value="referenceNames")
    public DBObjectID[] getReferences() {
        return this.getChildSupport("references").getChildArray(DBObjectID.class);
    }

    public void setReferenceType(ReferenceType referenceType) {
        this.setProperty("referenceType", (Object)referenceType);
    }

    public ReferenceType getReferenceType() {
        return (ReferenceType)((Object)this.getProperty("referenceType"));
    }

    public void setDataTypeUsageSource(String string) {
        if (this.getReferenceType() != ReferenceType.DIRECT) {
            throw new IllegalStateException("setting the DataTypeUsage string string is only allowed for DIRECT References");
        }
        this.setProperty("dataTypeUsageSource", string);
    }

    public String getDataTypeUsageSource() {
        return (String)this.getProperty("dataTypeUsageSource");
    }

    public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
        this.setProperty("dataTypeUsage", dataTypeUsage);
    }

    @Derived(value="dataTypeUsageSource")
    public DataTypeUsage getDataTypeUsage() {
        return (DataTypeUsage)this.getProperty("dataTypeUsage");
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        super.getReferenceIDsImpl(collection);
    }

    @Override
    public String toString() {
        String[] stringArray = this.getReferenceNames();
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (String string : stringArray) {
                if (!bl) {
                    stringBuilder.append('.');
                }
                stringBuilder.append(string);
                bl = false;
            }
            if (this.getReferenceType() == ReferenceType.PCT_TYPE) {
                stringBuilder.append("%TYPE");
            } else if (this.getReferenceType() == ReferenceType.PCT_ROWTYPE) {
                stringBuilder.append("%ROWTYPE");
            } else if (this.getReferenceType() == ReferenceType.REF) {
                stringBuilder.insert(0, "REF ");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static enum ReferenceType {
        DIRECT,
        REF,
        PCT_TYPE,
        PCT_ROWTYPE;

    }
}

