/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.util.Holder;
import oracle.javatools.util.deferred.Thunk;

public final class DBCore {
    private static final String IMPL_CLASS_NAME = "oracle.javatools.db.DBCoreImpl";
    private static DBCore s_instance;
    private static boolean s_initialised;
    private static ClassLoader s_implClassLoader;
    private static Holder<Runnable> s_extensionRunnable;
    private final Map<Class, Object> m_map = new HashMap<Class, Object>();
    private final Map<Class, List<? extends Thunk>> m_lists = new HashMap<Class, List<? extends Thunk>>();
    private final Map<Class, Map<String, Thunk>> m_maps = new HashMap<Class, Map<String, Thunk>>();

    private DBCore() {
    }

    public <T> void registerFactoryList(Class clazz, List<? extends Thunk> list) {
        if (clazz != null && list != null) {
            this.m_lists.put(clazz, list);
        }
    }

    public <T> void registerFactoryMap(Class clazz, Map<String, Thunk> map) {
        if (clazz != null && map != null) {
            this.m_maps.put(clazz, map);
        }
    }

    public Map<String, Thunk> getFactoryMap(Class clazz) {
        return this.m_maps.get(clazz);
    }

    public <T> T getRegisteredFactory(Class<T> clazz, String string) {
        Thunk thunk;
        Object object = null;
        Map<String, Thunk> map = this.getFactoryMap(clazz);
        if (map != null && (thunk = map.get(string)) != null) {
            try {
                object = thunk.get();
            }
            catch (Exception exception) {
                DBLog.getLogger(clazz).log(Level.SEVERE, "Cannot initialize registered " + clazz.getName(), exception);
            }
        }
        return (T)object;
    }

    public List<? extends Thunk> getFactoryList(Class clazz) {
        return this.m_lists.get(clazz);
    }

    public <T> void populateFactoryList(Class<T> clazz, List<T> list) {
        List<? extends Thunk> list2 = this.getFactoryList(clazz);
        this.populateFactoryList(clazz, list, list2);
    }

    public <T> void populateFactoryList(Class<T> clazz, List<T> list, Iterable<? extends Thunk> iterable) {
        if (iterable != null) {
            for (Thunk thunk : iterable) {
                try {
                    Object object = thunk.get();
                    if (object == null) continue;
                    list.add(object);
                }
                catch (Exception exception) {
                    DBLog.getLogger(clazz).log(Level.SEVERE, "Cannot initialize registered " + clazz.getName(), exception);
                }
            }
        }
    }

    public void put(Object object) {
        this.m_map.put(object.getClass(), object);
    }

    public <T> T get(Class<T> clazz) {
        return (T)this.m_map.get(clazz);
    }

    public <T> T remove(Class<T> clazz) {
        return (T)this.m_map.remove(clazz);
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DBCore.class);
    }

    private static void init() {
        try {
            Class<?> clazz = DBCore.getImplClassLoader().loadClass(IMPL_CLASS_NAME);
            clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            DBCore.getLogger().severe("Cannot instantiate core database API implementation.");
        }
        catch (IllegalAccessException illegalAccessException) {
            DBCore.getLogger().severe("Cannot instantiate core database API implementation.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            DBCore.getLogger().severe("Cannot find core database API implementation. Is dbapi-impl.jar on the classpath?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBCore getInstance() {
        if (s_initialised) return s_instance;
        Class<DBCore> clazz = DBCore.class;
        synchronized (DBCore.class) {
            if (s_instance != null) return s_instance;
            s_instance = new DBCore();
            DBCore.init();
            s_initialised = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    public static synchronized void setImplClassLoader(ClassLoader classLoader) {
        if (s_implClassLoader != null) {
            DBCore.getLogger().severe("core already initialized");
        } else {
            s_implClassLoader = classLoader;
        }
    }

    public static ClassLoader getImplClassLoader() {
        if (s_implClassLoader == null) {
            return DBCore.class.getClassLoader();
        }
        return s_implClassLoader;
    }

    public static synchronized void setExtensionInitializer(Runnable runnable) {
        if (s_extensionRunnable != null) {
            DBCore.getLogger().severe("runnable already initialized");
        } else {
            s_extensionRunnable = new Holder((Object)runnable);
        }
    }

    public static synchronized void checkExtensionInitialization() {
        Runnable runnable;
        if (s_extensionRunnable != null && (runnable = (Runnable)s_extensionRunnable.get()) != null) {
            runnable.run();
            s_extensionRunnable.set(null);
        }
    }
}

