/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.util.ModelUtil;

public class DBLog {
    private static final String BASE_LOG_NAME = "oracle.javatools.db";
    private static final String SQL_LOG_NAME = "oracle.javatools.db.statement";
    private static final String LOG_PROPERTY = "db.log";
    private static final String DEBUG_PROPERTY = "db.debug";
    private static Map<String, Logger> s_loggers = new HashMap<String, Logger>();

    @Deprecated
    public static final Logger getLogger() {
        return DBLog.getAndInitialiseLogger(BASE_LOG_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Logger getLogger(Object object) {
        Object object2;
        String string = null;
        if (object == null) {
            string = null;
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            object2 = DBUtil.decodeArrayClass(object instanceof Class ? (Class<?>)object : object.getClass());
            string = ((Class)object2).getName();
        }
        if (string == null || !string.startsWith("oracle.") || !string.contains("db") && !string.contains("report")) {
            string = BASE_LOG_NAME;
        }
        string = string.replace("$", ".");
        object2 = Logger.getLogger(string);
        Map<String, Logger> map = s_loggers;
        synchronized (map) {
            if (!s_loggers.containsKey(string)) {
                DBLog.initLogger((Logger)object2);
                s_loggers.put(string, (Logger)object2);
            }
        }
        return object2;
    }

    @Deprecated
    public static final synchronized Logger getAndInitialiseLogger(String string) {
        return DBLog.getLogger(string);
    }

    @Deprecated
    public static final Level getTimingLogLevel() {
        return Level.FINER;
    }

    @Deprecated
    public static final Level getTraceLogLevel() {
        return Level.FINER;
    }

    @Deprecated
    public static final Level getEventLogLevel() {
        return Level.FINE;
    }

    public static boolean isDebug() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!bl) {
            bl = Boolean.getBoolean(LOG_PROPERTY) || Boolean.getBoolean(DEBUG_PROPERTY);
        }
        return bl;
    }

    public static final Level getExceptionLogLevel() {
        return DBLog.isDebug() ? Level.SEVERE : Level.WARNING;
    }

    public static void logIllegalState(String string) {
        IllegalStateException illegalStateException = new IllegalStateException(string);
        StackTraceElement[] stackTraceElementArray = illegalStateException.getStackTrace();
        int n = DBLog.getStackDepth(stackTraceElementArray);
        if (n > 0) {
            StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - n];
            System.arraycopy(stackTraceElementArray, n, stackTraceElementArray2, 0, stackTraceElementArray2.length);
            illegalStateException.setStackTrace(stackTraceElementArray2);
        }
        DBLog.logStackTrace(illegalStateException);
    }

    private static int getStackDepth(StackTraceElement[] stackTraceElementArray) {
        int n = -1;
        for (int i = 1; i < stackTraceElementArray.length; ++i) {
            String string;
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (stackTraceElement == null || (string = stackTraceElement.getClassName()) == null || string.equals(DBLog.class.getName())) continue;
            n = i;
            break;
        }
        return n;
    }

    public static final void logStackTrace(Throwable throwable) {
        DBLog.logStackTrace(throwable.getMessage(), throwable);
    }

    public static final void logStackTrace(String string, Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        int n = DBLog.getStackDepth(stackTraceElementArray);
        if (n >= 0) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            DBLog.getLogger(stackTraceElement.getClassName()).logp(DBLog.getExceptionLogLevel(), stackTraceElement.getClassName(), stackTraceElement.getMethodName(), string, throwable);
        } else {
            DBLog.getLogger(BASE_LOG_NAME).log(DBLog.getExceptionLogLevel(), string, throwable);
        }
    }

    @Deprecated
    public static final void log(String string, Object ... objectArray) {
        DBLog.getLogger().log(DBLog.getTraceLogLevel(), string, objectArray);
    }

    @Deprecated
    public static final void logDifferences(DBObject dBObject, DBObject dBObject2, DBObjectProvider dBObjectProvider) {
    }

    public static final Logger getSQLLog() {
        return DBLog.getLogger(SQL_LOG_NAME);
    }

    private static void initLogger(Logger logger) {
        block7: {
            try {
                String string = System.getProperty(LOG_PROPERTY);
                if (!ModelUtil.hasLength((String)string)) break block7;
                Level level = null;
                if (Boolean.valueOf(string).booleanValue()) {
                    level = Level.ALL;
                } else {
                    try {
                        level = Level.parse(string.toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (level != null) {
                    logger.setLevel(level);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

