/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Map;
import java.util.logging.Logger;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDBObjectID
implements DBObjectID {
    private DBObjectID m_parent;
    private String m_type;

    protected AbstractDBObjectID() {
    }

    protected AbstractDBObjectID(String string) {
        this.m_type = string;
    }

    protected AbstractDBObjectID(String string, DBObjectID dBObjectID) {
        this.m_type = string;
        this.m_parent = dBObjectID;
    }

    @Override
    public final String getType() {
        return this.m_type;
    }

    public final void setType(String string) {
        if (!ModelUtil.hasLength((String)string) || "null".equals(string)) {
            string = null;
        }
        if (ModelUtil.hasLength((String)this.m_type) && ModelUtil.areDifferent((Object)this.m_type, (Object)"UNSPECIFIED_TYPE") && ModelUtil.areDifferent((Object)this.m_type, (Object)string)) {
            throw new IllegalStateException("cannot change the type of a DBObjectID");
        }
        this.m_type = string;
    }

    @Override
    public final DBObjectID getParent() {
        return this.m_parent;
    }

    public void setParent(DBObjectID dBObjectID) {
        if (dBObjectID == this) {
            throw new IllegalArgumentException("A DBObjectID cannot parent itself");
        }
        this.m_parent = dBObjectID;
    }

    protected final DBObject resolveFromParent() throws DBException {
        DBObject dBObject;
        if (this.m_parent != null && (dBObject = this.m_parent.resolveID()) != null) {
            return this.resolveInParentObject(dBObject);
        }
        return null;
    }

    public DBObject resolveInParentObject(DBObject dBObject) throws DBException {
        return dBObject.findOwnedObject(this);
    }

    public final boolean equals(Object object) {
        return object instanceof DBObjectID && this.equals((DBObjectID)object, true);
    }

    @Override
    public final boolean equals(DBObjectID dBObjectID, boolean bl) {
        boolean bl2 = false;
        if (dBObjectID != null) {
            bl2 = dBObjectID instanceof TemporaryObjectID || dBObjectID instanceof ReferenceID && !(this instanceof ReferenceID) ? dBObjectID.equals(this, bl) : this.equalsImpl(dBObjectID, bl) && this.hasSameParent(dBObjectID, bl);
        }
        return bl2;
    }

    protected boolean hasSameParent(DBObjectID dBObjectID, boolean bl) {
        boolean bl2;
        DBObjectID dBObjectID2 = dBObjectID.getParent();
        if (this.m_parent == dBObjectID2) {
            bl2 = true;
        } else if (this.m_parent == null || dBObjectID2 == null) {
            DBObjectID dBObjectID3 = this.m_parent == null ? dBObjectID : this;
            DBObjectID dBObjectID4 = this.m_parent == null ? this : dBObjectID;
            DBObjectID dBObjectID5 = dBObjectID3.getParent();
            if (dBObjectID4 instanceof BaseObjectID && dBObjectID5 instanceof BaseObjectID && "UNSPECIFIED_TYPE".equals(dBObjectID5.getType())) {
                String string = ((BaseObjectID)dBObjectID5).getName();
                String string2 = ((BaseObjectID)dBObjectID4).getSchemaName();
                bl2 = string != null && string.equals(string2);
            } else {
                bl2 = dBObjectID3 instanceof AbstractDBObjectID && ((AbstractDBObjectID)dBObjectID3).canEquateWithNullParent(dBObjectID4);
            }
        } else {
            bl2 = this.m_parent.equals(dBObjectID2, bl);
        }
        return bl2;
    }

    protected boolean canEquateWithNullParent(DBObjectID dBObjectID) {
        return dBObjectID instanceof IdentifierBasedID && Metadata.getInstance().isTypeOf(SystemObject.class, this.m_type) && ModelUtil.areEqual((Object)this.m_type, (Object)dBObjectID.getType());
    }

    protected abstract boolean equalsImpl(DBObjectID var1, boolean var2);

    protected boolean equalsImpl(AbstractDBObjectID abstractDBObjectID) {
        return ModelUtil.areEqual((Object)this.m_type, (Object)abstractDBObjectID.m_type) || ModelUtil.areEqual((Object)"UNSPECIFIED_TYPE", (Object)abstractDBObjectID.m_type) || ModelUtil.areEqual((Object)this.m_type, (Object)"UNSPECIFIED_TYPE");
    }

    protected void copyToImpl(AbstractDBObjectID abstractDBObjectID) {
        abstractDBObjectID.m_type = this.m_type;
        abstractDBObjectID.m_parent = this.m_parent == null ? null : (DBObjectID)this.m_parent.copyTo(null);
    }

    public final int hashCode() {
        AbstractDBObjectID abstractDBObjectID = this;
        if (abstractDBObjectID.getType() == null) {
            abstractDBObjectID = (AbstractDBObjectID)abstractDBObjectID.copyTo(null);
            abstractDBObjectID.setType("UNSPECIFIED_TYPE");
        }
        return abstractDBObjectID.toString().hashCode();
    }

    public abstract String toString();

    public static <T extends AbstractDBObjectID> T copyWithNewType(T t, Map<String, String> map) {
        AbstractDBObjectID abstractDBObjectID;
        for (DBObjectID dBObjectID = abstractDBObjectID = (AbstractDBObjectID)t.copyTo(null); dBObjectID != null; dBObjectID = dBObjectID.getParent()) {
            if (dBObjectID instanceof AbstractDBObjectID) {
                String string = map.get(dBObjectID.m_type);
                if (string == null) continue;
                dBObjectID.m_type = string;
                continue;
            }
            abstractDBObjectID = null;
            break;
        }
        return (T)abstractDBObjectID;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }
}

