/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.ide.Ide;

public class MessageDialog
implements ActionListener,
ComponentListener {
    public static final Type ERROR = Type.ERROR;
    public static final Type INFORMATION = Type.INFORMATION;
    public static final Type PLAIN = Type.PLAIN;
    public static final Type QUESTION = Type.QUESTION;
    public static final Type WARNING = Type.WARNING;
    private Type type = Type.INFORMATION;
    private String title = null;
    private List<Object> contents = new ArrayList<Object>();
    private Throwable exception;
    private Object[] commands = null;
    private OptionPane pane;
    private JDialog dialog;
    private boolean resizeable;

    public MessageDialog() {
    }

    public MessageDialog(Type type) {
        this.setType(type);
    }

    public void addContent(Object ... content) {
        for (Object c : content) {
            this.contents.add(c);
        }
    }

    public void setCommands(Object ... commands) {
        this.commands = commands;
    }

    public void setContent(Object ... content) {
        this.contents.clear();
        this.addContent(content);
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public void setResizeable(boolean resizeable) {
        this.resizeable = resizeable;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Object show() {
        return this.show(null);
    }

    public Object show(Component parent) {
        if (parent == null) {
            parent = Ide.getMainWindow();
        }
        if (this.commands == null) {
            this.commands = new String[]{"Close"};
        }
        for (Object command : this.commands) {
            if (!(command instanceof AbstractButton)) continue;
            ((AbstractButton)command).addActionListener(this);
        }
        this.pane = new OptionPane((Object)this.contents.toArray(), this.type, this.commands);
        this.dialog = this.pane.createDialog(parent, this.title);
        this.dialog.setResizable(this.resizeable);
        this.dialog.addComponentListener(this);
        this.dialog.setVisible(true);
        for (Object command : this.commands) {
            if (!(command instanceof AbstractButton)) continue;
            ((AbstractButton)command).removeActionListener(this);
        }
        return this.pane.getValue();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        AbstractButton source = (AbstractButton)event.getSource();
        this.pane.setValue(source);
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension min = this.dialog.getMinimumSize();
        if (this.dialog.getWidth() < min.width || this.dialog.getHeight() < min.height) {
            this.dialog.setSize(Math.max(min.width, this.dialog.getWidth()), Math.max(min.height, this.dialog.getHeight()));
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public static class Type {
        public static final Type ERROR = new Type(0);
        public static final Type INFORMATION = new Type(1);
        public static final Type PLAIN = new Type(-1);
        public static final Type QUESTION = new Type(3);
        public static final Type WARNING = new Type(2);
        private int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    protected static class OptionPane
    extends JOptionPane {
        public OptionPane(Object message, Type type, Object[] options) {
            super(message, type.getValue(), -1, null, options, options[0]);
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 80;
        }
    }
}

