/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;

public class TransformContext {
    private final Shape shape;
    private final TransformAdapter adapter;
    private final Transform transform;
    private final Violation violation;
    private final Location location;
    private final URL initialLocation;
    private final URL pendingLocation;
    private final Project pendingProject;
    private final Workspace pendingWorkspace;
    private Location relocation;
    private Map<String, Object> attributes;
    private Object applyData;

    protected TransformContext(TransformAdapter adapter, Shape shape, Transform transform, Violation violation, Location location, URL pendingLocation, Project pendingProject, Workspace pendingWorkspace) {
        if (adapter == null) {
            throw new NullArgumentException("null adapter");
        }
        if (shape == null) {
            throw new NullArgumentException("null adapter");
        }
        if (transform == null) {
            throw new NullArgumentException("null adapter");
        }
        if (violation == null) {
            throw new NullArgumentException("null adapter");
        }
        if (location == null && pendingLocation == null) {
            throw new NullArgumentException("location and pending location both null");
        }
        if (pendingLocation == null && pendingProject != null) {
            throw new IllegalArgumentException("pending location null but pending project not");
        }
        if (pendingLocation == null && pendingWorkspace != null) {
            throw new IllegalArgumentException("pending location null but pending workspace not");
        }
        switch (shape) {
            case READ: {
                if (location == null) {
                    throw new NullArgumentException("null location");
                }
                if (pendingLocation == null) break;
                throw new IllegalArgumentException("pending location not null");
            }
            case WRITE: {
                if (location != null && pendingLocation != null) {
                    throw new IllegalArgumentException("location and pending location both not null");
                }
                if (pendingLocation != null && pendingProject == null) {
                    throw new NullArgumentException("null pending project");
                }
                if (pendingLocation == null || pendingWorkspace != null) break;
                throw new NullArgumentException("null pending workspace");
            }
            case CREATE: {
                if (pendingLocation == null) {
                    throw new NullArgumentException("pending location null");
                }
                if (pendingProject == null) {
                    throw new NullArgumentException("null pending project");
                }
                if (pendingWorkspace != null) break;
                throw new NullArgumentException("null pending workspace");
            }
            case DELETE: {
                if (location != null) break;
                throw new NullArgumentException("null location");
            }
            case MOVE: {
                if (location == null) {
                    throw new NullArgumentException("null location");
                }
                if (pendingLocation == null) {
                    throw new NullArgumentException("pending location null");
                }
                if (pendingProject == null) {
                    throw new NullArgumentException("null pending project");
                }
                if (pendingWorkspace != null) break;
                throw new NullArgumentException("null pending workspace");
            }
        }
        if (location != null) {
            Class<? extends ModelAdapter> type;
            Class<?> modelType = location.getModel().getClass();
            Collection<Class<? extends ModelAdapter>> types = this.getModelAdapterTypes();
            if (types == null) {
                types = Collections.emptyList();
            }
            boolean matched = types.isEmpty();
            Iterator<Class<? extends ModelAdapter>> iterator = types.iterator();
            while (iterator.hasNext() && !(matched = (type = iterator.next()).isAssignableFrom(modelType))) {
            }
            if (!matched) {
                StringBuilder builder = new StringBuilder(modelType.getName());
                builder.append(" does not extend ");
                if (types.size() == 1) {
                    builder.append(types.iterator().next().getName());
                } else {
                    boolean first = true;
                    Iterator<Class<? extends ModelAdapter>> iterator2 = types.iterator();
                    while (iterator2.hasNext()) {
                        Class<? extends ModelAdapter> type2 = iterator2.next();
                        if (first) {
                            builder.append("one of ");
                        } else if (iterator2.hasNext()) {
                            builder.append(", ");
                        } else {
                            builder.append(types.size() == 2 ? " or " : ", or ");
                        }
                        builder.append(type2.getName());
                        first = false;
                    }
                }
                throw new IllegalArgumentException(builder.toString());
            }
        }
        this.shape = shape;
        this.adapter = adapter;
        this.transform = transform;
        this.violation = violation;
        this.location = location;
        this.initialLocation = location != null ? location.getModel().getUrl(location) : null;
        this.pendingLocation = pendingLocation;
        this.pendingProject = pendingProject;
        this.pendingWorkspace = pendingWorkspace;
    }

    public void relocate(Location location) {
        if (this.shape != Shape.WRITE && this.pendingLocation != null) {
            throw new IllegalStateException("context not relocatable");
        }
        if (this.relocation != null) {
            throw new IllegalStateException("context already relocated");
        }
        this.relocation = location;
    }

    protected TransformContext(TransformAdapter adapter, Transform transform, Violation violation, Location location) {
        this(adapter, Shape.WRITE, transform, violation, location, null, null, null);
    }

    public Collection<Class<? extends ModelAdapter>> getModelAdapterTypes() {
        return Collections.singletonList(ModelAdapter.class);
    }

    public Shape getShape() {
        return this.shape;
    }

    public TransformAdapter getAdapter() {
        return this.adapter;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Violation getViolation() {
        return this.violation;
    }

    public Location getLocation() {
        return this.relocation != null ? this.relocation : this.location;
    }

    public URL getInitialLocation() {
        return this.initialLocation;
    }

    public URL getPendingLocation() {
        return this.pendingLocation;
    }

    public Project getPendingProject() {
        return this.pendingProject;
    }

    public Workspace getPendingWorkspace() {
        return this.pendingWorkspace;
    }

    public ModelAdapter getModel() {
        Location location = this.getLocation();
        return location != null ? location.getModel() : null;
    }

    public ModelAdapter getModelAdapter() {
        return this.getModel();
    }

    public Node getNode() {
        ModelAdapter model = this.getModel();
        return model != null ? model.getNode() : null;
    }

    public Project getProject() {
        Location location = this.getLocation();
        return location != null ? location.getProject() : this.pendingProject;
    }

    public Workspace getWorkspace() {
        Location location = this.getLocation();
        return location != null ? location.getWorkspace() : this.pendingWorkspace;
    }

    public Context getIdeContext() {
        return new Context(null, this.getWorkspace(), this.getProject(), this.getNode());
    }

    public Rule getRule() {
        return this.violation.getRule();
    }

    public String getVariation() {
        return this.violation.getVariation();
    }

    public Object getParameter(String name) {
        char c;
        int nameLength = name.length();
        if (nameLength == 1 && Character.isDigit(c = name.charAt(0))) {
            int index = c - 48;
            if (index >= this.getParameterCount()) {
                return null;
            }
            return this.getParameterValue(index);
        }
        Object parameter = this.getParameterValue(name);
        if (parameter != null) {
            return parameter;
        }
        StringBuffer methodName = new StringBuffer(3 + nameLength);
        methodName.append("get");
        if (nameLength <= 1) {
            methodName.append(name.charAt(0));
        } else {
            methodName.append(Character.toUpperCase(name.charAt(0)));
            methodName.append(name.substring(1, nameLength));
        }
        try {
            Method method = this.transform.getClass().getMethod(methodName.toString(), null);
            return method.invoke((Object)this.transform, null);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Location getFocusLocation() {
        return this.violation.getFocusLocation();
    }

    public int getParameterCount() {
        return this.violation.getParameterCount();
    }

    public String getParameterName(int index) {
        return this.violation.getParameterName(index);
    }

    public Object getParameterValue(int index) {
        return this.violation.getParameterValue(index);
    }

    public Object getParameterValue(String name) {
        int i = this.getParameterCount();
        while (i-- > 0) {
            if (!name.equals(this.getParameterName(i))) continue;
            return this.getParameterValue(i);
        }
        return null;
    }

    public int getTransformCount() {
        return this.violation.getTransformCount();
    }

    public Transform getTransform(int index) {
        return this.violation.getTransform(index);
    }

    public Transform getDefaultTransform() {
        return this.violation.getDefaultTransform();
    }

    public int getSerialNumber() {
        return this.violation.getSerialNumber();
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Object getPredecessorApplyData() {
        return this.applyData;
    }

    public void setSelection(Object construct, int margin, int endMargin) {
        this.setSelection(this.getModel(), construct, margin, endMargin);
    }

    public void setSelection(ModelAdapter model, Object construct, int margin, int endMargin) {
        this.adapter.setSelection(model, construct, margin, endMargin);
    }

    public void addHighlight(Object construct) {
        this.adapter.addHighlight(this.location.getModel(), construct);
    }

    public void addRemovedHighlight(Object construct) {
        this.adapter.addRemovedHighlight(this.location.getModel(), construct);
    }

    public void invokeLater(Command command) {
        this.adapter.invokeLater(command);
    }

    protected void setPredecessorApplyData(Object applyData) {
        this.applyData = applyData;
    }

    public String toString() {
        String at = this.initialLocation != null ? " at " + URLFileSystem.getPlatformPathName((URL)this.initialLocation) : "";
        String to = this.pendingLocation != null ? " to " + URLFileSystem.getFileName((URL)this.pendingLocation) : "";
        return this.transform.getClass().getSimpleName() + "/" + this.getClass().getSimpleName() + "/" + this.shape + at + to;
    }

    public void setSelection(Object construct, boolean before, boolean after) {
        this.setSelection(this.getModelAdapter(), construct, before, after);
    }

    public void setSelection(ModelAdapter model, Object construct, boolean before, boolean after) {
        int selectionMargin;
        int selectionEndMargin;
        if (model == null) {
            throw new IllegalArgumentException("model null");
        }
        if (construct == null) {
            throw new IllegalArgumentException("construct null");
        }
        if (before == after) {
            selectionEndMargin = 0;
            selectionMargin = 0;
        } else {
            selectionMargin = before ? 0 : Integer.MAX_VALUE;
            selectionEndMargin = after ? 0 : Integer.MAX_VALUE;
        }
        this.setSelection(model, construct, selectionMargin, selectionEndMargin);
    }

    public static enum Shape {
        READ,
        WRITE,
        CREATE,
        DELETE,
        MOVE;

    }
}

