/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.ExtensionRegistry;
import oracle.jdeveloper.audit.extension.DefinitionContext;
import oracle.jdevimpl.audit.util.Strings;
import org.xml.sax.Locator;

public abstract class Definition
implements Locator {
    private DefinitionContext context;
    private boolean loaded;

    Definition(DefinitionContext context) {
        this.context = context;
    }

    protected DefinitionContext getContext() {
        return this.context;
    }

    public String getExtensionId() {
        return this.context.getExtensionId();
    }

    @Override
    public String getPublicId() {
        return this.context.getPublicId();
    }

    @Override
    public String getSystemId() {
        return this.context.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return this.context.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.context.getColumnNumber();
    }

    public boolean isExtensionLoaded() {
        return this.loaded || (this.loaded = ExtensionRegistry.getExtensionRegistry().isFullyLoaded(this.getExtensionId()));
    }

    public void log(Level level, String message, Object ... parameters) {
        this.log(level, null, message, parameters);
    }

    public void log(Level level, Throwable thrown, String message, Object ... parameters) {
        ExtensionLogRecord record = new ExtensionLogRecord((Locator)this, level, message);
        if (thrown != null) {
            record.setThrown(thrown);
        }
        if (parameters != null && parameters.length > 0) {
            record.setParameters(parameters);
        }
        ExtensionRegistry.getExtensionRegistry().getManifestLogger().log((LogRecord)record);
    }

    public String getTypeDescription() {
        return Strings.separateCamelCase(Strings.removeSuffix(this.getClass().getSimpleName(), "Definition"), ' ').toLowerCase();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.getSystemId() + ":" + this.getLineNumber() + ")";
    }
}

