/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.util;

import java.text.DateFormatSymbols;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import oracle.core.ojdl.util.TimestampFormat;

public class CLFTimestampFormat
extends TimestampFormat {
    private Calendar m_calendar = new GregorianCalendar();
    private int m_year = Integer.MIN_VALUE;
    private int m_month = Integer.MIN_VALUE;
    private int m_day = Integer.MIN_VALUE;
    private long m_baseTime = 0L;
    private boolean m_hasBrackets;
    private HashMap m_months = new HashMap();
    private char[] m_monthCache = new char[]{' ', ' ', ' '};
    private int m_monthVal = -1;

    public CLFTimestampFormat() {
        this(false, Locale.getDefault());
    }

    public CLFTimestampFormat(boolean hasBrackets) {
        this(hasBrackets, Locale.getDefault());
    }

    public CLFTimestampFormat(boolean hasBrackets, Locale locale) {
        this.m_calendar.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        this.m_calendar.setLenient(false);
        this.m_hasBrackets = hasBrackets;
        this.initMonths(locale);
    }

    @Override
    public long parse(String str, ParsePosition pos) {
        return this.parse(str.toCharArray(), pos);
    }

    @Override
    public long parse(String str) {
        return this.parse(str.toCharArray(), new ParsePosition(0));
    }

    @Override
    public long parse(char[] chars, ParsePosition parsePos) {
        char sign;
        int limit = chars.length;
        int pos = parsePos.getIndex();
        int nchars = limit - pos;
        if (this.m_hasBrackets && nchars < 26) {
            return Long.MIN_VALUE;
        }
        if (nchars < 24) {
            return Long.MIN_VALUE;
        }
        if (this.m_hasBrackets && chars[pos++] != '[') {
            return Long.MIN_VALUE;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int fraction = 0;
        int tzHour = 0;
        int tzMin = 0;
        int d0 = CLFTimestampFormat.digit(chars[pos++]);
        int d1 = CLFTimestampFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        day = d0 * 10 + d1;
        if (chars[pos++] != '/') {
            return Long.MIN_VALUE;
        }
        int monthBegin = pos;
        while (pos < nchars && chars[pos++] != '/') {
        }
        if (pos >= nchars) {
            return Long.MIN_VALUE;
        }
        month = this.getMonth(chars, monthBegin, pos);
        if (month < 0) {
            return Long.MIN_VALUE;
        }
        nchars = limit - pos;
        if (this.m_hasBrackets && nchars < 20) {
            return Long.MIN_VALUE;
        }
        if (nchars < 19) {
            return Long.MIN_VALUE;
        }
        d0 = CLFTimestampFormat.digit(chars[pos++]);
        d1 = CLFTimestampFormat.digit(chars[pos++]);
        int d2 = CLFTimestampFormat.digit(chars[pos++]);
        int d3 = CLFTimestampFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0 || d2 < 0 || d3 < 0) {
            return Long.MIN_VALUE;
        }
        year = d0 * 1000 + d1 * 100 + d2 * 10 + d3;
        if (chars[pos++] != ':') {
            return Long.MIN_VALUE;
        }
        d0 = CLFTimestampFormat.digit(chars[pos++]);
        d1 = CLFTimestampFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        hour = d0 * 10 + d1;
        if (chars[pos++] != ':') {
            return Long.MIN_VALUE;
        }
        d0 = CLFTimestampFormat.digit(chars[pos++]);
        d1 = CLFTimestampFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        minute = d0 * 10 + d1;
        if (chars[pos++] != ':') {
            return Long.MIN_VALUE;
        }
        d0 = CLFTimestampFormat.digit(chars[pos++]);
        d1 = CLFTimestampFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        second = d0 * 10 + d1;
        fraction = 0;
        if (chars[pos] == '.') {
            d0 = 0;
            d1 = 0;
            d2 = 0;
            if (++pos < limit && (d0 = CLFTimestampFormat.digit(chars[pos])) >= 0) {
                if (++pos < limit && (d1 = CLFTimestampFormat.digit(chars[pos])) >= 0) {
                    if (++pos < limit && (d2 = CLFTimestampFormat.digit(chars[pos])) >= 0) {
                        ++pos;
                    } else {
                        d2 = 0;
                    }
                } else {
                    d1 = 0;
                }
            } else {
                d0 = 0;
            }
            fraction = d0 * 100 + d1 * 10 + d2;
            while (pos < limit && CLFTimestampFormat.digit(chars[pos]) >= 0) {
                ++pos;
            }
        }
        if (chars[pos++] != ' ') {
            return Long.MIN_VALUE;
        }
        int tzSign = 0;
        if ((sign = chars[pos++]) == '-') {
            tzSign = -1;
        } else if (sign == '+') {
            tzSign = 1;
        } else {
            return Long.MIN_VALUE;
        }
        d0 = CLFTimestampFormat.digit(chars[pos++]);
        d1 = CLFTimestampFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        tzHour = d0 * 10 + d1;
        if (tzHour > 23) {
            return Long.MIN_VALUE;
        }
        d0 = CLFTimestampFormat.digit(chars[pos++]);
        d1 = CLFTimestampFormat.digit(chars[pos++]);
        if (d0 < 0 || d1 < 0) {
            return Long.MIN_VALUE;
        }
        tzMin = d0 * 10 + d1;
        if (tzMin > 59) {
            return Long.MIN_VALUE;
        }
        int tzOffset = tzSign * (tzHour * 60 + tzMin) * 60000;
        if (this.m_hasBrackets && chars[pos++] != ']') {
            return Long.MIN_VALUE;
        }
        parsePos.setIndex(pos);
        if (hour > 24 || minute > 59 || second > 59) {
            return Long.MIN_VALUE;
        }
        if (year != this.m_year || month != this.m_month || day != this.m_day) {
            this.m_calendar.clear();
            try {
                this.m_calendar.set(year, month, day);
                this.m_baseTime = this.m_calendar.getTime().getTime();
            }
            catch (Exception e) {
                return Long.MIN_VALUE;
            }
            this.m_year = year;
            this.m_month = month;
            this.m_day = day;
        }
        return this.m_baseTime + (long)(((hour * 60 + minute) * 60 + second) * 1000) + (long)fraction - (long)tzOffset;
    }

    private int getMonth(char[] chars, int beg, int end) {
        int len = end - beg - 1;
        if (len == 3 && chars[beg] == this.m_monthCache[0] && chars[beg + 1] == this.m_monthCache[1] && chars[beg + 2] == this.m_monthCache[2]) {
            return this.m_monthVal;
        }
        String month = new String(chars, beg, end - beg - 1).toLowerCase();
        Integer val = (Integer)this.m_months.get(month);
        if (val != null) {
            if (len == 3) {
                this.m_monthCache[0] = chars[beg];
                this.m_monthCache[1] = chars[beg + 1];
                this.m_monthCache[2] = chars[beg + 2];
                this.m_monthVal = val;
            }
            return val;
        }
        return -1;
    }

    private void initMonths(Locale locale) {
        String[] shortMonths = new DateFormatSymbols(locale).getShortMonths();
        for (int i = 0; i < 12; ++i) {
            if (i >= shortMonths.length || shortMonths[i] == null) continue;
            String month = shortMonths[i].toLowerCase();
            this.m_months.put(month, new Integer(i));
        }
    }

    private static final int digit(char ch) {
        return ch >= '0' && ch <= '9' ? ch - 48 : -1;
    }
}

